/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import at.dallermassl.josm.plugin.surveyor.SurveyorAction;
import java.util.HashMap;
import java.util.Map;

public final class SurveyorActionFactory {
    private static Map<String, SurveyorAction> actionCache = new HashMap<String, SurveyorAction>();
    public static final String DEFAULT_PACKAGE = SurveyorActionFactory.class.getPackage().getName() + ".action";

    private SurveyorActionFactory() {
    }

    public static SurveyorAction getInstance(String actionClass) {
        try {
            SurveyorAction action = actionCache.get(actionClass);
            if (action == null) {
                try {
                    action = (SurveyorAction)Class.forName(actionClass).newInstance();
                }
                catch (ClassNotFoundException e) {
                    actionClass = DEFAULT_PACKAGE + "." + actionClass;
                    action = (SurveyorAction)Class.forName(actionClass).newInstance();
                }
                actionCache.put(actionClass, action);
            }
            return action;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not create action class '" + actionClass + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not create action class '" + actionClass + "'", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not create action class '" + actionClass + "'", e);
        }
    }
}

