/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.util.InternationalString;

public final class TypeMap {
    private static final TypeMap[] MAP = new TypeMap[SampleDimensionType.values().length];
    private final SampleDimensionType code;
    private final int type;
    private final byte size;
    private final boolean signed;
    private final boolean real;
    private final NumberRange<? extends Number> range;
    private final NumberRange<? extends Number> positiveRange;
    private final InternationalString name = new AbstractInternationalString(){

        @Override
        public String toString(Locale locale) {
            return Vocabulary.getResources(locale).getString(39, TypeMap.this.real ? 2 : (TypeMap.this.signed ? 1 : 0), TypeMap.this.size);
        }
    };

    private TypeMap(SampleDimensionType code, int type, byte size, boolean signed, boolean real, Map<Number, Number> pool) {
        this(code, type, size, signed, real, null, null, pool);
    }

    private TypeMap(SampleDimensionType code, int type, byte size, boolean signed, boolean real, Number lower, Number upper, Map<Number, Number> pool) {
        Number one = null;
        if (lower == null) {
            long min;
            long max = (1L << (signed ? size - 1 : size)) - 1L;
            long l = min = signed ? max ^ 0xFFFFFFFFFFFFFFFFL : 0L;
            if (max <= 127L) {
                lower = (byte)min;
                upper = (byte)max;
                one = (byte)1;
            } else if (max <= 32767L) {
                lower = (short)min;
                upper = (short)max;
                one = (short)1;
            } else if (max <= Integer.MAX_VALUE) {
                lower = (int)min;
                upper = (int)max;
                one = 1;
            } else {
                lower = min;
                upper = max;
                one = 1L;
            }
            lower = TypeMap.unique(pool, lower);
            upper = TypeMap.unique(pool, upper);
            one = TypeMap.unique(pool, one);
            assert (lower.longValue() == min);
            assert (upper.longValue() == max);
        }
        assert (((Comparable)((Object)lower)).compareTo(upper) < 0) : upper;
        Class<?> c = upper.getClass();
        this.code = code;
        this.type = type;
        this.size = (byte)size;
        this.signed = signed;
        this.real = real;
        this.range = new NumberRange<Number>(c, lower, upper);
        this.positiveRange = signed ? null : new NumberRange<Number>(c, one, upper);
        int ordinal = code.ordinal();
        assert (MAP[ordinal] == null) : code;
        TypeMap.MAP[ordinal] = this;
        assert (code.equals(TypeMap.getSampleDimensionType(this.range))) : code;
    }

    private static Number unique(Map<Number, Number> pool, Number n) {
        Number candidate = pool.put(n, n);
        if (candidate == null) {
            return n;
        }
        pool.put(candidate, candidate);
        return candidate;
    }

    public static SampleDimensionType getSampleDimensionType(Range<?> range) {
        Class<?> type = range.getElementClass();
        if (Double.class.isAssignableFrom(type)) {
            return SampleDimensionType.REAL_64BITS;
        }
        if (Float.class.isAssignableFrom(type)) {
            return SampleDimensionType.REAL_32BITS;
        }
        long min = ((Number)range.getMinValue()).longValue();
        long max = ((Number)range.getMaxValue()).longValue();
        if (!range.isMinIncluded()) {
            ++min;
        }
        if (!range.isMaxIncluded()) {
            --max;
        }
        return TypeMap.getSampleDimensionType(min, max);
    }

    public static SampleDimensionType getSampleDimensionType(double min, double max) {
        long lgMax;
        long lgMin = (long)min;
        if ((double)lgMin == min && (double)(lgMax = (long)max) == max) {
            return TypeMap.getSampleDimensionType(lgMin, lgMax);
        }
        if (Math.min(min = Math.abs(min), max = Math.abs(max)) >= (double)1.4E-45f && Math.max(min, max) <= 3.4028234663852886E38) {
            return SampleDimensionType.REAL_32BITS;
        }
        return SampleDimensionType.REAL_64BITS;
    }

    public static SampleDimensionType getSampleDimensionType(long min, long max) {
        if (min >= 0L) {
            if (max < 2L) {
                return SampleDimensionType.UNSIGNED_1BIT;
            }
            if (max < 4L) {
                return SampleDimensionType.UNSIGNED_2BITS;
            }
            if (max < 16L) {
                return SampleDimensionType.UNSIGNED_4BITS;
            }
            if (max < 256L) {
                return SampleDimensionType.UNSIGNED_8BITS;
            }
            if (max < 65536L) {
                return SampleDimensionType.UNSIGNED_16BITS;
            }
            if (max < 0x100000000L) {
                return SampleDimensionType.UNSIGNED_32BITS;
            }
        } else {
            if (min >= -128L && max <= 127L) {
                return SampleDimensionType.SIGNED_8BITS;
            }
            if (min >= -32768L && max <= 32767L) {
                return SampleDimensionType.SIGNED_16BITS;
            }
            if (min >= Integer.MIN_VALUE && max <= Integer.MAX_VALUE) {
                return SampleDimensionType.SIGNED_32BITS;
            }
        }
        return SampleDimensionType.REAL_32BITS;
    }

    public static SampleDimensionType getSampleDimensionType(SampleModel model, int band) throws IllegalArgumentException {
        if (band < 0 || band >= model.getNumBands()) {
            throw new IllegalArgumentException(Errors.format(7, band));
        }
        boolean signed = true;
        switch (model.getDataType()) {
            case 5: {
                return SampleDimensionType.REAL_64BITS;
            }
            case 4: {
                return SampleDimensionType.REAL_32BITS;
            }
            case 0: 
            case 1: {
                signed = false;
            }
            case 2: 
            case 3: {
                switch (model.getSampleSize(band)) {
                    case 1: {
                        return SampleDimensionType.UNSIGNED_1BIT;
                    }
                    case 2: {
                        return SampleDimensionType.UNSIGNED_2BITS;
                    }
                    case 4: {
                        return SampleDimensionType.UNSIGNED_4BITS;
                    }
                    case 5: {
                        return SampleDimensionType.UNSIGNED_8BITS;
                    }
                    case 8: {
                        return signed ? SampleDimensionType.SIGNED_8BITS : SampleDimensionType.UNSIGNED_8BITS;
                    }
                    case 16: {
                        return signed ? SampleDimensionType.SIGNED_16BITS : SampleDimensionType.UNSIGNED_16BITS;
                    }
                    case 32: {
                        return signed ? SampleDimensionType.SIGNED_32BITS : SampleDimensionType.UNSIGNED_32BITS;
                    }
                }
            }
        }
        return null;
    }

    public static InternationalString getName(SampleDimensionType type) {
        int ordinal = type.ordinal();
        if (ordinal >= 0 && ordinal < MAP.length) {
            return TypeMap.MAP[ordinal].name;
        }
        return new SimpleInternationalString(type.name());
    }

    public static int getDataBufferType(SampleDimensionType type) {
        int ordinal;
        if (type != null && (ordinal = type.ordinal()) >= 0 && ordinal < MAP.length) {
            return TypeMap.MAP[ordinal].type;
        }
        return 32;
    }

    public static int getSize(SampleDimensionType type) {
        return TypeMap.map((SampleDimensionType)type).size;
    }

    public static boolean isSigned(SampleDimensionType type) {
        return TypeMap.map((SampleDimensionType)type).signed;
    }

    public static boolean isFloatingPoint(SampleDimensionType type) {
        return TypeMap.map((SampleDimensionType)type).real;
    }

    public static NumberRange<? extends Number> getRange(SampleDimensionType type) {
        int ordinal;
        if (type != null && (ordinal = type.ordinal()) >= 0 && ordinal < MAP.length) {
            return TypeMap.MAP[ordinal].range;
        }
        return null;
    }

    public static NumberRange<? extends Number> getPositiveRange(SampleDimensionType type) {
        int ordinal;
        if (type != null && (ordinal = type.ordinal()) >= 0 && ordinal < MAP.length) {
            return TypeMap.MAP[ordinal].positiveRange;
        }
        return null;
    }

    private static TypeMap map(SampleDimensionType type) throws IllegalArgumentException {
        TypeMap map;
        int ordinal;
        if (type != null && (ordinal = type.ordinal()) >= 0 && ordinal < MAP.length && (map = MAP[ordinal]) != null) {
            return map;
        }
        throw new IllegalArgumentException(Errors.format(58, "type", type));
    }

    public static Number wrapSample(double value, SampleDimensionType type, boolean allowWidening) throws IllegalArgumentException {
        TypeMap map = TypeMap.map(type);
        int ordinal = map.size;
        if (map.real) {
            ordinal <<= 16;
        } else if (map.signed) {
            ordinal = -ordinal;
        }
        switch (ordinal) {
            case -8: 
            case 1: 
            case 2: 
            case 4: {
                byte by = (byte)value;
                if ((double)by == value) {
                    return new Byte(by);
                }
                if (!allowWidening) break;
            }
            case -16: 
            case 8: {
                short s = (short)value;
                if ((double)s == value) {
                    return s;
                }
                if (!allowWidening) break;
            }
            case -32: 
            case 16: {
                int n = (int)value;
                if ((double)n == value) {
                    return n;
                }
                if (!allowWidening) break;
            }
            case 32: {
                long l = (long)value;
                if ((double)l == value) {
                    return l;
                }
                if (!allowWidening) break;
            }
            case 0x200000: {
                if (!allowWidening || Math.abs(value) <= 3.4028234663852886E38) {
                    return Float.valueOf((float)value);
                }
            }
            case 0x400000: {
                return value;
            }
            default: {
                throw new IllegalArgumentException(Errors.format(58, "type", type));
            }
        }
        throw new IllegalArgumentException(Errors.format(58, "value", value));
    }

    public static ColorInterpretation getColorInterpretation(ColorModel model, int band) throws IllegalArgumentException {
        if (model == null) {
            return ColorInterpretation.UNDEFINED;
        }
        if (band < 0 || band >= ColorUtilities.getNumBands(model)) {
            throw new IllegalArgumentException(Errors.format(7, band));
        }
        if (model instanceof IndexColorModel) {
            return ColorInterpretation.PALETTE_INDEX;
        }
        switch (model.getColorSpace().getType()) {
            case 6: {
                switch (band) {
                    case 0: {
                        return ColorInterpretation.GRAY_INDEX;
                    }
                }
                return ColorInterpretation.UNDEFINED;
            }
            case 5: {
                switch (band) {
                    case 0: {
                        return ColorInterpretation.RED_BAND;
                    }
                    case 1: {
                        return ColorInterpretation.GREEN_BAND;
                    }
                    case 2: {
                        return ColorInterpretation.BLUE_BAND;
                    }
                    case 3: {
                        return ColorInterpretation.ALPHA_BAND;
                    }
                }
                return ColorInterpretation.UNDEFINED;
            }
            case 7: {
                switch (band) {
                    case 0: {
                        return ColorInterpretation.HUE_BAND;
                    }
                    case 1: {
                        return ColorInterpretation.SATURATION_BAND;
                    }
                    case 2: {
                        return ColorInterpretation.LIGHTNESS_BAND;
                    }
                }
                return ColorInterpretation.UNDEFINED;
            }
            case 9: 
            case 11: {
                switch (band) {
                    case 0: {
                        return ColorInterpretation.CYAN_BAND;
                    }
                    case 1: {
                        return ColorInterpretation.MAGENTA_BAND;
                    }
                    case 2: {
                        return ColorInterpretation.YELLOW_BAND;
                    }
                    case 3: {
                        return ColorInterpretation.BLACK_BAND;
                    }
                }
                return ColorInterpretation.UNDEFINED;
            }
        }
        return ColorInterpretation.UNDEFINED;
    }

    static {
        HashMap<Number, Number> pool = new HashMap<Number, Number>(32);
        Float M1 = Float.valueOf(-3.4028235E38f);
        Float P1 = Float.valueOf(Float.MAX_VALUE);
        Double M2 = -1.7976931348623157E308;
        Double P2 = Double.MAX_VALUE;
        new TypeMap(SampleDimensionType.UNSIGNED_1BIT, 0, 1, false, false, pool);
        new TypeMap(SampleDimensionType.UNSIGNED_2BITS, 0, 2, false, false, pool);
        new TypeMap(SampleDimensionType.UNSIGNED_4BITS, 0, 4, false, false, pool);
        new TypeMap(SampleDimensionType.UNSIGNED_8BITS, 0, 8, false, false, pool);
        new TypeMap(SampleDimensionType.SIGNED_8BITS, 0, 8, true, false, pool);
        new TypeMap(SampleDimensionType.UNSIGNED_16BITS, 1, 16, false, false, pool);
        new TypeMap(SampleDimensionType.SIGNED_16BITS, 2, 16, true, false, pool);
        new TypeMap(SampleDimensionType.UNSIGNED_32BITS, 3, 32, false, false, pool);
        new TypeMap(SampleDimensionType.SIGNED_32BITS, 3, 32, true, false, pool);
        new TypeMap(SampleDimensionType.REAL_32BITS, 4, 32, true, true, M1, P1, pool);
        new TypeMap(SampleDimensionType.REAL_64BITS, 5, 64, true, true, M2, P2, pool);
    }
}

