/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.Splinex;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.plugins.Splinex.Spline;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class DrawSplineAction
extends MapMode
implements MapViewPaintable,
KeyPressReleaseListener,
ModifierExListener,
LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private Color rubberLineColor;
    private final Shortcut backspaceShortcut;
    private final BackSpaceAction backspaceAction;
    boolean drawHelperLine;
    int initialMoveDelay;
    int initialMoveThreshold;
    private Long mouseDownTime;
    private Spline.PointHandle ph;
    private Point helperEndpoint;
    private Point clickPos;
    public int index = 0;
    boolean lockCounterpart;
    private MoveCommand mc;
    private boolean dragControl;
    private boolean dragSpline;
    Node nodeHighlight;
    short direction;
    private Spline splCached;
    Map<Layer, Spline> layerSplines = new HashMap<Layer, Spline>();

    public DrawSplineAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Spline drawing", (Object[])new Object[0]), "spline2", I18n.tr((String)"Draw a spline curve", (Object[])new Object[0]), DrawSplineAction.getCursor());
        this.backspaceShortcut = Shortcut.registerShortcut((String)"mapmode:backspace", (String)I18n.tr((String)"Backspace in Add mode", (Object[])new Object[0]), (int)8, (int)5003);
        this.backspaceAction = new BackSpaceAction();
        this.cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
        this.cursorJoinWay = ImageProvider.getCursor((String)"crosshair", (String)"joinway");
        MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        MainApplication.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        this.readPreferences();
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor((String)"crosshair", (String)"spline");
        }
        catch (Exception e) {
            Logging.error((Throwable)e);
            return Cursor.getPredefinedCursor(1);
        }
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        MainApplication.registerActionShortcut((Action)this.backspaceAction, (Shortcut)this.backspaceShortcut);
        MapFrame map = MainApplication.getMap();
        map.mapView.addMouseListener((MouseListener)((Object)this));
        map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        map.mapView.addTemporaryLayer((MapViewPaintable)this);
        map.keyDetector.addModifierExListener((ModifierExListener)this);
        map.keyDetector.addKeyListener((KeyPressReleaseListener)this);
    }

    protected void readPreferences() {
        this.rubberLineColor = new NamedColorProperty(I18n.marktr((String)"helper line"), Color.RED).get();
        this.initialMoveDelay = Main.pref.getInt("edit.initial-move-", 200);
        this.initialMoveThreshold = Main.pref.getInt("edit.initial-move-threshold", 5);
        this.initialMoveThreshold *= this.initialMoveThreshold;
        this.drawHelperLine = Main.pref.getBoolean("draw.helper-line", true);
    }

    public void exitMode() {
        super.exitMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.removeMouseListener((MouseListener)((Object)this));
        map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        MainApplication.unregisterActionShortcut((Action)this.backspaceAction, (Shortcut)this.backspaceShortcut);
        map.statusLine.activateAnglePanel(false);
        map.keyDetector.removeModifierExListener((ModifierExListener)this);
        map.keyDetector.removeKeyListener((KeyPressReleaseListener)this);
        this.removeHighlighting();
        map.mapView.repaint();
    }

    public void modifiersExChanged(int modifiers) {
        this.updateKeyModifiersEx(modifiers);
    }

    public void mousePressed(MouseEvent e) {
        this.mouseDownTime = null;
        this.updateKeyModifiers(e);
        if (e.getButton() != 1) {
            this.helperEndpoint = null;
            return;
        }
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        Spline spl = this.getSpline();
        if (spl == null) {
            return;
        }
        this.helperEndpoint = null;
        this.dragControl = false;
        this.dragSpline = false;
        this.mouseDownTime = System.currentTimeMillis();
        this.ph = spl.getNearestPoint(MainApplication.getMap().mapView, e.getPoint());
        if (e.getClickCount() == 2) {
            if (!spl.isClosed() && spl.nodeCount() > 1 && this.ph != null && this.ph.point == Spline.SplinePoint.ENDPOINT && (this.ph.idx == 0 && this.direction == 1 || this.ph.idx == spl.nodeCount() - 1 && this.direction == -1)) {
                MainApplication.undoRedo.add((Command)new Spline.CloseSplineCommand(spl));
                return;
            }
            spl.finishSpline();
            MainApplication.getMap().repaint();
            return;
        }
        this.clickPos = e.getPoint();
        if (this.ph != null) {
            Command cmd;
            if (this.ctrl) {
                if (this.ph.point == Spline.SplinePoint.ENDPOINT) {
                    this.ph = this.ph.otherPoint(Spline.SplinePoint.CONTROL_NEXT);
                    this.lockCounterpart = true;
                } else {
                    this.lockCounterpart = false;
                }
            } else {
                boolean bl = this.lockCounterpart = this.ph.point != Spline.SplinePoint.ENDPOINT && Math.abs(this.ph.sn.cprev.east() + this.ph.sn.cnext.east()) < 1.0E-13 && Math.abs(this.ph.sn.cprev.north() + this.ph.sn.cnext.north()) < 1.0E-13;
            }
            if (this.ph.point == Spline.SplinePoint.ENDPOINT && !MainApplication.undoRedo.commands.isEmpty() && (cmd = (Command)MainApplication.undoRedo.commands.getLast()) instanceof MoveCommand) {
                this.mc = (MoveCommand)cmd;
                Collection pp = this.mc.getParticipatingPrimitives();
                if (pp.size() != 1 || !pp.contains(this.ph.sn.node)) {
                    this.mc = null;
                } else {
                    this.mc.changeStartPoint(this.ph.sn.node.getEastNorth());
                }
            }
            if (!(this.ph.point == Spline.SplinePoint.ENDPOINT || MainApplication.undoRedo.commands.isEmpty() || (cmd = (Command)MainApplication.undoRedo.commands.getLast()) instanceof Spline.EditSplineCommand && ((Spline.EditSplineCommand)cmd).sn == this.ph.sn)) {
                this.dragControl = true;
            }
            return;
        }
        if (!this.ctrl && spl.doesHit(e.getX(), e.getY(), MainApplication.getMap().mapView)) {
            this.dragSpline = true;
            return;
        }
        if (spl.isClosed()) {
            return;
        }
        if (this.direction == 0) {
            if (spl.nodeCount() < 2) {
                this.direction = 1;
            } else {
                return;
            }
        }
        Node n = null;
        boolean existing = false;
        if (!this.ctrl) {
            n = MainApplication.getMap().mapView.getNearestNode(e.getPoint(), AbstractPrimitive::isUsable);
            existing = true;
        }
        if (n == null) {
            n = new Node(MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY()));
            existing = false;
        }
        int idx = this.direction == -1 ? 0 : spl.nodeCount();
        Spline spline = spl;
        Objects.requireNonNull(spline);
        MainApplication.undoRedo.add((Command)new Spline.AddSplineNodeCommand(spline, new Spline.SNode(n), existing, idx));
        Spline spline2 = spl;
        Objects.requireNonNull(spline2);
        this.ph = new Spline.PointHandle(spline2, idx, this.direction == -1 ? Spline.SplinePoint.CONTROL_PREV : Spline.SplinePoint.CONTROL_NEXT);
        this.lockCounterpart = true;
        MainApplication.getMap().repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.mc = null;
        this.mouseDownTime = null;
        this.dragSpline = false;
        this.clickPos = null;
        this.mouseMoved(e);
        if (this.direction == 0 && this.ph != null) {
            if (this.ph.idx >= this.ph.getSpline().nodeCount() - 1) {
                this.direction = 1;
            } else if (this.ph.idx == 0) {
                this.direction = (short)-1;
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.updateKeyModifiers(e);
        if (this.mouseDownTime == null) {
            return;
        }
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        Spline spl = this.getSpline();
        if (spl == null) {
            return;
        }
        if (spl.isEmpty()) {
            return;
        }
        if (this.clickPos != null && this.clickPos.distanceSq(e.getPoint()) < (double)this.initialMoveThreshold) {
            return;
        }
        EastNorth en = MainApplication.getMap().mapView.getEastNorth(e.getX(), e.getY());
        if (Main.getProjection().eastNorth2latlon(en).isOutSideWorld()) {
            return;
        }
        if (this.dragSpline) {
            if (this.mc == null) {
                this.mc = new MoveCommand(spl.getNodes(), MainApplication.getMap().mapView.getEastNorth(this.clickPos.x, this.clickPos.y), en);
                MainApplication.undoRedo.add((Command)this.mc);
                this.clickPos = null;
            } else {
                this.mc.applyVectorTo(en);
            }
            MainApplication.getMap().repaint();
            return;
        }
        this.clickPos = null;
        if (this.ph == null) {
            return;
        }
        if (this.ph.point == Spline.SplinePoint.ENDPOINT) {
            if (this.mc == null) {
                this.mc = new MoveCommand((OsmPrimitive)this.ph.sn.node, this.ph.sn.node.getEastNorth(), en);
                MainApplication.undoRedo.add((Command)this.mc);
            } else {
                this.mc.applyVectorTo(en);
            }
        } else {
            if (this.dragControl) {
                MainApplication.undoRedo.add((Command)new Spline.EditSplineCommand(this.ph.sn));
                this.dragControl = false;
            }
            this.ph.movePoint(en);
            if (this.lockCounterpart) {
                if (this.ph.point == Spline.SplinePoint.CONTROL_NEXT) {
                    this.ph.sn.cprev = new EastNorth(0.0, 0.0).subtract(this.ph.sn.cnext);
                } else if (this.ph.point == Spline.SplinePoint.CONTROL_PREV) {
                    this.ph.sn.cnext = new EastNorth(0.0, 0.0).subtract(this.ph.sn.cprev);
                }
            }
        }
        MainApplication.getMap().repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.updateKeyModifiers(e);
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        Spline spl = this.getSpline();
        if (spl == null) {
            return;
        }
        Point oldHelperEndpoint = this.helperEndpoint;
        Spline.PointHandle oldph = this.ph;
        boolean redraw = false;
        this.ph = spl.getNearestPoint(MainApplication.getMap().mapView, e.getPoint());
        if (this.ph == null) {
            if (!this.ctrl && spl.doesHit(e.getX(), e.getY(), MainApplication.getMap().mapView)) {
                this.helperEndpoint = null;
                MainApplication.getMap().mapView.setNewCursor(13, (Object)this);
            } else {
                Node n = null;
                if (!this.ctrl) {
                    n = MainApplication.getMap().mapView.getNearestNode(e.getPoint(), AbstractPrimitive::isUsable);
                }
                if (n == null) {
                    redraw = this.removeHighlighting();
                    this.helperEndpoint = e.getPoint();
                    MainApplication.getMap().mapView.setNewCursor(this.cursor, (Object)this);
                } else {
                    redraw = this.setHighlight(n);
                    MainApplication.getMap().mapView.setNewCursor(this.cursorJoinNode, (Object)this);
                    this.helperEndpoint = MainApplication.getMap().mapView.getPoint(n);
                }
            }
        } else {
            this.helperEndpoint = null;
            MainApplication.getMap().mapView.setNewCursor(this.cursorJoinWay, (Object)this);
            redraw = this.ph.point == Spline.SplinePoint.ENDPOINT ? this.setHighlight(this.ph.sn.node) : this.removeHighlighting();
        }
        if (!this.drawHelperLine || spl.isClosed() || this.direction == 0) {
            this.helperEndpoint = null;
        }
        if (redraw || oldHelperEndpoint != this.helperEndpoint || oldph == null && this.ph != null || oldph != null && !oldph.equals(this.ph)) {
            MainApplication.getMap().repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.removeHighlighting();
        this.helperEndpoint = null;
        MainApplication.getMap().mapView.repaint();
    }

    private boolean setHighlight(Node n) {
        if (this.nodeHighlight == n) {
            return false;
        }
        this.removeHighlighting();
        this.nodeHighlight = n;
        n.setHighlighted(true);
        return true;
    }

    private boolean removeHighlighting() {
        if (this.nodeHighlight != null) {
            this.nodeHighlight.setHighlighted(false);
            this.nodeHighlight = null;
            return true;
        }
        return false;
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        Spline spl = this.getSpline();
        if (spl == null) {
            return;
        }
        spl.paint(g, mv, this.rubberLineColor, Color.green, this.helperEndpoint, this.direction);
        if (this.ph != null && (this.ph.point != Spline.SplinePoint.ENDPOINT || this.nodeHighlight != null && this.nodeHighlight.isDeleted())) {
            g.setColor(MapPaintSettings.INSTANCE.getSelectedColor());
            Point p = mv.getPoint(this.ph.getPoint());
            g.fillRect(p.x - 1, p.y - 1, 3, 3);
        }
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null);
    }

    Spline getSpline() {
        if (this.splCached != null) {
            return this.splCached;
        }
        OsmDataLayer l = this.getLayerManager().getEditLayer();
        if (!(l instanceof OsmDataLayer)) {
            return null;
        }
        this.splCached = this.layerSplines.get(l);
        if (this.splCached == null) {
            this.splCached = new Spline();
        }
        this.layerSplines.put((Layer)l, this.splCached);
        return this.splCached;
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.splCached = this.layerSplines.get(MainApplication.getLayerManager().getActiveLayer());
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        this.layerSplines.remove(e.getRemovedLayer());
        this.splCached = null;
    }

    public void doKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 && this.ph != null) {
            Spline spl = this.ph.getSpline();
            if (spl.nodeCount() == 3 && spl.isClosed() && this.ph.idx == 1) {
                return;
            }
            Spline spline = spl;
            Objects.requireNonNull(spline);
            MainApplication.undoRedo.add((Command)new Spline.DeleteSplineNodeCommand(spline, this.ph.idx));
            e.consume();
        }
        if (e.getKeyCode() == 27 && this.direction != 0) {
            this.direction = 0;
            MainApplication.getMap().mapView.repaint();
            e.consume();
        }
    }

    public void doKeyReleased(KeyEvent e) {
    }

    public static class BackSpaceAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MainApplication.undoRedo.undo();
        }
    }
}

