/*
 * Decompiled with CFR 0.152.
 */
package indoor_sweepline;

public class CorridorPart {
    public double width;
    private Type type;
    private ReachableSide side;

    public CorridorPart(double width, Type type, ReachableSide side) {
        this.width = width;
        this.type = type;
        this.side = side;
    }

    public boolean isObstacle(ReachableSide beamSide) {
        if (this.type == Type.VOID) {
            return false;
        }
        if (this.type == Type.PASSAGE) {
            return beamSide != ReachableSide.ALL;
        }
        return true;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type, ReachableSide beamSide) {
        this.type = type;
        this.adjustSideType(beamSide);
    }

    public ReachableSide getSide() {
        return this.side;
    }

    public void setSide(ReachableSide side, ReachableSide beamSide) {
        this.side = side;
        this.adjustSideType(beamSide);
    }

    private void adjustSideType(ReachableSide beamSide) {
        if (this.type == Type.PASSAGE || this.type == Type.VOID) {
            this.side = ReachableSide.ALL;
        } else if (this.side == ReachableSide.ALL) {
            this.side = beamSide == ReachableSide.RIGHT ? ReachableSide.RIGHT : ReachableSide.LEFT;
        }
    }

    public static enum ReachableSide {
        ALL,
        FRONT,
        BACK,
        LEFT,
        RIGHT;

    }

    public static enum Type {
        VOID,
        PASSAGE,
        WALL,
        STAIRS_UP,
        STAIRS_DOWN,
        ESCALATOR_UP_LEAVING,
        ESCALATOR_UP_ARRIVING,
        ESCALATOR_UP_BIDIRECTIONAL,
        ESCALATOR_DOWN_LEAVING,
        ESCALATOR_DOWN_ARRIVING,
        ESCALATOR_DOWN_BIDIRECTIONAL,
        ELEVATOR;

    }
}

