/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hi;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.hi.HindiNormalizationFilter;
import org.apache.lucene.analysis.hi.HindiStemFilter;
import org.apache.lucene.analysis.in.IndicNormalizationFilter;
import org.apache.lucene.analysis.in.IndicTokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HindiAnalyzer
extends StopwordAnalyzerBase {
    private final Set<?> stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public HindiAnalyzer(Version version2, Set<?> stopwords, Set<?> stemExclusionSet) {
        super(version2, stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(this.matchVersion, stemExclusionSet));
    }

    public HindiAnalyzer(Version version2, Set<?> stopwords) {
        this(version2, stopwords, CharArraySet.EMPTY_SET);
    }

    public HindiAnalyzer(Version version2) {
        this(version2, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        Tokenizer source = this.matchVersion.onOrAfter(Version.LUCENE_36) ? new StandardTokenizer(this.matchVersion, reader) : new IndicTokenizer(this.matchVersion, reader);
        TokenFilter result = new LowerCaseFilter(this.matchVersion, source);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        result = new IndicNormalizationFilter(result);
        result = new HindiNormalizationFilter(result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopwords);
        result = new HindiStemFilter(result);
        return new ReusableAnalyzerBase.TokenStreamComponents(source, result);
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = HindiAnalyzer.loadStopwordSet(false, HindiAnalyzer.class, HindiAnalyzer.DEFAULT_STOPWORD_FILE, HindiAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

