/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import relcontext.actions.CreateMultipolygonAction;
import relcontext.actions.TheRing;

public final class SplittingMultipolygons {
    private static final String PREF_MULTIPOLY = "reltoolbox.multipolygon.";

    private SplittingMultipolygons() {
    }

    public static boolean canProcess(Collection<Way> ways) {
        ArrayList<Way> rings = new ArrayList<Way>();
        ArrayList<Way> arcs = new ArrayList<Way>();
        Area a = MainApplication.getLayerManager().getEditDataSet().getDataSourceArea();
        for (Way way : ways) {
            if (way.isDeleted()) {
                return false;
            }
            for (Node n : way.getNodes()) {
                LatLon ll = n.getCoor();
                if (!n.isIncomplete() && (a == null || a.contains(ll.getX(), ll.getY()))) continue;
                return false;
            }
            if (way.isClosed()) {
                rings.add(way);
                continue;
            }
            arcs.add(way);
        }
        if (arcs.size() > 1) {
            for (Way segment : arcs) {
                boolean found = false;
                for (Way ring : rings) {
                    if (!ring.containsNode(segment.firstNode()) || !ring.containsNode(segment.lastNode())) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
        }
        if (rings.isEmpty() && arcs.isEmpty()) {
            return false;
        }
        for (int i = 0; i < rings.size() - 1; ++i) {
            for (int j = i + 1; j < rings.size(); ++j) {
                Geometry.PolygonIntersection intersection = Geometry.polygonIntersection((List)((Way)rings.get(i)).getNodes(), (List)((Way)rings.get(j)).getNodes());
                if (intersection != Geometry.PolygonIntersection.FIRST_INSIDE_SECOND && intersection != Geometry.PolygonIntersection.SECOND_INSIDE_FIRST) continue;
                return false;
            }
        }
        return true;
    }

    public static List<Relation> process(Collection<Way> selectedWays) {
        Relation newRelation;
        ArrayList<Object> commands;
        ArrayList<Relation> result = new ArrayList<Relation>();
        ArrayList<Way> rings = new ArrayList<Way>();
        ArrayList<Way> arcs = new ArrayList<Way>();
        for (Way way : selectedWays) {
            if (way.isClosed()) {
                rings.add(way);
                continue;
            }
            arcs.add(way);
        }
        for (Way ring : rings) {
            newRelation = SplittingMultipolygons.attachRingToNeighbours(ring, commands = new ArrayList<Command>());
            if (newRelation == null || commands.isEmpty()) continue;
            MainApplication.undoRedo.add((Command)commands.get(0));
            result.add(newRelation);
        }
        for (Way arc : arcs) {
            newRelation = SplittingMultipolygons.tryToCloseOneWay(arc, commands = new ArrayList());
            if (newRelation == null || commands.isEmpty()) continue;
            MainApplication.undoRedo.add((Command)commands.get(0));
            result.add(newRelation);
        }
        return result;
    }

    private static void closePolygon(List<Node> base, List<Node> append) {
        if (append.get(0).equals((Object)base.get(0)) && append.get(append.size() - 1).equals((Object)base.get(base.size() - 1))) {
            ArrayList<Node> ap2 = new ArrayList<Node>(append);
            Collections.reverse(ap2);
            append = ap2;
        }
        base.remove(base.size() - 1);
        base.addAll(append);
    }

    private static boolean segmentInsidePolygon(Node n1, Node n2, List<Node> polygon) {
        EastNorth en1 = n1.getEastNorth();
        EastNorth en2 = n2.getEastNorth();
        Node testNode = new Node(new EastNorth((en1.east() + en2.east()) / 2.0, (en1.north() + en2.north()) / 2.0));
        return Geometry.nodeInsidePolygon((INode)testNode, polygon);
    }

    public static List<Way> splitWay(Way w, Node n1, Node n2, List<Command> commands) {
        int i;
        int index2;
        ArrayList nodes = new ArrayList(w.getNodes());
        if (w.isClosed()) {
            nodes.remove(nodes.size() - 1);
        }
        int index1 = nodes.indexOf(n1);
        int n = index2 = n2 == null ? -1 : nodes.indexOf(n2);
        if (index1 > index2) {
            int tmp = index1;
            index1 = index2;
            index2 = tmp;
        }
        if (index2 < 1 || index1 >= w.getNodesCount() - 1 || index2 >= w.getNodesCount()) {
            return Collections.emptyList();
        }
        if (w.isClosed() && (index1 < 0 || index1 == index2 || index1 + w.getNodesCount() == index2)) {
            return Collections.emptyList();
        }
        ArrayList chunks = new ArrayList(2);
        ArrayList<Node> chunk = new ArrayList<Node>();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            chunk.add((Node)nodes.get(i2));
            if (!w.isClosed() && chunk.size() <= 1 || i2 != index1 && i2 != index2) continue;
            chunks.add(chunk);
            chunk = new ArrayList();
            chunk.add((Node)nodes.get(i2));
        }
        chunks.add(chunk);
        if (w.isClosed()) {
            ((List)chunks.get(chunks.size() - 1)).addAll((Collection)chunks.get(0));
            chunks.remove(0);
        } else if (((List)chunks.get(chunks.size() - 1)).size() < 2) {
            chunks.remove(chunks.size() - 1);
        }
        HashMap<Relation, Integer> references = new HashMap<Relation, Integer>();
        ArrayList<ChangeCommand> relationCommands = new ArrayList<ChangeCommand>();
        for (OsmPrimitive p : w.getReferrers()) {
            Relation rel;
            if (!(p instanceof Relation)) continue;
            Relation relation = rel = commands == null ? (Relation)p : new Relation((Relation)p);
            if (commands != null) {
                relationCommands.add(new ChangeCommand(p, (OsmPrimitive)rel));
            }
            for (i = 0; i < rel.getMembersCount(); ++i) {
                if (!rel.getMember(i).getMember().equals((Object)w)) continue;
                references.put(rel, i);
            }
        }
        ArrayList<Way> result = new ArrayList<Way>();
        Way updatedWay = commands == null ? w : new Way(w);
        updatedWay.setNodes((List)chunks.get(0));
        if (commands != null) {
            commands.add((Command)new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)updatedWay));
            result.add(updatedWay);
        }
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        for (i = 1; i < chunks.size(); ++i) {
            List achunk = (List)chunks.get(i);
            Way newWay = new Way();
            newWay.setKeys(w.getKeys());
            result.add(newWay);
            for (Relation rel : references.keySet()) {
                int relIndex = (Integer)references.get(rel);
                rel.addMember(relIndex + 1, new RelationMember(rel.getMember(relIndex).getRole(), (OsmPrimitive)newWay));
            }
            newWay.setNodes(achunk);
            if (commands == null) continue;
            commands.add((Command)new AddCommand(ds, (OsmPrimitive)newWay));
        }
        if (commands != null) {
            commands.addAll(relationCommands);
        }
        return result;
    }

    public static List<Way> splitWay(Way w, Node n1, Node n2) {
        return SplittingMultipolygons.splitWay(w, n1, n2, null);
    }

    public static Relation tryToCloseOneWay(Way segment, List<Command> resultingCommands) {
        if (segment.isClosed() || segment.isIncomplete()) {
            return null;
        }
        List ways = SplittingMultipolygons.intersection(OsmPrimitive.getFilteredList((Collection)segment.firstNode().getReferrers(), Way.class), OsmPrimitive.getFilteredList((Collection)segment.lastNode().getReferrers(), Way.class));
        ways.remove(segment);
        Iterator iter = ways.iterator();
        while (iter.hasNext()) {
            boolean save = false;
            for (OsmPrimitive ref : ((Way)iter.next()).getReferrers()) {
                if (!(ref instanceof Relation) || !((Relation)ref).isMultipolygon() || ref.isDeleted()) continue;
                save = true;
            }
            if (save) continue;
            iter.remove();
        }
        if (ways.isEmpty()) {
            return null;
        }
        Way target = (Way)ways.get(0);
        ArrayList<Command> commands = new ArrayList<Command>();
        Relation newRelation = new Relation();
        newRelation.put("type", "multipolygon");
        newRelation.addMember(new RelationMember("outer", (OsmPrimitive)segment));
        List linearTags = Main.pref.getList("reltoolbox.multipolygon.lineartags", CreateMultipolygonAction.DEFAULT_LINEAR_TAGS);
        Way segmentCopy = new Way(segment);
        boolean changed = false;
        for (String key : segmentCopy.keySet()) {
            if (linearTags.contains(key)) continue;
            newRelation.put(key, segmentCopy.get(key));
            segmentCopy.remove(key);
            changed = true;
        }
        if (changed) {
            commands.add((Command)new ChangeCommand((OsmPrimitive)segment, (OsmPrimitive)segmentCopy));
        }
        ArrayList<Way> newWays = new ArrayList<Way>(SplittingMultipolygons.splitWay(target, segment.firstNode(), segment.lastNode(), commands));
        Way addingWay = null;
        if (target.isClosed()) {
            Way utarget = (Way)newWays.get(1);
            Way alternate = (Way)newWays.get(0);
            ArrayList<Node> testRing = new ArrayList<Node>(segment.getNodes());
            SplittingMultipolygons.closePolygon(testRing, utarget.getNodes());
            addingWay = SplittingMultipolygons.segmentInsidePolygon(alternate.getNode(0), alternate.getNode(1), testRing) ? alternate : utarget;
        } else {
            for (Way w : newWays) {
                if ((!w.firstNode().equals((Object)segment.firstNode()) || !w.lastNode().equals((Object)segment.lastNode())) && (!w.firstNode().equals((Object)segment.lastNode()) || !w.lastNode().equals((Object)segment.firstNode()))) continue;
                addingWay = w;
                break;
            }
        }
        newRelation.addMember(new RelationMember("outer", (OsmPrimitive)(addingWay.getUniqueId() == target.getUniqueId() ? target : addingWay)));
        commands.add((Command)new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)newRelation));
        resultingCommands.add((Command)new SequenceCommand(I18n.tr((String)"Complete multipolygon for way {0}", (Object[])new Object[]{DefaultNameFormatter.getInstance().format((IWay)segment)}), commands));
        return newRelation;
    }

    private static <T> List<T> intersection(Collection<T> list1, Collection<T> list2) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : list1) {
            if (!list2.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static Relation attachRingToNeighbours(Way ring, List<Command> resultingCommands) {
        if (!ring.isClosed() || ring.isIncomplete()) {
            return null;
        }
        HashMap<Way, Boolean> touchingWays = new HashMap<Way, Boolean>();
        for (Object n : ring.getNodes()) {
            block1: for (Object p : n.getReferrers()) {
                if (!(p instanceof Way) || p.equals((Object)ring)) continue;
                for (OsmPrimitive r : p.getReferrers()) {
                    if (!(r instanceof Relation) || !((Relation)r).hasKey("type") || !((Relation)r).get("type").equals("multipolygon")) continue;
                    if (touchingWays.containsKey(p)) {
                        touchingWays.put((Way)p, Boolean.TRUE);
                        continue block1;
                    }
                    touchingWays.put((Way)p, Boolean.FALSE);
                    continue block1;
                }
            }
        }
        ArrayList<TheRing> otherWays = new ArrayList<TheRing>();
        for (Way w : touchingWays.keySet()) {
            if (!((Boolean)touchingWays.get(w)).booleanValue()) continue;
            otherWays.add(new TheRing(w));
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        TheRing theRing = new TheRing(ring);
        for (TheRing otherRing : otherWays) {
            theRing.collide(otherRing);
        }
        theRing.putSourceWayFirst();
        for (TheRing otherRing : otherWays) {
            otherRing.putSourceWayFirst();
        }
        HashMap<Relation, Relation> relationCache = new HashMap<Relation, Relation>();
        for (TheRing otherRing : otherWays) {
            commands.addAll(otherRing.getCommands(false, relationCache));
        }
        commands.addAll(theRing.getCommands(relationCache));
        TheRing.updateCommandsWithRelations(commands, relationCache);
        resultingCommands.add((Command)new SequenceCommand(I18n.tr((String)"Complete multipolygon for way {0}", (Object[])new Object[]{DefaultNameFormatter.getInstance().format((IWay)ring)}), commands));
        return theRing.getRelation();
    }
}

