/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime.windows;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowsRuntimeUtil {
    private static final Logger logger = LoggerFactory.getLogger(WindowsRuntimeUtil.class);
    public static final String VLC_REGISTRY_KEY = "SOFTWARE\\VideoLAN\\VLC";
    public static final String VLC_INSTALL_DIR_KEY = "InstallDir";

    private WindowsRuntimeUtil() {
    }

    public static String getVlcInstallDir() {
        logger.debug("getVlcInstallDir()");
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)VLC_REGISTRY_KEY, (String)VLC_INSTALL_DIR_KEY);
        }
        catch (Exception e) {
            logger.warn("Failed to get VLC installation directory from the registry", e);
            return null;
        }
    }
}

