/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.EventTranslatorVararg;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerDisruptor;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEventTranslator;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.core.util.NanoClockFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.TimestampMessage;
import org.apache.logging.log4j.status.StatusLogger;

public class AsyncLogger
extends Logger
implements EventTranslatorVararg<RingBufferLogEvent> {
    private static final long serialVersionUID = 1L;
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final Clock CLOCK = ClockFactory.getClock();
    private static final ThreadNameCachingStrategy THREAD_NAME_CACHING_STRATEGY = ThreadNameCachingStrategy.create();
    private final ThreadLocal<RingBufferLogEventTranslator> threadLocalTranslator = new ThreadLocal();
    private final AsyncLoggerDisruptor loggerDisruptor;
    private volatile NanoClock nanoClock;

    public AsyncLogger(LoggerContext context, String name, MessageFactory messageFactory, AsyncLoggerDisruptor loggerDisruptor) {
        super(context, name, messageFactory);
        this.loggerDisruptor = loggerDisruptor;
        this.nanoClock = NanoClockFactory.createNanoClock();
    }

    @Override
    protected void updateConfiguration(Configuration newConfig) {
        super.updateConfiguration(newConfig);
        this.nanoClock = NanoClockFactory.createNanoClock();
        LOGGER.trace("[{}] AsyncLogger {} uses {}.", this.getContext().getName(), this.getName(), this.nanoClock);
    }

    NanoClock getNanoClock() {
        return this.nanoClock;
    }

    private RingBufferLogEventTranslator getCachedTranslator() {
        RingBufferLogEventTranslator result = this.threadLocalTranslator.get();
        if (result == null) {
            result = new RingBufferLogEventTranslator();
            this.threadLocalTranslator.set(result);
        }
        return result;
    }

    @Override
    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        if (this.loggerDisruptor.shouldLogInCurrentThread()) {
            this.logMessageInCurrentThread(fqcn, level, marker, message, thrown);
        } else {
            this.logMessageInBackgroundThread(fqcn, level, marker, message, thrown);
        }
    }

    private void logMessageInCurrentThread(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        ReliabilityStrategy strategy = this.privateConfig.loggerConfig.getReliabilityStrategy();
        strategy.log(this, this.getName(), fqcn, marker, level, message, thrown);
    }

    private void logMessageInBackgroundThread(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        if (!Constants.FORMAT_MESSAGES_IN_BACKGROUND) {
            message.getFormattedMessage();
        }
        this.logInBackground(fqcn, level, marker, message, thrown);
    }

    private void logInBackground(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        if (this.loggerDisruptor.isUseThreadLocals()) {
            this.logWithThreadLocalTranslator(fqcn, level, marker, message, thrown);
        } else {
            this.logWithVarargTranslator(fqcn, level, marker, message, thrown);
        }
    }

    private void logWithThreadLocalTranslator(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        RingBufferLogEventTranslator translator = this.getCachedTranslator();
        this.initTranslator(translator, fqcn, level, marker, message, thrown);
        this.loggerDisruptor.enqueueLogMessageInfo(translator);
    }

    private void initTranslator(RingBufferLogEventTranslator translator, String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        this.initTranslatorPart1(translator, fqcn, level, marker, message, thrown);
        this.initTranslatorPart2(translator, fqcn, message);
    }

    private void initTranslatorPart1(RingBufferLogEventTranslator translator, String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        translator.setValuesPart1(this, this.getName(), marker, fqcn, level, message, thrown);
    }

    private void initTranslatorPart2(RingBufferLogEventTranslator translator, String fqcn, Message message) {
        translator.setValuesPart2(ThreadContext.getImmutableContext(), ThreadContext.getImmutableStack(), THREAD_NAME_CACHING_STRATEGY.getThreadName(), this.calcLocationIfRequested(fqcn), this.eventTimeMillis(message), this.nanoClock.nanoTime());
    }

    private long eventTimeMillis(Message message) {
        return message instanceof TimestampMessage ? ((TimestampMessage)((Object)message)).getTimestamp() : CLOCK.currentTimeMillis();
    }

    private void logWithVarargTranslator(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        Disruptor<RingBufferLogEvent> disruptor = this.loggerDisruptor.getDisruptor();
        if (disruptor == null) {
            LOGGER.error("Ignoring log event after Log4j has been shut down.");
            return;
        }
        disruptor.getRingBuffer().publishEvent((EventTranslatorVararg)this, new Object[]{this, this.calcLocationIfRequested(fqcn), fqcn, level, marker, message, thrown});
    }

    public void translateTo(RingBufferLogEvent event, long sequence, Object ... args) {
        AsyncLogger asyncLogger = (AsyncLogger)args[0];
        StackTraceElement location = (StackTraceElement)args[1];
        String fqcn = (String)args[2];
        Level level = (Level)args[3];
        Marker marker = (Marker)args[4];
        Message message = (Message)args[5];
        Throwable thrown = (Throwable)args[6];
        Map<String, String> contextMap = ThreadContext.getImmutableContext();
        ThreadContext.ContextStack contextStack = ThreadContext.getImmutableStack();
        String threadName = THREAD_NAME_CACHING_STRATEGY.getThreadName();
        event.setValues(asyncLogger, asyncLogger.getName(), marker, fqcn, level, message, thrown, contextMap, contextStack, threadName, location, this.eventTimeMillis(message), this.nanoClock.nanoTime());
    }

    private StackTraceElement calcLocationIfRequested(String fqcn) {
        boolean includeLocation = this.privateConfig.loggerConfig.isIncludeLocation();
        return includeLocation ? Log4jLogEvent.calcLocation(fqcn) : null;
    }

    public void actualAsyncLog(RingBufferLogEvent event) {
        Map<Property, Boolean> properties = this.privateConfig.loggerConfig.getProperties();
        event.mergePropertiesIntoContextMap(properties, this.privateConfig.config.getStrSubstitutor());
        ReliabilityStrategy strategy = this.privateConfig.loggerConfig.getReliabilityStrategy();
        strategy.log(this, event);
    }
}

