/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec.features;

import de.bwaldvogel.liblinear.FeatureNode;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.plugins.osmrec.container.OSMRelation;
import org.openstreetmap.josm.plugins.osmrec.container.OSMWay;

public class RelationFeatures {
    int id;

    public RelationFeatures(int id) {
        this.id = id;
    }

    public void createRelationFeatures(OSMWay wayNode, List<OSMRelation> relationList) {
        ++this.id;
        boolean hasRelation = false;
        for (OSMRelation relation : relationList) {
            if (hasRelation) break;
            if (!relation.getMemberReferences().contains(wayNode.getID())) continue;
            hasRelation = true;
            Map<String, String> tags = relation.getTagKeyValue();
            if (tags.containsKey("route")) {
                wayNode.getFeatureNodeList().add(new FeatureNode(this.id, 1.0));
            } else if (tags.containsKey("multipolygon")) {
                wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 1, 1.0));
            } else if (tags.containsKey("boundary")) {
                wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 2, 1.0));
            } else if (tags.containsKey("restriction")) {
                wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 3, 1.0));
            } else {
                wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 4, 1.0));
            }
            this.id += 5;
        }
        if (!hasRelation) {
            this.id += 5;
        }
    }

    public int getLastID() {
        return this.id;
    }
}

