/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui.actions;

import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.AbstractAddressEditAction;
import org.openstreetmap.josm.tools.I18n;

public class RemoveAddressTagsAction
extends AbstractAddressEditAction {
    public RemoveAddressTagsAction() {
        super(I18n.tr((String)"Remove", (Object[])new Object[0]), "removeaddrtags_24", I18n.tr((String)"Removes address related tags from the object.", (Object[])new Object[0]), "fixaddresses/removeaddresstags");
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        this.beginTransaction(I18n.tr((String)"Remove address tags", (Object[])new Object[0]));
        if (ev.hasUnresolvedAddresses()) {
            for (OSMAddress aNode : ev.getSelectedUnresolvedAddresses()) {
                this.beginObjectTransaction(aNode);
                aNode.removeAllAddressTags();
                this.finishObjectTransaction(aNode);
            }
        }
        if (ev.hasIncompleteAddresses()) {
            for (OSMAddress aNode : ev.getSelectedIncompleteAddresses()) {
                this.beginObjectTransaction(aNode);
                aNode.removeAllAddressTags();
                this.finishObjectTransaction(aNode);
            }
        }
        this.finishTransaction();
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
    }

    @Override
    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(false);
    }

    @Override
    protected void updateEnabledState(AddressEditSelectionEvent event) {
        if (event == null) {
            this.setEnabled(false);
        }
        this.setEnabled(event.hasAddresses());
    }
}

