/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugin.download_along;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAlongAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongPanel;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

class DownloadAlongWayAction
extends DownloadAlongAction {
    private static final String PREF_DOWNLOAD_ALONG_WAY_DISTANCE = "downloadAlongWay.distance";
    private static final String PREF_DOWNLOAD_ALONG_WAY_AREA = "downloadAlongWay.area";
    private static final String PREF_DOWNLOAD_ALONG_WAY_OSM = "downloadAlongWay.download.osm";
    private static final String PREF_DOWNLOAD_ALONG_WAY_GPS = "downloadAlongWay.download.gps";

    DownloadAlongWayAction() {
        super(I18n.tr((String)"Download along...", (Object[])new Object[0]), "download_along", I18n.tr((String)"Download OSM data along the selected ways.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:download_along", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Download Along", (Object[])new Object[0])}), (int)68, (int)5007), true);
    }

    public void actionPerformed(ActionEvent e) {
        Set selectedWays = OsmPrimitive.getFilteredSet((Collection)this.getLayerManager().getEditDataSet().getSelected(), Way.class);
        if (selectedWays.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select 1 or more ways to download along", (Object[])new Object[0]));
            return;
        }
        DownloadAlongPanel panel = new DownloadAlongPanel(PREF_DOWNLOAD_ALONG_WAY_OSM, PREF_DOWNLOAD_ALONG_WAY_GPS, PREF_DOWNLOAD_ALONG_WAY_DISTANCE, PREF_DOWNLOAD_ALONG_WAY_AREA, null);
        if (0 != panel.showInDownloadDialog(I18n.tr((String)"Download from OSM along selected ways", (Object[])new Object[0]), HelpUtil.ht((String)"/Tools/DownloadAlong"))) {
            return;
        }
        Logging.info((String)"Starting area computation");
        long start = System.currentTimeMillis();
        double latsum = 0.0;
        int latcnt = 0;
        for (Way way : selectedWays) {
            for (Node n : way.getNodes()) {
                latsum += n.getCoor().lat();
                ++latcnt;
            }
        }
        double avglat = latsum / (double)latcnt;
        double scale = Math.cos(Math.toRadians(avglat));
        double buffer_dist = panel.getDistance();
        double buffer_y = buffer_dist / 100000.0;
        double buffer_x = buffer_y / scale;
        double max_area = panel.getArea() / 10000.0 / scale;
        Path2D.Double path = new Path2D.Double();
        Rectangle2D.Double r = new Rectangle2D.Double();
        LatLon previous = null;
        for (Way way : selectedWays) {
            for (Node p : way.getNodes()) {
                LatLon c = p.getCoor();
                ArrayList<LatLon> intermediateNodes = new ArrayList<LatLon>();
                if (previous != null && c.greatCircleDistance(previous) > buffer_dist) {
                    Double d = c.greatCircleDistance(previous) / buffer_dist;
                    int nbNodes = d.intValue();
                    if (Logging.isDebugEnabled()) {
                        Logging.debug((String)I18n.tr((String)"{0} intermediate nodes to download.", (Object[])new Object[]{nbNodes}));
                        Logging.debug((String)I18n.tr((String)"between {0} {1} and {2} {3}", (Object[])new Object[]{c.lat(), c.lon(), previous.lat(), previous.lon()}));
                    }
                    for (int i = 1; i < nbNodes; ++i) {
                        intermediateNodes.add(new LatLon(previous.lat() + (double)i * (c.lat() - previous.lat()) / (double)(nbNodes + 1), previous.lon() + (double)i * (c.lon() - previous.lon()) / (double)(nbNodes + 1)));
                        if (!Logging.isTraceEnabled()) continue;
                        Logging.trace((String)I18n.tr((String)"  adding {0} {1}", (Object[])new Object[]{previous.lat() + (double)i * (c.lat() - previous.lat()) / (double)(nbNodes + 1), previous.lon() + (double)i * (c.lon() - previous.lon()) / (double)(nbNodes + 1)}));
                    }
                }
                intermediateNodes.add(c);
                for (LatLon d : intermediateNodes) {
                    if (previous != null && !(d.greatCircleDistance(previous) > buffer_dist)) continue;
                    ((Rectangle2D)r).setRect(d.lon() - buffer_x, d.lat() - buffer_y, 2.0 * buffer_x, 2.0 * buffer_y);
                    path.append(r, false);
                    previous = d;
                }
                previous = c;
            }
        }
        Area a = new Area(path);
        Logging.info((String)("Area computed in " + Utils.getDurationString((long)(System.currentTimeMillis() - start))));
        DownloadAlongWayAction.confirmAndDownloadAreas((Area)a, (double)max_area, (boolean)panel.isDownloadOsmData(), (boolean)panel.isDownloadGpxData(), (String)I18n.tr((String)"Download from OSM along selected ways", (Object[])new Object[0]), (ProgressMonitor)NullProgressMonitor.INSTANCE);
    }

    protected void updateEnabledState() {
        if (this.getLayerManager().getEditDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection.stream().anyMatch(Way.class::isInstance));
    }
}

