/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import messages.Messages;
import seamarks.SeaMark;
import smed.SmedAction;

public class PanelStbd
extends JPanel {
    private SmedAction dlg;
    public ButtonGroup shapeButtons = new ButtonGroup();
    public JRadioButton pillarButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/PillarButton.png")));
    public JRadioButton sparButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SparButton.png")));
    public JRadioButton coneButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/ConeButton.png")));
    public JRadioButton sphereButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SphereButton.png")));
    public JRadioButton floatButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FloatButton.png")));
    public JRadioButton beaconButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BeaconButton.png")));
    public JRadioButton towerButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/TowerButton.png")));
    public JRadioButton perchButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/PerchSButton.png")));
    public JRadioButton stakeButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/StakeButton.png")));
    public EnumMap<SeaMark.Shp, JRadioButton> shapes = new EnumMap(SeaMark.Shp.class);
    public EnumMap<SeaMark.Shp, SeaMark.Obj> objects = new EnumMap(SeaMark.Shp.class);
    public ActionListener alShape = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Shp shp : PanelStbd.this.shapes.keySet()) {
                JRadioButton button = PanelStbd.this.shapes.get((Object)shp);
                if (button.isSelected()) {
                    SmedAction.panelMain.mark.setShape(shp);
                    SmedAction.panelMain.mark.setObject(PanelStbd.this.objects.get((Object)shp));
                    button.setBorderPainted(true);
                    continue;
                }
                button.setBorderPainted(false);
            }
            if (SmedAction.panelMain.mark.testValid()) {
                SmedAction.panelMain.panelChan.topmarkButton.setVisible(true);
                SmedAction.panelMain.panelChan.lightButton.setVisible(true);
                if (SmedAction.panelMain.mark.getCategory() == SeaMark.Cat.LAM_STBD) {
                    switch (SmedAction.panelMain.mark.getRegion()) {
                        case A: {
                            SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                            break;
                        }
                        case B: {
                            SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                            break;
                        }
                        case C: {
                            SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.HSTRP);
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.WHITE);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.WHITE);
                            break;
                        }
                    }
                } else {
                    SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.HSTRP);
                    switch (SmedAction.panelMain.mark.getRegion()) {
                        case A: {
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                            break;
                        }
                        case B: {
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                            break;
                        }
                        case C: {
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                            break;
                        }
                    }
                }
                SmedAction.panelMain.panelMore.syncPanel();
            } else {
                SmedAction.panelMain.panelChan.topmarkButton.setVisible(false);
                SmedAction.panelMain.panelChan.lightButton.setVisible(false);
            }
        }
    };

    public PanelStbd(SmedAction dia) {
        this.dlg = dia;
        this.setLayout(null);
        this.add(this.getShapeButton(this.pillarButton, 0, 0, 34, 32, "Pillar", SeaMark.Shp.PILLAR, SeaMark.Obj.BOYLAT));
        this.add(this.getShapeButton(this.sparButton, 0, 32, 34, 32, "Spar", SeaMark.Shp.SPAR, SeaMark.Obj.BOYLAT));
        this.add(this.getShapeButton(this.coneButton, 0, 64, 34, 32, "Cone", SeaMark.Shp.CONI, SeaMark.Obj.BOYLAT));
        this.add(this.getShapeButton(this.sphereButton, 0, 96, 34, 32, "Sphere", SeaMark.Shp.SPHERI, SeaMark.Obj.BOYLAT));
        this.add(this.getShapeButton(this.floatButton, 0, 128, 34, 32, "Float", SeaMark.Shp.FLOAT, SeaMark.Obj.FLTLAT));
        this.add(this.getShapeButton(this.beaconButton, 35, 0, 34, 32, "Beacon", SeaMark.Shp.BEACON, SeaMark.Obj.BCNLAT));
        this.add(this.getShapeButton(this.towerButton, 35, 32, 34, 32, "TowerB", SeaMark.Shp.TOWER, SeaMark.Obj.BCNLAT));
        this.add(this.getShapeButton(this.perchButton, 35, 64, 34, 32, "Perch", SeaMark.Shp.PERCH, SeaMark.Obj.BCNLAT));
        this.add(this.getShapeButton(this.stakeButton, 35, 96, 34, 32, "Stake", SeaMark.Shp.STAKE, SeaMark.Obj.BCNLAT));
    }

    public void syncPanel() {
        for (SeaMark.Shp shp : this.shapes.keySet()) {
            JRadioButton button = this.shapes.get((Object)shp);
            if (SmedAction.panelMain.mark.getShape() == shp) {
                button.setBorderPainted(true);
                continue;
            }
            button.setBorderPainted(false);
        }
    }

    private JRadioButton getShapeButton(JRadioButton button, int x, int y, int w, int h, String tip, SeaMark.Shp shp, SeaMark.Obj obj) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(Messages.getString(tip));
        button.addActionListener(this.alShape);
        this.shapeButtons.add(button);
        this.shapes.put(shp, button);
        this.objects.put(shp, obj);
        return button;
    }
}

