/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import at.dallermassl.josm.plugin.surveyor.util.LayerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.tools.I18n;

public class AutoSaveGpsLayerTimerTask
extends TimerTask {
    private String gpsLayerName;
    private File file;

    public AutoSaveGpsLayerTimerTask(String filename, String layerName) {
        this.gpsLayerName = layerName;
        this.file = new File(filename);
    }

    public String getGpsLayerName() {
        return this.gpsLayerName;
    }

    @Override
    public void run() {
        try {
            GpxLayer gpsLayer = LayerUtil.findGpsLayer(this.gpsLayerName, GpxLayer.class);
            if (gpsLayer == null) {
                return;
            }
            File tmpFile = new File(this.file.getAbsoluteFile() + ".tmp");
            System.out.println("AutoSaving data to file " + this.file.getAbsolutePath());
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(tmpFile)));
            try (GpxWriter gpxWriter = new GpxWriter(out);){
                gpxWriter.write(gpsLayer.data);
            }
            tmpFile.renameTo(this.file);
        }
        catch (IOException ioExc) {
            ioExc.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while exporting {0}: {1}", (Object[])new Object[]{this.file.getAbsoluteFile(), ioExc.getMessage()}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        }
    }
}

