/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JoinNodeWayAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DoubleSplitAction
extends MapMode {
    private static final String MAP_MODE_NAME = "Double Split";
    private transient Set<OsmPrimitive> newHighlights = new HashSet<OsmPrimitive>();
    private transient Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private int nodeCount = 0;
    private List<Node> atNodes = new ArrayList<Node>();
    private Way previousAffectedWay;
    private final Cursor cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
    private final Cursor cursorJoinWay = ImageProvider.getCursor((String)"crosshair", (String)"joinway");

    public DoubleSplitAction() {
        super(I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), "logo_double_split", I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), null, DoubleSplitAction.getCursor());
    }

    private static Cursor getCursor() {
        Cursor cursor = ImageProvider.getCursor((String)"crosshair", (String)"bus");
        if (cursor == null) {
            cursor = Cursor.getPredefinedCursor(1);
        }
        return cursor;
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void exitMode() {
        if (this.nodeCount == 1) {
            for (int i = 0; i < 2; ++i) {
                MainApplication.undoRedo.undo();
            }
            this.nodeCount = 0;
            this.atNodes.clear();
            this.previousAffectedWay = null;
            this.updateHighlights();
        }
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    private void reset() {
        this.nodeCount = 0;
        this.atNodes.clear();
        this.previousAffectedWay = null;
        this.updateHighlights();
    }

    private boolean startEndPoints() {
        if (this.atNodes.get(0).isConnectionNode() && this.atNodes.get(1).isConnectionNode()) {
            for (Way way : this.atNodes.get(0).getParentWays()) {
                if (!this.atNodes.get(1).getParentWays().contains(way)) continue;
                ArrayList<TagMap> affectedKeysList = new ArrayList<TagMap>();
                affectedKeysList.add(way.getKeys());
                this.newHighlights.add((OsmPrimitive)way);
                this.dialogBox(Arrays.asList(way), affectedKeysList);
                return true;
            }
            this.reset();
            return true;
        }
        return false;
    }

    private boolean firstNodeIsConnectionNode(Node node, Way affected) {
        if (node.isConnectionNode()) {
            if (node.getParentWays().contains(affected)) {
                this.previousAffectedWay = affected;
            } else {
                this.reset();
                return true;
            }
        }
        return false;
    }

    private boolean secondNodeIsConnectionNode(Node node) {
        if (this.atNodes.get(1).isConnectionNode()) {
            if (this.atNodes.get(1).getParentWays().contains(this.previousAffectedWay)) {
                return false;
            }
            this.reset();
            return true;
        }
        return false;
    }

    private Node checkCommonNode(Way affected) {
        List presentNodeList = affected.getNodes();
        for (Node previousNode : this.previousAffectedWay.getNodes()) {
            if (!presentNodeList.contains(previousNode)) continue;
            return previousNode;
        }
        return null;
    }

    private void removeFirstNode(Way affected) {
        Node nodeToBeDeleted = this.atNodes.get(0);
        if (nodeToBeDeleted != null) {
            this.atNodes.remove(0);
            Command lastCommand = (Command)MainApplication.undoRedo.commands.removeLast();
            Command secondLastCommand = (Command)MainApplication.undoRedo.commands.removeLast();
            for (int i = 0; i < 2; ++i) {
                MainApplication.undoRedo.undo();
            }
            MainApplication.undoRedo.commands.add(secondLastCommand);
            MainApplication.undoRedo.commands.add(lastCommand);
            MainApplication.undoRedo.redo();
        }
        this.previousAffectedWay = affected;
    }

    private void addKeysOnBothWays(Node commonNode, Way affected) {
        Object way;
        ArrayList<TagMap> affectedKeysList = new ArrayList<TagMap>();
        List<Node> nodelist1 = Arrays.asList(this.atNodes.get(0), commonNode);
        List<Node> nodelist2 = Arrays.asList(this.atNodes.get(1), commonNode);
        affectedKeysList.add(this.previousAffectedWay.getKeys());
        affectedKeysList.add(affected.getKeys());
        SplitWayCommand result1 = SplitWayCommand.split((Way)this.previousAffectedWay, nodelist1, Collections.emptyList());
        SplitWayCommand result2 = SplitWayCommand.split((Way)affected, nodelist2, Collections.emptyList());
        MainApplication.undoRedo.add((Command)result1);
        MainApplication.undoRedo.add((Command)result2);
        Object way1 = null;
        Object way2 = null;
        boolean isOriginalWay = true;
        for (Way way3 : result1.getNewWays()) {
            if (!way3.containsNode(commonNode) || !way3.containsNode(this.atNodes.get(0))) continue;
            way1 = way3;
            isOriginalWay = false;
            break;
        }
        if (isOriginalWay && (way = result1.getOriginalWay()).containsNode(commonNode) && way.containsNode(this.atNodes.get(0))) {
            way1 = way;
        }
        isOriginalWay = true;
        way = result2.getNewWays().iterator();
        while (way.hasNext()) {
            Way way3;
            way3 = (Way)way.next();
            if (!way3.containsNode(commonNode) || !way3.containsNode(this.atNodes.get(1))) continue;
            way2 = way3;
            isOriginalWay = false;
            break;
        }
        if (isOriginalWay && (way = result2.getOriginalWay()).containsNode(commonNode) && way.containsNode(this.atNodes.get(1))) {
            way2 = way;
        }
        if (way1 != null && way2 != null) {
            List<Way> selectedWays = Arrays.asList(way1, way2);
            this.newHighlights.add((OsmPrimitive)way1);
            this.newHighlights.add((OsmPrimitive)way2);
            this.dialogBox(selectedWays, affectedKeysList);
        }
    }

    private void addKeys(Way affected) {
        ArrayList<TagMap> affectedKeysList = new ArrayList<TagMap>();
        Way selectedWay = null;
        SplitWayCommand result = SplitWayCommand.split((Way)affected, this.atNodes, Collections.emptyList());
        if (result == null) {
            return;
        }
        MainApplication.undoRedo.add((Command)result);
        List affectedWayList = result.getNewWays();
        for (Way way : affectedWayList) {
            if (!this.atNodes.contains(way.firstNode()) || !this.atNodes.contains(way.lastNode())) continue;
            selectedWay = way;
            break;
        }
        if (selectedWay != null) {
            affectedKeysList.add(affected.getKeys());
            this.newHighlights.add((OsmPrimitive)selectedWay);
            this.dialogBox(Arrays.asList(selectedWay), affectedKeysList);
        }
    }

    public void mouseMoved(MouseEvent e) {
        Cursor newCurs = DoubleSplitAction.getCursor();
        Node n = MainApplication.getMap().mapView.getNearestNode(e.getPoint(), AbstractPrimitive::isUsable);
        if (n != null) {
            this.newHighlights.add((OsmPrimitive)n);
            newCurs = this.cursorJoinNode;
        } else {
            List wss = MainApplication.getMap().mapView.getNearestWaySegments(e.getPoint(), OsmPrimitive::isSelectable);
            if (!wss.isEmpty()) {
                for (WaySegment ws : wss) {
                    this.newHighlights.add((OsmPrimitive)ws.way);
                }
                newCurs = this.cursorJoinWay;
            }
        }
        MainApplication.getMap().mapView.setCursor(newCurs);
        this.updateHighlights();
    }

    public void mouseClicked(MouseEvent e) {
        Node newStopPos;
        Boolean newNode = false;
        Node n = MainApplication.getMap().mapView.getNearestNode(e.getPoint(), AbstractPrimitive::isUsable);
        if (n == null) {
            newNode = true;
            newStopPos = new Node(MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY()));
        } else {
            newStopPos = new Node(n);
        }
        if (newNode.booleanValue()) {
            MainApplication.undoRedo.add((Command)new AddCommand(this.getLayerManager().getEditDataSet(), (OsmPrimitive)newStopPos));
        } else {
            MainApplication.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)n, (OsmPrimitive)newStopPos));
            newStopPos = n;
        }
        MainApplication.getLayerManager().getEditLayer().data.setSelected(new PrimitiveId[]{newStopPos});
        if (newNode.booleanValue()) {
            JoinNodeWayAction joinNodeWayAction = JoinNodeWayAction.createMoveNodeOntoWayAction();
            joinNodeWayAction.actionPerformed(null);
        }
        if (newStopPos.getParentWays().isEmpty()) {
            return;
        }
        Way affected = (Way)newStopPos.getParentWays().get(0);
        if (affected == null) {
            return;
        }
        this.atNodes.add(newStopPos);
        if (this.nodeCount == 0) {
            this.previousAffectedWay = affected;
            ++this.nodeCount;
            return;
        }
        boolean areStartEndPoints = this.startEndPoints();
        if (areStartEndPoints) {
            return;
        }
        boolean isConnectionNode = this.firstNodeIsConnectionNode(this.atNodes.get(0), affected);
        if (isConnectionNode) {
            return;
        }
        isConnectionNode = this.secondNodeIsConnectionNode(this.atNodes.get(1));
        if (isConnectionNode) {
            return;
        }
        if (this.atNodes.get(1).isConnectionNode()) {
            affected = this.previousAffectedWay;
        }
        Node commonNode = null;
        boolean twoWaysWithCommonNode = false;
        if (this.previousAffectedWay != affected) {
            commonNode = this.checkCommonNode(affected);
            if (commonNode == null) {
                this.removeFirstNode(affected);
                return;
            }
            twoWaysWithCommonNode = true;
        }
        if (twoWaysWithCommonNode) {
            this.addKeysOnBothWays(commonNode, affected);
        } else {
            this.addKeys(affected);
        }
        this.reset();
    }

    private void dialogBox(List<Way> selectedWay, List<TagMap> affectedKeysList) {
        SelectFromOptionDialog dialog = new SelectFromOptionDialog(selectedWay, affectedKeysList);
        dialog.toggleEnable("way.split.segment-selection-dialog");
        if (!dialog.toggleCheckState()) {
            dialog.setModal(false);
            dialog.showDialog();
            return;
        }
    }

    private void updateHighlights() {
        if (this.oldHighlights.isEmpty() && this.newHighlights.isEmpty()) {
            return;
        }
        for (OsmPrimitive osm : this.oldHighlights) {
            osm.setHighlighted(false);
        }
        for (OsmPrimitive osm : this.newHighlights) {
            osm.setHighlighted(true);
        }
        MainApplication.getLayerManager().getEditLayer().invalidate();
        this.oldHighlights.clear();
        this.oldHighlights.addAll(this.newHighlights);
        this.newHighlights.clear();
    }

    static class SelectFromOptionDialog
    extends ExtendedDialog {
        static final AtomicInteger DISPLAY_COUNT = new AtomicInteger();
        final transient List<Way> selectedWay;
        private JComboBox<String> keys;
        private JComboBox<String> values;
        private List<TagMap> affectedKeysList;

        SelectFromOptionDialog(List<Way> selectedWay, List<TagMap> affectedKeysList) {
            super(Main.parent, I18n.tr((String)"What do you want the segment to be?", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
            this.selectedWay = selectedWay;
            this.affectedKeysList = affectedKeysList;
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(new Integer[]{2});
            this.configureContextsensitiveHelp("/Dialog/AddValue", true);
            JPanel pane = new JPanel(new GridBagLayout());
            pane.add((Component)new JLabel("Select the appropriate option"), GBC.eol().fill(2));
            this.keys = new JComboBox();
            this.values = new JComboBox();
            this.keys.setEditable(true);
            this.keys.setModel(new DefaultComboBoxModel<String>(new String[]{"bus_bay", "bridge", "tunnel"}));
            this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"both", "right", "left"}));
            this.keys.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ("bus_bay".equals(keys.getSelectedItem())) {
                        values.setModel(new DefaultComboBoxModel<String>(new String[]{"both", "right", "left"}));
                    } else if ("bridge".equals(keys.getSelectedItem())) {
                        values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes"}));
                    } else if ("tunnel".equals(keys.getSelectedItem())) {
                        values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes", "culvert"}));
                    }
                }
            });
            pane.add(this.keys, GBC.eop().fill(2));
            pane.add(this.values, GBC.eop().fill(2));
            this.setContent(pane, false);
            this.setDefaultCloseOperation(1);
        }

        protected void buttonAction(int buttonIndex, ActionEvent evt) {
            super.buttonAction(buttonIndex, evt);
            this.toggleSaveState();
            if (this.getValue() == 1) {
                TagMap newKeys1 = this.affectedKeysList.get(0);
                newKeys1.put(this.keys.getSelectedItem().toString(), this.values.getSelectedItem().toString());
                if (this.keys.getSelectedItem() == "bridge") {
                    newKeys1.put("layer", "1");
                    this.selectedWay.get(0).setKeys(newKeys1);
                } else if (this.keys.getSelectedItem() == "tunnel") {
                    newKeys1.put("layer", "-1");
                    this.selectedWay.get(0).setKeys(newKeys1);
                } else {
                    this.selectedWay.get(0).setKeys(newKeys1);
                }
                if (this.affectedKeysList.size() == 2) {
                    TagMap newKeys2 = this.affectedKeysList.get(1);
                    newKeys2.put(this.keys.getSelectedItem().toString(), this.values.getSelectedItem().toString());
                    if (this.keys.getSelectedItem() == "bridge") {
                        newKeys2.put("layer", "1");
                        this.selectedWay.get(1).setKeys(newKeys2);
                    } else if (this.keys.getSelectedItem() == "tunnel") {
                        newKeys2.put("layer", "-1");
                        this.selectedWay.get(1).setKeys(newKeys2);
                    } else {
                        this.selectedWay.get(1).setKeys(newKeys2);
                    }
                }
            }
        }
    }
}

