/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessRuleset;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessRulesetReader;
import org.openstreetmap.josm.plugins.graphview.core.graph.TSBasedWayGraph;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadIncline;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadMaxaxleload;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadMaxheight;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadMaxlength;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadMaxspeed;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadMaxweight;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadMaxwidth;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadMinspeed;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadPropertyType;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadSurface;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadTracktype;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadWidth;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.DefaultNodePositioner;
import org.openstreetmap.josm.plugins.graphview.plugin.data.JOSMTransitionStructure;
import org.openstreetmap.josm.plugins.graphview.plugin.dialogs.GraphViewDialog;
import org.openstreetmap.josm.plugins.graphview.plugin.dialogs.GraphViewPreferenceEditor;
import org.openstreetmap.josm.plugins.graphview.plugin.layer.GraphViewLayer;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.GraphViewPreferences;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.InternalRuleset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class GraphViewPlugin
extends Plugin
implements LayerManager.LayerChangeListener,
Observer {
    private static final Collection<RoadPropertyType<?>> PROPERTIES = new LinkedList();
    private final GraphViewPreferences preferences = GraphViewPreferences.getInstance();
    private JOSMTransitionStructure transitionStructure;
    private GraphViewLayer graphViewLayer;

    public GraphViewPlugin(PluginInformation info) {
        super(info);
        this.preferences.addObserver(this);
    }

    public void createGraphViewLayer() {
        try {
            if (this.graphViewLayer != null) {
                AccessRuleset accessRuleset = this.getAccessRuleset();
                if (accessRuleset == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No ruleset has been selected!", (Object[])new Object[0]), I18n.tr((String)"No ruleset", (Object[])new Object[0]), 0);
                } else {
                    this.transitionStructure.setAccessParametersAndRuleset(this.preferences.getCurrentParameterBookmark(), accessRuleset);
                    this.transitionStructure.forceUpdate();
                }
            } else {
                AccessRuleset accessRuleset = this.getAccessRuleset();
                if (accessRuleset == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No ruleset has been selected!", (Object[])new Object[0]), I18n.tr((String)"No ruleset", (Object[])new Object[0]), 0);
                } else {
                    this.transitionStructure = new JOSMTransitionStructure(this.preferences.getCurrentParameterBookmark(), accessRuleset, PROPERTIES);
                    TSBasedWayGraph graph = new TSBasedWayGraph(this.transitionStructure);
                    this.graphViewLayer = new GraphViewLayer();
                    this.graphViewLayer.setWayGraph(graph);
                    this.graphViewLayer.setColorScheme(this.preferences.getCurrentColorScheme());
                    this.graphViewLayer.setArrowheadPlacement(this.preferences.getArrowheadPlacement());
                    this.graphViewLayer.setNodePositioner(new DefaultNodePositioner());
                    MainApplication.getLayerManager().addLayer((Layer)this.graphViewLayer);
                }
            }
        }
        catch (AccessRulesetReader.AccessRulesetSyntaxException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Syntax exception in access ruleset:\n{0}", (Object[])new Object[]{e}));
            Logging.error((Throwable)e);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"File not found:\n{0}", (Object[])new Object[]{e}));
            Logging.error((Throwable)e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Problem when accessing a file:\n{0}", (Object[])new Object[]{e}));
            Logging.error((Throwable)e);
        }
    }

    public void updateGraphViewLayer() {
        try {
            if (this.graphViewLayer != null) {
                AccessRuleset accessRuleset = this.getAccessRuleset();
                if (accessRuleset == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No ruleset has been selected!", (Object[])new Object[0]), I18n.tr((String)"No ruleset", (Object[])new Object[0]), 0);
                } else {
                    this.transitionStructure.setAccessParametersAndRuleset(this.preferences.getCurrentParameterBookmark(), accessRuleset);
                    this.transitionStructure.forceUpdate();
                }
            }
        }
        catch (AccessRulesetReader.AccessRulesetSyntaxException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Syntax exception in access ruleset:\n{0}", (Object[])new Object[]{e}));
            Logging.error((Throwable)e);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"File not found:\n", (Object[])new Object[]{e}));
            Logging.error((Throwable)e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Problem when accessing a file:\n{0}", (Object[])new Object[]{e}));
            Logging.error((Throwable)e);
        }
    }

    public void repaintGraphViewLayer() {
        if (this.graphViewLayer != null) {
            this.graphViewLayer.invalidate();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AccessRuleset getAccessRuleset() throws AccessRulesetReader.AccessRulesetSyntaxException, IOException, FileNotFoundException {
        void var1_7;
        if (this.preferences.getUseInternalRulesets()) {
            InternalRuleset ruleset = this.preferences.getCurrentInternalRuleset();
            if (ruleset == null) {
                return null;
            }
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL rulesetURL = classLoader.getResource(ruleset.getResourceName());
            if (rulesetURL == null) throw new FileNotFoundException(I18n.tr((String)"Couldn''t find built-in ruleset {0}", (Object[])new Object[]{ruleset}));
            InputStream inputStream = rulesetURL.openStream();
            return AccessRulesetReader.readAccessRuleset((InputStream)var1_7);
        } else {
            File rulesetFile = this.preferences.getCurrentRulesetFile();
            if (rulesetFile == null) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(rulesetFile);
        }
        return AccessRulesetReader.readAccessRuleset((InputStream)var1_7);
    }

    public PreferenceSetting getPreferenceSetting() {
        return new GraphViewPreferenceEditor();
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            if (oldFrame == null) {
                GraphViewDialog laneDialog = new GraphViewDialog(this);
                newFrame.addToggleDialog((ToggleDialog)laneDialog);
            }
            MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        } else {
            MainApplication.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
        }
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() == this.graphViewLayer) {
            this.graphViewLayer = null;
        } else if (e.getRemovedLayer() == MainApplication.getLayerManager().getEditLayer() && this.graphViewLayer != null) {
            MainApplication.getLayerManager().removeLayer((Layer)this.graphViewLayer);
            this.graphViewLayer = null;
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 == this.preferences && this.graphViewLayer != null) {
            this.graphViewLayer.setColorScheme(this.preferences.getCurrentColorScheme());
            this.graphViewLayer.setArrowheadPlacement(this.preferences.getArrowheadPlacement());
        }
    }

    static {
        PROPERTIES.add(new RoadIncline());
        PROPERTIES.add(new RoadMaxaxleload());
        PROPERTIES.add(new RoadMaxheight());
        PROPERTIES.add(new RoadMaxlength());
        PROPERTIES.add(new RoadMaxspeed());
        PROPERTIES.add(new RoadMaxweight());
        PROPERTIES.add(new RoadMaxwidth());
        PROPERTIES.add(new RoadMinspeed());
        PROPERTIES.add(new RoadSurface());
        PROPERTIES.add(new RoadTracktype());
        PROPERTIES.add(new RoadWidth());
    }
}

