/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;
import relcontext.relationfix.AssociatedStreetFixer;
import relcontext.relationfix.BoundaryFixer;
import relcontext.relationfix.MultipolygonFixer;
import relcontext.relationfix.NothingFixer;
import relcontext.relationfix.PublicTransportFixer;
import relcontext.relationfix.RelationFixer;

public class SortAndFixAction
extends AbstractAction
implements ChosenRelationListener {
    private static final long serialVersionUID = 1L;
    private ChosenRelation rel;
    private List<RelationFixer> fixers;

    public SortAndFixAction(ChosenRelation rel) {
        this.putValue("SmallIcon", ImageProvider.get((String)"data", (String)"warning"));
        this.putValue("ShortDescription", I18n.tr((String)"Fix roles of the chosen relation members", (Object[])new Object[0]));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(false);
        this.fixers = new ArrayList<RelationFixer>();
        this.fixers.add(new BoundaryFixer());
        this.fixers.add(new MultipolygonFixer());
        this.fixers.add(new AssociatedStreetFixer());
        this.fixers.add(new PublicTransportFixer());
        for (RelationFixer fix : this.fixers) {
            fix.setFixAction(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command c = this.fixRelation(this.rel.get());
        if (c != null) {
            MainApplication.undoRedo.add(c);
        }
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(newRelation != null && this.needsFixing(newRelation));
    }

    public boolean needsFixing(Relation rel) {
        return !SortAndFixAction.isIncomplete(rel) && !this.getFixer(rel).isRelationGood(rel);
    }

    private RelationFixer getFixer(Relation rel) {
        for (RelationFixer fixer : this.fixers) {
            if (!fixer.isFixerApplicable(rel)) continue;
            return fixer;
        }
        return new NothingFixer();
    }

    public Command fixRelation(Relation rel) {
        return this.getFixer(rel).fixRelation(rel);
    }

    protected static boolean isIncomplete(Relation r) {
        if (r == null || r.isIncomplete() || r.isDeleted()) {
            return true;
        }
        for (RelationMember m : r.getMembers()) {
            if (!m.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }
}

