/*
 * Decompiled with CFR 0.152.
 */
package com.tilusnet.josm.plugins.alignways;

import com.tilusnet.josm.plugins.alignways.AlignWaysAlgnSegment;
import com.tilusnet.josm.plugins.alignways.AlignWaysRefSegment;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.I18n;

public class AlignWaysSegmentMgr {
    private static volatile AlignWaysSegmentMgr singleton;
    private AlignWaysRefSegment refSeg = null;
    private AlignWaysAlgnSegment algnSeg = null;
    private final MapView mv;

    private AlignWaysSegmentMgr(MapView mapView) {
        this.mv = mapView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlignWaysSegmentMgr getInstance(MapView mapView) {
        Class<AlignWaysSegmentMgr> clazz = AlignWaysSegmentMgr.class;
        synchronized (AlignWaysSegmentMgr.class) {
            if (singleton == null || !singleton.getMapView().equals(mapView)) {
                singleton = new AlignWaysSegmentMgr(mapView);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private MapView getMapView() {
        return this.mv;
    }

    public boolean algnUpdate(Point clickedPoint) {
        if (this.algnSeg != null && this.algnSeg.updatePivot(clickedPoint)) {
            return false;
        }
        AlignWaysAlgnSegment tmpAlgnSeg = new AlignWaysAlgnSegment(this.mv, clickedPoint);
        if (tmpAlgnSeg.getSegment() == null) {
            return false;
        }
        if (this.algnSeg != null && tmpAlgnSeg.equals(this.algnSeg)) {
            return false;
        }
        if (this.refSeg != null && tmpAlgnSeg.equals(this.refSeg)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Segment to be aligned cannot be the same with the reference segment.\nPlease choose a different segment to be aligned.", (Object[])new Object[0]), I18n.tr((String)"AlignWayS message", (Object[])new Object[0]), 2);
            return false;
        }
        if (this.algnSeg != null) {
            this.algnSeg.destroy();
        }
        this.algnSeg = tmpAlgnSeg;
        return true;
    }

    public boolean refUpdate(Point clickedPoint) {
        AlignWaysRefSegment tmpRefSeg = new AlignWaysRefSegment(this.mv, clickedPoint);
        if (tmpRefSeg.getSegment() == null) {
            return false;
        }
        if (this.refSeg != null && this.refSeg.equals(tmpRefSeg)) {
            return false;
        }
        if (this.algnSeg != null && tmpRefSeg.equals(this.algnSeg)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Reference segment cannot be the same with the segment to be aligned.\nPlease choose a different reference segment.", (Object[])new Object[0]), I18n.tr((String)"AlignWayS message", (Object[])new Object[0]), 2);
            return false;
        }
        if (this.refSeg != null) {
            this.refSeg.destroy();
        }
        this.refSeg = tmpRefSeg;
        return true;
    }

    public Collection<Node> getSelectedNodes() {
        if (this.algnSeg != null) {
            return this.algnSeg.getSegmentEndPoints();
        }
        return null;
    }

    public void cleanupWays() {
        if (this.algnSeg != null) {
            this.algnSeg.destroy();
            this.algnSeg = null;
        }
        if (this.refSeg != null) {
            this.refSeg.destroy();
            this.refSeg = null;
        }
    }

    public AlignWaysAlgnSegment getAlgnSeg() {
        return this.algnSeg;
    }

    public AlignWaysRefSegment getRefSeg() {
        return this.refSeg;
    }

    public boolean primitivesRemoved(List<? extends OsmPrimitive> primitives) {
        boolean changed = false;
        for (OsmPrimitive osmPrimitive : primitives) {
            if (this.algnSeg != null && this.algnSeg.containsPrimitive(osmPrimitive)) {
                this.algnSeg.destroy();
                this.algnSeg = null;
                changed = true;
            }
            if (this.refSeg == null || !this.refSeg.containsPrimitive(osmPrimitive)) continue;
            this.refSeg.destroy();
            this.refSeg = null;
            changed = true;
        }
        return changed;
    }
}

