/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImageLayer;
import org.openstreetmap.josm.plugins.ImportImagePlugin.LoadImageAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ImportImageFileImporter
extends FileImporter {
    private Logger logger = Logger.getLogger(LoadImageAction.class);

    public ImportImageFileImporter() {
        super(new ExtensionFileFilter("tiff,tif,jpg,jpeg,bmp,png", "jpg", "Georeferenced image file [by ImportImage plugin] (*.jpg, *.jpeg, *.tif, *.tiff, *.png, *.bmp)"));
    }

    public boolean isBatchImporter() {
        return true;
    }

    public double getPriority() {
        return -3.0;
    }

    public void importData(List<File> files, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        if (null == files) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            ImageLayer layer = null;
            this.logger.info((Object)("File choosen:" + file));
            try {
                layer = new ImageLayer(file);
            }
            catch (ImageLayer.LayerCreationCanceledException e) {
                continue;
            }
            catch (Exception e) {
                Logging.error((Throwable)e);
                this.logger.error((Object)("Error while creating image layer: \n" + e.getMessage()));
                GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while creating image layer: {0}", (Object[])new Object[]{e.getCause()})));
                continue;
            }
            MainApplication.getLayerManager().addLayer((Layer)layer);
        }
    }
}

