/*
 * Decompiled with CFR 0.152.
 */
package ru.rodsoft.openstreetmap.josm.plugins.customizepublictransportstop;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import ru.rodsoft.openstreetmap.josm.plugins.customizepublictransportstop.CreateNewStopPointOperation;
import ru.rodsoft.openstreetmap.josm.plugins.customizepublictransportstop.MessageBox;
import ru.rodsoft.openstreetmap.josm.plugins.customizepublictransportstop.StopArea;
import ru.rodsoft.openstreetmap.josm.plugins.customizepublictransportstop.StopAreaOperationBase;

public class CustomizeStopAreaOperation
extends StopAreaOperationBase {
    private static final String TAG_ASSIGN_COMMAND_NAME = "Stop area tag assign";

    public CustomizeStopAreaOperation(DataSet currentDataSet) {
        super(currentDataSet);
    }

    public List<Command> nameTagAssign(OsmPrimitive target, List<Command> commands, StopArea stopArea) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        commands = CustomizeStopAreaOperation.assignTag(commands, target, "name", "".equals(stopArea.name) ? null : stopArea.name);
        commands = CustomizeStopAreaOperation.assignTag(commands, target, "name:en", "".equals(stopArea.nameEn) ? null : stopArea.nameEn);
        return commands;
    }

    protected List<Command> transportTypeTagClearing(OsmPrimitive target, List<Command> commands) {
        commands = CustomizeStopAreaOperation.clearTag(commands, target, "bus");
        commands = CustomizeStopAreaOperation.clearTag(commands, target, "share_taxi");
        commands = CustomizeStopAreaOperation.clearTag(commands, target, "trolleybus");
        commands = CustomizeStopAreaOperation.clearTag(commands, target, "tram");
        commands = CustomizeStopAreaOperation.clearTag(commands, target, "train");
        return commands;
    }

    protected List<Command> transportTypeTagAssign(OsmPrimitive target, List<Command> commands, StopArea stopArea, Boolean isStopPoint) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        if (isStopPoint.booleanValue()) {
            if (stopArea.isTrainStop.booleanValue() || stopArea.isTrainStation.booleanValue()) {
                commands = CustomizeStopAreaOperation.clearTag(commands, target, "bus");
                commands = CustomizeStopAreaOperation.clearTag(commands, target, "share_taxi");
                commands = CustomizeStopAreaOperation.clearTag(commands, target, "trolleybus");
                commands = CustomizeStopAreaOperation.clearTag(commands, target, "tram");
                commands = CustomizeStopAreaOperation.assignTag(commands, target, "train", "yes");
            } else {
                commands = CustomizeStopAreaOperation.assignTag(commands, target, "bus", stopArea.isBus != false ? "yes" : null);
                commands = CustomizeStopAreaOperation.assignTag(commands, target, "share_taxi", stopArea.isShareTaxi != false ? "yes" : null);
                commands = CustomizeStopAreaOperation.assignTag(commands, target, "trolleybus", stopArea.isTrolleybus != false ? "yes" : null);
                commands = CustomizeStopAreaOperation.assignTag(commands, target, "tram", stopArea.isTram != false ? "yes" : null);
                commands = CustomizeStopAreaOperation.assignTag(commands, target, "train", stopArea.isTrainStation != false || stopArea.isTrainStop != false ? "yes" : null);
            }
        } else if (stopArea.isAssignTransportType.booleanValue()) {
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "bus", stopArea.isBus != false ? "yes" : null);
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "share_taxi", stopArea.isShareTaxi != false ? "yes" : null);
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "trolleybus", stopArea.isTrolleybus != false ? "yes" : null);
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "tram", stopArea.isTram != false ? "yes" : null);
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "train", stopArea.isTrainStation != false || stopArea.isTrainStop != false ? "yes" : null);
        } else {
            commands = this.transportTypeTagClearing(target, commands);
        }
        return commands;
    }

    public List<Command> generalTagAssign(OsmPrimitive target, List<Command> commands, StopArea stopArea) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        commands = this.nameTagAssign(target, commands, stopArea);
        commands = CustomizeStopAreaOperation.assignTag(commands, target, "network", "".equals(stopArea.network) ? null : stopArea.network);
        commands = CustomizeStopAreaOperation.assignTag(commands, target, "operator", "".equals(stopArea.operator) ? null : stopArea.operator);
        commands = CustomizeStopAreaOperation.assignTag(commands, target, "service", null == stopArea.service || "city".equals(stopArea.service) ? null : stopArea.service);
        return commands;
    }

    public List<Command> stopPointTagAssign(OsmPrimitive target, List<Command> commands, StopArea stopArea, Boolean isFirst) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        commands = this.generalTagAssign(target, commands, stopArea);
        commands = this.transportTypeTagAssign(target, commands, stopArea, true);
        commands = isFirst.booleanValue() ? (stopArea.isTrainStop.booleanValue() ? CustomizeStopAreaOperation.assignTag(commands, target, "railway", "halt") : (stopArea.isTrainStation.booleanValue() ? CustomizeStopAreaOperation.assignTag(commands, target, "railway", "station") : (stopArea.isTram.booleanValue() ? CustomizeStopAreaOperation.assignTag(commands, target, "railway", "tram_stop") : CustomizeStopAreaOperation.clearTag(commands, target, "railway")))) : CustomizeStopAreaOperation.clearTag(commands, target, "railway");
        if (CustomizeStopAreaOperation.compareTag(target, "highway", "bus_stop").booleanValue()) {
            commands = CustomizeStopAreaOperation.clearTag(commands, target, "highway");
        }
        if (CustomizeStopAreaOperation.compareTag(target, "amenity", "bus_station").booleanValue()) {
            commands = CustomizeStopAreaOperation.clearTag(commands, target, "amenity");
        }
        commands = CustomizeStopAreaOperation.assignTag(commands, target, "public_transport", "stop_position");
        return commands;
    }

    public List<Command> platformTagAssign(OsmPrimitive target, List<Command> commands, StopArea stopArea, Boolean isFirst) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        commands = this.generalTagAssign(target, commands, stopArea);
        commands = this.transportTypeTagAssign(target, commands, stopArea, false);
        if (CustomizeStopAreaOperation.compareTag(target, "railway", "halt").booleanValue() || CustomizeStopAreaOperation.compareTag(target, "railway", "station").booleanValue()) {
            commands = CustomizeStopAreaOperation.clearTag(commands, target, "railway");
        }
        if (target instanceof Way && (stopArea.isTrainStop.booleanValue() || stopArea.isTrainStation.booleanValue() || stopArea.isTram.booleanValue())) {
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "railway", "platform");
        }
        if (stopArea.isBus.booleanValue() || stopArea.isShareTaxi.booleanValue() || stopArea.isTrolleybus.booleanValue()) {
            if (target instanceof Way) {
                commands = CustomizeStopAreaOperation.assignTag(commands, target, "highway", "platform");
            } else if (isFirst.booleanValue() && !stopArea.isBusStation.booleanValue()) {
                commands = CustomizeStopAreaOperation.assignTag(commands, target, "highway", "bus_stop");
            }
        }
        commands = CustomizeStopAreaOperation.assignTag(commands, target, "public_transport", "platform");
        if (target == stopArea.selectedObject) {
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "bench", stopArea.isBench != false ? "yes" : null);
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "shelter", stopArea.isShelter != false ? "yes" : null);
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "covered", stopArea.isCovered != false ? "yes" : null);
            commands = CustomizeStopAreaOperation.assignTag(commands, target, "area", stopArea.isArea != false ? "yes" : null);
        }
        return commands;
    }

    public List<Command> otherMemberTagAssign(OsmPrimitive target, List<Command> commands, StopArea stopArea) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        commands = this.nameTagAssign(target, commands, stopArea);
        commands = CustomizeStopAreaOperation.clearTag(commands, target, "network");
        commands = CustomizeStopAreaOperation.clearTag(commands, target, "operator");
        commands = CustomizeStopAreaOperation.clearTag(commands, target, "service");
        if (CustomizeStopAreaOperation.compareTag(target, "railway", "halt").booleanValue() || CustomizeStopAreaOperation.compareTag(target, "railway", "station").booleanValue()) {
            commands = CustomizeStopAreaOperation.clearTag(commands, target, "railway");
        }
        return commands;
    }

    private List<Command> createStopAreaRelation(List<Command> commands, StopArea stopArea) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        Relation newRelation = new Relation();
        for (Node node : stopArea.stopPoints) {
            newRelation.addMember(new RelationMember("stop", (OsmPrimitive)node));
        }
        for (OsmPrimitive platform : stopArea.platforms) {
            newRelation.addMember(new RelationMember("platform", platform));
        }
        for (OsmPrimitive otherMember : stopArea.otherMembers) {
            newRelation.addMember(new RelationMember("", otherMember));
        }
        Main.main.undoRedo.add((Command)new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)newRelation));
        commands = this.generalTagAssign((OsmPrimitive)newRelation, commands, stopArea);
        commands = CustomizeStopAreaOperation.assignTag(commands, (OsmPrimitive)newRelation, "type", "public_transport");
        commands = CustomizeStopAreaOperation.assignTag(commands, (OsmPrimitive)newRelation, "public_transport", "stop_area");
        return commands;
    }

    public static List<Command> addNewRelationMember(List<Command> commands, Relation targetRelation, OsmPrimitive member, String roleName) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        for (RelationMember relationMember : targetRelation.getMembers()) {
            if (relationMember.getMember() != member) continue;
            if (relationMember.getRole() == roleName) {
                return commands;
            }
            return commands;
        }
        targetRelation.addMember(new RelationMember(roleName, member));
        commands.add((Command)new ChangeCommand((OsmPrimitive)targetRelation, (OsmPrimitive)targetRelation));
        return commands;
    }

    private List<Command> addNewRelationMembers(List<Command> commands, StopArea stopArea) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        for (OsmPrimitive osmPrimitive : stopArea.stopPoints) {
            commands = CustomizeStopAreaOperation.addNewRelationMember(commands, stopArea.stopAreaRelation, osmPrimitive, "stop");
        }
        for (OsmPrimitive osmPrimitive : stopArea.platforms) {
            commands = CustomizeStopAreaOperation.addNewRelationMember(commands, stopArea.stopAreaRelation, osmPrimitive, "platform");
        }
        for (OsmPrimitive osmPrimitive : stopArea.otherMembers) {
            commands = CustomizeStopAreaOperation.addNewRelationMember(commands, stopArea.stopAreaRelation, osmPrimitive, null);
        }
        return commands;
    }

    private Node searchBusStop(OsmPrimitive member, String tag, String tagValue) {
        if (member instanceof Node) {
            if (CustomizeStopAreaOperation.compareTag(member, tag, tagValue).booleanValue()) {
                return (Node)member;
            }
        } else {
            Way memberWay = (Way)member;
            for (Node node : memberWay.getNodes()) {
                if (!CustomizeStopAreaOperation.compareTag((OsmPrimitive)node, tag, tagValue).booleanValue()) continue;
                return node;
            }
        }
        return null;
    }

    public Node searchBusStop(StopArea stopArea, String tag, String tagValue) {
        Node busStopNode;
        for (OsmPrimitive platform : stopArea.platforms) {
            busStopNode = this.searchBusStop(platform, tag, tagValue);
            if (busStopNode == null) continue;
            return busStopNode;
        }
        for (OsmPrimitive otherMember : stopArea.otherMembers) {
            busStopNode = this.searchBusStop(otherMember, tag, tagValue);
            if (busStopNode == null) continue;
            return busStopNode;
        }
        return null;
    }

    public boolean needSeparateBusStop(StopArea stopArea, OsmPrimitive firstPlatform) {
        return (stopArea.isBus != false || stopArea.isShareTaxi != false || stopArea.isTrolleybus != false) && firstPlatform instanceof Way;
    }

    private List<Command> clearExcessTags(List<Command> commands, OsmPrimitive target, String tag, String tagValue) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        if (CustomizeStopAreaOperation.compareTag(target, tag, tagValue).booleanValue()) {
            commands = CustomizeStopAreaOperation.clearTag(commands, target, tag);
        }
        if (target instanceof Way) {
            Way memberWay = (Way)target;
            for (Node node : memberWay.getNodes()) {
                if (!CustomizeStopAreaOperation.compareTag((OsmPrimitive)node, tag, tagValue).booleanValue()) continue;
                commands = CustomizeStopAreaOperation.clearTag(commands, target, tag);
            }
        }
        return commands;
    }

    public List<Command> clearExcessTags(List<Command> commands, StopArea stopArea, String tag, String tagValue) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        for (OsmPrimitive osmPrimitive : stopArea.stopPoints) {
            this.clearExcessTags(commands, osmPrimitive, tag, tagValue);
        }
        for (OsmPrimitive osmPrimitive : stopArea.platforms) {
            this.clearExcessTags(commands, osmPrimitive, tag, tagValue);
        }
        for (OsmPrimitive osmPrimitive : stopArea.otherMembers) {
            this.clearExcessTags(commands, osmPrimitive, tag, tagValue);
        }
        return commands;
    }

    protected List<Command> createSeparateBusStopNode(List<Command> commands, StopArea stopArea, OsmPrimitive firstPlatform, String tag, String tagValue) {
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        LatLon centerOfPlatform = CustomizeStopAreaOperation.getCenterOfWay(firstPlatform);
        if (firstPlatform instanceof Way) {
            if (centerOfPlatform != null) {
                Node newNode = new Node();
                newNode.setCoor(centerOfPlatform);
                Main.main.undoRedo.add((Command)new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)newNode));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)newNode, tag, tagValue));
                commands = CustomizeStopAreaOperation.assignTag(commands, (OsmPrimitive)newNode, tag, tagValue);
                stopArea.otherMembers.add((OsmPrimitive)newNode);
            }
        } else {
            commands = CustomizeStopAreaOperation.assignTag(commands, firstPlatform, tag, tagValue);
        }
        return commands;
    }

    public List<Command> customize(StopArea stopArea) {
        try {
            List<Command> commands = new ArrayList<Command>();
            Node separateBusStopNode = this.searchBusStop(stopArea, "amenity", "bus_station");
            if (separateBusStopNode == null) {
                separateBusStopNode = this.searchBusStop(stopArea, "highway", "bus_stop");
            }
            commands = stopArea.isBusStation != false ? this.clearExcessTags(commands, stopArea, "highway", "bus_stop") : this.clearExcessTags(commands, stopArea, "amenity", "bus_station");
            if (!(stopArea.isBus.booleanValue() || stopArea.isShareTaxi.booleanValue() || stopArea.isTrolleybus.booleanValue())) {
                commands = this.clearExcessTags(commands, stopArea, "highway", "bus_stop");
            }
            if (stopArea.stopPoints.size() == 0) {
                CreateNewStopPointOperation createNewStopPointOperation = new CreateNewStopPointOperation(this.getCurrentDataSet());
                createNewStopPointOperation.performCustomizing(stopArea);
            }
            Boolean isFirst = true;
            for (Node node : stopArea.stopPoints) {
                commands = this.stopPointTagAssign((OsmPrimitive)node, commands, stopArea, isFirst);
                isFirst = false;
            }
            isFirst = true;
            OsmPrimitive firstPlatform = null;
            for (OsmPrimitive platform : stopArea.platforms) {
                commands = this.platformTagAssign(platform, commands, stopArea, isFirst);
                if (isFirst.booleanValue()) {
                    firstPlatform = platform;
                }
                isFirst = false;
            }
            if (this.needSeparateBusStop(stopArea, firstPlatform)) {
                commands = stopArea.isBusStation.booleanValue() ? (separateBusStopNode == null ? this.createSeparateBusStopNode(commands, stopArea, firstPlatform, "amenity", "bus_station") : CustomizeStopAreaOperation.assignTag(commands, (OsmPrimitive)separateBusStopNode, "amenity", "bus_station")) : (separateBusStopNode == null ? this.createSeparateBusStopNode(commands, stopArea, firstPlatform, "highway", "bus_stop") : CustomizeStopAreaOperation.assignTag(commands, (OsmPrimitive)separateBusStopNode, "highway", "bus_stop"));
            } else if (stopArea.isBusStation.booleanValue()) {
                commands = CustomizeStopAreaOperation.assignTag(commands, firstPlatform, "amenity", "bus_station");
            } else if (stopArea.isBus.booleanValue() || stopArea.isTrolleybus.booleanValue() || stopArea.isShareTaxi.booleanValue()) {
                commands = CustomizeStopAreaOperation.assignTag(commands, firstPlatform, "highway", "bus_stop");
            }
            for (OsmPrimitive otherMember : stopArea.otherMembers) {
                commands = this.otherMemberTagAssign(otherMember, commands, stopArea);
            }
            if (stopArea.stopAreaRelation == null) {
                if (stopArea.stopPoints.size() + stopArea.platforms.size() + stopArea.otherMembers.size() > 1) {
                    commands = this.createStopAreaRelation(commands, stopArea);
                }
            } else {
                commands = this.generalTagAssign((OsmPrimitive)stopArea.stopAreaRelation, commands, stopArea);
                commands = this.transportTypeTagClearing((OsmPrimitive)stopArea.stopAreaRelation, commands);
                commands = this.addNewRelationMembers(commands, stopArea);
            }
            return commands;
        }
        catch (Exception ex) {
            MessageBox.ok(ex.getMessage());
            return null;
        }
    }

    @Override
    public StopArea performCustomizing(StopArea stopArea) {
        List<Command> commands = this.customize(stopArea);
        if (commands != null && !commands.isEmpty()) {
            try {
                Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)TAG_ASSIGN_COMMAND_NAME, (Object[])new Object[0]), commands));
                return stopArea;
            }
            catch (Exception ex) {
                Logging.error((Throwable)ex);
            }
        }
        return stopArea;
    }
}

