/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.turnlanes.gui.Path;
import org.openstreetmap.josm.plugins.turnlanes.gui.ReversePathIterator;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;

final class GuiUtil {
    private GuiUtil() {
    }

    static double normalize(double a) {
        while (a < 0.0) {
            a += Math.PI * 2;
        }
        while (a > Math.PI * 2) {
            a -= Math.PI * 2;
        }
        return a;
    }

    static double cpf(double a, double scale) {
        return 1.3333333333333333 * Math.tan(Math.min(Math.abs(a), 3.1405926535897932) / 4.0) * scale;
    }

    static Point2D intersection(Line2D a, Line2D b) {
        double ab;
        double aa = GuiUtil.angle(a);
        if (Math.abs(Math.PI - Math.abs(GuiUtil.minAngleDiff(aa, ab = GuiUtil.angle(b)))) < Math.PI / 360) {
            return null;
        }
        double d = (a.getX1() - a.getX2()) * (b.getY1() - b.getY2()) - (a.getY1() - a.getY2()) * (b.getX1() - b.getX2());
        double x = ((b.getX1() - b.getX2()) * (a.getX1() * a.getY2() - a.getY1() * a.getX2()) - (a.getX1() - a.getX2()) * (b.getX1() * b.getY2() - b.getY1() * b.getX2())) / d;
        double y = ((b.getY1() - b.getY2()) * (a.getX1() * a.getY2() - a.getY1() * a.getX2()) - (a.getY1() - a.getY2()) * (b.getX1() * b.getY2() - b.getY1() * b.getX2())) / d;
        return new Point2D.Double(x, y);
    }

    static Point2D closest(Line2D l, Point2D p) {
        Point2D lv = GuiUtil.vector(l.getP1(), l.getP2());
        double numerator = GuiUtil.dot(GuiUtil.vector(l.getP1(), p), lv);
        if (numerator < 0.0) {
            return l.getP1();
        }
        double denominator = GuiUtil.dot(lv, lv);
        if (numerator >= denominator) {
            return l.getP2();
        }
        double r = numerator / denominator;
        return new Point2D.Double(l.getX1() + r * lv.getX(), l.getY1() + r * lv.getY());
    }

    private static double dot(Point2D a, Point2D b) {
        return a.getX() * b.getX() + a.getY() * b.getY();
    }

    private static Point2D vector(Point2D from, Point2D to) {
        return new Point2D.Double(to.getX() - from.getX(), to.getY() - from.getY());
    }

    public static double angle(Point2D from, Point2D to) {
        double dx = to.getX() - from.getX();
        double dy = -(to.getY() - from.getY());
        return GuiUtil.normalize(Math.atan2(dy, dx));
    }

    public static Point2D relativePoint(Point2D p, double r, double a) {
        return new Point2D.Double(p.getX() + r * Math.cos(a), p.getY() - r * Math.sin(a));
    }

    public static Line2D relativeLine(Line2D l, double r, double a) {
        double dx = r * Math.cos(a);
        double dy = -r * Math.sin(a);
        return new Line2D.Double(l.getX1() + dx, l.getY1() + dy, l.getX2() + dx, l.getY2() + dy);
    }

    public static double angle(Line2D l) {
        return GuiUtil.angle(l.getP1(), l.getP2());
    }

    public static double minAngleDiff(double a1, double a2) {
        double d = GuiUtil.normalize(a2 - a1);
        return d > Math.PI ? -(Math.PI * 2 - d) : d;
    }

    public static Point2D middle(Point2D a, Point2D b) {
        return GuiUtil.relativePoint(a, a.distance(b) / 2.0, GuiUtil.angle(a, b));
    }

    public static Point2D middle(Line2D l) {
        return GuiUtil.middle(l.getP1(), l.getP2());
    }

    public static Line2D line(Point2D p, double a) {
        return new Line2D.Double(p, GuiUtil.relativePoint(p, 1.0, a));
    }

    public static Point2D loc(Node node) {
        EastNorth loc = Main.getProjection().latlon2eastNorth(node.getCoor());
        return new Point2D.Double(loc.getX(), -loc.getY());
    }

    public static List<Point2D> locs(Iterable<Junction> junctions) {
        ArrayList<Point2D> locs = new ArrayList<Point2D>();
        for (Junction j : junctions) {
            locs.add(GuiUtil.loc(j.getNode()));
        }
        return locs;
    }

    static void area(Path2D area, Path inner, Path outer) {
        area.append(inner.getIterator(), false);
        area.append(ReversePathIterator.reverse(outer.getIterator()), true);
        area.closePath();
    }
}

