/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.command;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.plugins.piclayer.transform.PictureTransform;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TransformCommand
extends Command {
    private PicLayerAbstract layer;
    private PictureTransform beforeTransform;
    private PictureTransform afterTransform;
    private String actionName;
    private boolean alreadyAdded = false;

    public TransformCommand(PicLayerAbstract layer, String actionName) {
        super(new DataSet());
        this.layer = layer;
        this.actionName = actionName;
        this.beforeTransform = this.extractTransform();
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public boolean executeCommand() {
        this.placeTransform(this.afterTransform);
        this.layer.invalidate();
        return true;
    }

    public void undoCommand() {
        this.placeTransform(this.beforeTransform);
        this.layer.invalidate();
    }

    private void placeTransform(PictureTransform transform) {
        this.layer.getTransformer().setTransform(transform.getTransform());
        this.layer.getTransformer().setOriginPoints(transform.getOriginPoints());
        this.layer.getTransformer().setImagePosition(transform.getImagePosition());
    }

    private PictureTransform extractTransform() {
        PictureTransform transform = new PictureTransform();
        transform.setOriginPoints(this.layer.getTransformer().getOriginPoints());
        transform.setTransform(this.layer.getTransformer().getTransform());
        transform.setImagePosition(this.layer.getTransformer().getImagePosition());
        return transform;
    }

    public Icon getDescriptionIcon() {
        return ImageProvider.get((String)"layericon");
    }

    public String getDescriptionText() {
        return I18n.tr((String)"PicLayer: {0}", (Object[])new Object[]{this.actionName});
    }

    public void addIfChanged() {
        boolean changed;
        this.afterTransform = this.extractTransform();
        boolean bl = changed = !this.beforeTransform.getTransform().equals(this.afterTransform.getTransform()) || !this.beforeTransform.getOriginPoints().equals(this.afterTransform.getOriginPoints()) || !this.beforeTransform.getImagePosition().equals((Object)this.afterTransform.getImagePosition());
        if (changed && !this.alreadyAdded) {
            Main.main.undoRedo.add((Command)this);
            this.alreadyAdded = true;
        }
    }
}

