/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.data;

import java.util.Comparator;
import java.util.Optional;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;
import org.wikipedia.WikipediaApp;
import org.wikipedia.data.WikipediaEntry;

public class WikidataEntry
extends WikipediaEntry {
    public final String label;
    public final String description;

    public WikidataEntry(String id, String label, LatLon coordinate, String description) {
        super("wikidata", id, coordinate);
        this.label = label;
        this.description = description;
        WikidataEntry.ensureValidWikidataId(id);
    }

    @Override
    public Tag createWikipediaTag() {
        return new Tag("wikidata", this.article);
    }

    @Override
    public String getLabelText() {
        String descriptionInParen = this.description == null ? "" : " (" + this.description + ")";
        return WikidataEntry.getLabelText(this.label, this.article + descriptionInParen);
    }

    public static String getLabelText(String bold, String gray) {
        return Utils.escapeReservedCharactersHTML((String)bold) + " <span color='gray'>" + Utils.escapeReservedCharactersHTML((String)gray) + "</span>";
    }

    @Override
    public String getSearchText() {
        return Optional.ofNullable(this.label).orElse(this.article);
    }

    private static void ensureValidWikidataId(String id) {
        CheckParameterUtil.ensureThat((boolean)WikipediaApp.WIKIDATA_PATTERN.matcher(id).matches(), (String)("Invalid Wikidata ID given: " + id));
    }

    @Override
    public int compareTo(WikipediaEntry o) {
        if (o instanceof WikidataEntry) {
            return Comparator.comparing(x -> x.label, AlphanumComparator.getInstance()).thenComparing(x -> x.article, AlphanumComparator.getInstance()).compare(this, (WikidataEntry)o);
        }
        return super.compareTo(o);
    }
}

