/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractCsvLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="CsvParameterLayout", category="Core", elementType="layout", printObject=true)
public class CsvParameterLayout
extends AbstractCsvLayout {
    private static final long serialVersionUID = 1L;

    public static AbstractCsvLayout createDefaultLayout() {
        return new CsvParameterLayout(Charset.forName("UTF-8"), CSVFormat.valueOf((String)"Default"), null, null);
    }

    public static AbstractCsvLayout createLayout(CSVFormat format) {
        return new CsvParameterLayout(Charset.forName("UTF-8"), format, null, null);
    }

    @PluginFactory
    public static AbstractCsvLayout createLayout(@PluginAttribute(value="format", defaultString="Default") String format, @PluginAttribute(value="delimiter") Character delimiter, @PluginAttribute(value="escape") Character escape, @PluginAttribute(value="quote") Character quote, @PluginAttribute(value="quoteMode") QuoteMode quoteMode, @PluginAttribute(value="nullString") String nullString, @PluginAttribute(value="recordSeparator") String recordSeparator, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginAttribute(value="header") String header, @PluginAttribute(value="footer") String footer) {
        CSVFormat csvFormat = CsvParameterLayout.createFormat(format, delimiter, escape, quote, quoteMode, nullString, recordSeparator);
        return new CsvParameterLayout(charset, csvFormat, header, footer);
    }

    public CsvParameterLayout(Charset charset, CSVFormat csvFormat, String header, String footer) {
        super(charset, csvFormat, header, footer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toSerializable(LogEvent event) {
        Message message = event.getMessage();
        Object[] parameters = message.getParameters();
        StringBuilder buffer = this.getStringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)buffer, this.getFormat());){
            printer.printRecord(parameters);
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            StatusLogger.getLogger().error(message, (Throwable)e);
            return this.getFormat().getCommentMarker() + " " + e;
        }
    }
}

