/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec.features;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import de.bwaldvogel.liblinear.FeatureNode;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.osmrec.container.OSMWay;

public class GeometryFeatures {
    private int id;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private static final int NUMBER_OF_AREA_FEATURES = 25;
    private static final int NUMBER_OF_POINTS = 13;
    private static final int NUMBER_OF_MEAN = 23;
    private static final int NUMBER_OF_VARIANCE = 37;

    public GeometryFeatures(int id) {
        this.id = id;
    }

    public void createGeometryFeatures(OSMWay wayNode) {
        String geometryType;
        switch (geometryType = wayNode.getGeometry().getGeometryType()) {
            case "LineString": {
                wayNode.getFeatureNodeList().add(new FeatureNode(this.id, 1.0));
                this.id += 4;
                break;
            }
            case "Polygon": {
                wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 1, 1.0));
                this.id += 4;
                break;
            }
            case "LinearRing": {
                wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 2, 1.0));
                this.id += 4;
                break;
            }
            case "Point": {
                wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 3, 1.0));
                this.id += 4;
            }
        }
        if (wayNode.getGeometry().isRectangle()) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id, 1.0));
        }
        ++this.id;
        int numberOfPoints = wayNode.getGeometry().getNumPoints();
        this.numberOfPointsFeature(numberOfPoints, wayNode);
        double area = wayNode.getGeometry().getArea();
        if (geometryType.equals("Polygon")) {
            this.areaFeature(area, wayNode);
        } else {
            this.id += 25;
        }
        if (this.geometryResemblesCircle(wayNode)) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id, 1.0));
        }
        ++this.id;
        Coordinate[] nodeGeometries = wayNode.getGeometry().getCoordinates();
        ArrayList<Double> edgeLengths = new ArrayList<Double>();
        if (!wayNode.getGeometry().getGeometryType().toUpperCase().equals("POINT")) {
            for (int i = 0; i < nodeGeometries.length - 1; ++i) {
                Coordinate[] nodePair = new Coordinate[]{nodeGeometries[i], nodeGeometries[i + 1]};
                LineString tempGeom = this.geometryFactory.createLineString(nodePair);
                edgeLengths.add(tempGeom.getLength());
            }
        } else {
            edgeLengths.add(0.0);
        }
        double edgeSum = 0.0;
        for (Double edge : edgeLengths) {
            edgeSum += edge.doubleValue();
        }
        double mean = edgeSum / (double)edgeLengths.size();
        this.handleMean(wayNode, mean);
        double sum = 0.0;
        for (Double edge : edgeLengths) {
            sum += (edge - mean) * (edge - mean);
        }
        double normalizedVariance = sum / (double)edgeLengths.size() / (mean * mean);
        this.handleVariance(wayNode, normalizedVariance);
        this.setLastID(this.id);
    }

    private void handleMean(OSMWay wayNode, double mean) {
        if (mean < 2.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id, 1.0));
            this.id += 23;
        } else if (mean < 4.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 1, 1.0));
            this.id += 23;
        } else if (mean < 6.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 2, 1.0));
            this.id += 23;
        } else if (mean < 8.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 3, 1.0));
            this.id += 23;
        } else if (mean < 10.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 4, 1.0));
            this.id += 23;
        } else if (mean < 12.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 5, 1.0));
            this.id += 23;
        } else if (mean < 14.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 6, 1.0));
            this.id += 23;
        } else if (mean < 16.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 7, 1.0));
            this.id += 23;
        } else if (mean < 18.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 8, 1.0));
            this.id += 23;
        } else if (mean < 20.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 9, 1.0));
            this.id += 23;
        } else if (mean < 25.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 10, 1.0));
            this.id += 23;
        } else if (mean < 30.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 11, 1.0));
            this.id += 23;
        } else if (mean < 35.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 12, 1.0));
            this.id += 23;
        } else if (mean < 40.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 13, 1.0));
            this.id += 23;
        } else if (mean < 45.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 14, 1.0));
            this.id += 23;
        } else if (mean < 50.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 15, 1.0));
            this.id += 23;
        } else if (mean < 60.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 16, 1.0));
            this.id += 23;
        } else if (mean < 70.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 17, 1.0));
            this.id += 23;
        } else if (mean < 80.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 18, 1.0));
            this.id += 23;
        } else if (mean < 90.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 19, 1.0));
            this.id += 23;
        } else if (mean < 100.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 20, 1.0));
            this.id += 23;
        } else if (mean < 200.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 21, 1.0));
            this.id += 23;
        } else {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 22, 1.0));
            this.id += 23;
        }
    }

    private void handleVariance(OSMWay wayNode, double normalizedVariance) {
        if (normalizedVariance == 0.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.005) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 1, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.01) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 2, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.02) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 3, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.03) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 4, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.04) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 5, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.05) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 6, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.06) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 7, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.07) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 8, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.08) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 9, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.09) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 10, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.1) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 11, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.12) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 12, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.14) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 13, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.16) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 14, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.18) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 15, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.2) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 16, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.22) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 17, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.24) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 18, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.26) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 19, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.28) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 20, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.3) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 21, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.32) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 22, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.34) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 23, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.36) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 24, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.38) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 25, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.4) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 26, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.42) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 27, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.44) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 28, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.46) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 29, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.48) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 30, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.5) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 31, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.6) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 32, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.7) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 33, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.8) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 34, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 0.9) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 35, 1.0));
            this.id += 37;
        } else if (normalizedVariance < 1.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 36, 1.0));
            this.id += 37;
        } else {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 37, 1.0));
            this.id += 37;
        }
    }

    private void numberOfPointsFeature(int numberOfPoints, OSMWay wayNode) {
        if (numberOfPoints < 10) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 20) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 1, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 30) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 2, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 40) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 3, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 50) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 4, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 75) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 5, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 100) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 6, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 150) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 7, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 200) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 8, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 300) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 9, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 500) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 10, 1.0));
            this.id += 13;
        } else if (numberOfPoints < 1000) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 11, 1.0));
            this.id += 13;
        } else {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 12, 1.0));
            this.id += 13;
        }
    }

    private void areaFeature(double area, OSMWay wayNode) {
        if (area < 50.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id, 1.0));
            this.id += 25;
        } else if (area < 100.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 1, 1.0));
            this.id += 25;
        } else if (area < 150.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 2, 1.0));
            this.id += 25;
        } else if (area < 200.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 3, 1.0));
            this.id += 25;
        } else if (area < 250.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 4, 1.0));
            this.id += 25;
        } else if (area < 300.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 5, 1.0));
            this.id += 25;
        } else if (area < 350.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 6, 1.0));
            this.id += 25;
        } else if (area < 400.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 7, 1.0));
            this.id += 25;
        } else if (area < 450.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 8, 1.0));
            this.id += 25;
        } else if (area < 500.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 9, 1.0));
            this.id += 25;
        } else if (area < 750.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 10, 1.0));
            this.id += 25;
        } else if (area < 1000.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 11, 1.0));
            this.id += 25;
        } else if (area < 1250.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 12, 1.0));
            this.id += 25;
        } else if (area < 1500.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 13, 1.0));
            this.id += 25;
        } else if (area < 1750.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 14, 1.0));
            this.id += 25;
        } else if (area < 2000.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 15, 1.0));
            this.id += 25;
        } else if (area < 2250.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 16, 1.0));
            this.id += 25;
        } else if (area < 2500.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 17, 1.0));
            this.id += 25;
        } else if (area < 2750.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 18, 1.0));
            this.id += 25;
        } else if (area < 3000.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 19, 1.0));
            this.id += 25;
        } else if (area < 3500.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 20, 1.0));
            this.id += 25;
        } else if (area < 4000.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 21, 1.0));
            this.id += 25;
        } else if (area < 5000.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 22, 1.0));
            this.id += 25;
        } else if (area < 10000.0) {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 23, 1.0));
            this.id += 25;
        } else {
            wayNode.getFeatureNodeList().add(new FeatureNode(this.id + 24, 1.0));
            this.id += 25;
        }
    }

    private boolean geometryResemblesCircle(OSMWay way) {
        Geometry wayGeometry = way.getGeometry();
        boolean isCircle = false;
        if (wayGeometry.getGeometryType().equals("Polygon") && wayGeometry.getNumPoints() >= 16) {
            List<Geometry> points = way.getNodeGeometries();
            Geometry firstPoint = points.get(0);
            double radius = firstPoint.distance((Geometry)wayGeometry.getCentroid());
            double radiusBufferSmaller = radius * 0.6;
            double radiusBufferGreater = radius * 1.4;
            isCircle = true;
            for (Geometry point : points) {
                double tempRadius = point.distance((Geometry)wayGeometry.getCentroid());
                boolean tempIsCircle = radiusBufferSmaller <= tempRadius && tempRadius <= radiusBufferGreater;
                isCircle = isCircle && tempIsCircle;
            }
            double ratio = wayGeometry.getLength() / wayGeometry.getArea();
            boolean tempIsCircle = ratio < 0.06;
            isCircle = isCircle && tempIsCircle;
        }
        return isCircle;
    }

    private void setLastID(int lastID) {
        this.id = lastID;
    }

    public int getLastID() {
        return this.id + 1;
    }
}

