/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.Color;
import java.awt.Stroke;
import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class FDSettings {
    public NamedColorProperty COLOR_FIXED = new NamedColorProperty("fastdraw.color.delete", Color.red);
    public NamedColorProperty COLOR_NORMAL = new NamedColorProperty("fastdraw.color.edit", Color.orange);
    public NamedColorProperty COLOR_DELETE = new NamedColorProperty("fastdraw.color.fixed", Color.green);
    public NamedColorProperty COLOR_SELECTEDFRAGMENT = new NamedColorProperty("fastdraw.color.normal", Color.red);
    public NamedColorProperty COLOR_EDITEDFRAGMENT = new NamedColorProperty("fastdraw.color.select", Color.blue);
    public NamedColorProperty COLOR_SIMPLIFIED = new NamedColorProperty("fastdraw.color.simplified", Color.orange);
    public double maxDist;
    public double epsilonMult;
    public double minPixelsBetweenPoints;
    public double startingEps;
    public double maxPointsPerKm;
    public int pkmBlockSize;
    public boolean drawLastSegment;
    public boolean snapNodes;
    public boolean fixedClick;
    public boolean fixedSpacebar;
    public boolean allowEditExistingWays;
    public boolean drawClosed;
    public int simplifyMode;
    public String autoTags;
    public Stroke normalStroke;
    public Stroke simplifiedStroke;
    public Stroke deleteStroke;
    public int dotSize;
    public int bigDotSize;

    public void loadPrefs() {
        this.normalStroke = GuiHelper.getCustomizedStroke((String)Main.pref.get("fastdraw.stroke.normal", "2"));
        this.deleteStroke = GuiHelper.getCustomizedStroke((String)Main.pref.get("fastdraw.stroke.delete", "3"));
        this.simplifiedStroke = GuiHelper.getCustomizedStroke((String)Main.pref.get("fastdraw.stroke.simplified", "2"));
        this.bigDotSize = Main.pref.getInt("fastdraw.point.bigsize", 7);
        this.dotSize = Main.pref.getInt("fastdraw.point.normalsize", 5);
        this.maxDist = Main.pref.getDouble("fastdraw.maxdist", 5.0);
        this.epsilonMult = Main.pref.getDouble("fastdraw.epsilonmult", 1.1);
        this.minPixelsBetweenPoints = Main.pref.getDouble("fastdraw.mindelta", 20.0);
        this.startingEps = Main.pref.getDouble("fastdraw.startingEps", 5.0);
        this.maxPointsPerKm = Main.pref.getDouble("fastdraw.maxpkm", 150.0);
        this.pkmBlockSize = Main.pref.getInt("fastdraw.pkmblocksize", 10);
        this.drawLastSegment = Main.pref.getBoolean("fastdraw.drawlastsegment", true);
        this.snapNodes = Main.pref.getBoolean("fastdraw.snapnodes", true);
        this.fixedClick = Main.pref.getBoolean("fastdraw.fixedclick", false);
        this.fixedSpacebar = Main.pref.getBoolean("fastdraw.fixedspacebar", false);
        this.drawClosed = Main.pref.getBoolean("fastdraw.drawclosed", false);
        this.simplifyMode = Main.pref.getInt("fastdraw.simplifymode", 0) % 3;
        this.allowEditExistingWays = Main.pref.getBoolean("fastdraw.alloweditexisting", false);
        this.autoTags = Main.pref.get("fastdraw.autotags");
    }

    public void savePrefs() {
        Main.pref.putDouble("fastdraw.maxdist", this.maxDist);
        Main.pref.putDouble("fastdraw.epsilonmult", this.epsilonMult);
        Main.pref.putDouble("fastdraw.mindelta", this.minPixelsBetweenPoints);
        Main.pref.putDouble("fastdraw.startingEps", this.startingEps);
        Main.pref.putDouble("fastdraw.maxpkm", this.maxPointsPerKm);
        Main.pref.putInt("fastdraw.pkmblocksize", this.pkmBlockSize);
        Main.pref.putBoolean("fastdraw.drawlastsegment", this.drawLastSegment);
        Main.pref.putBoolean("fastdraw.snapnodes", this.snapNodes);
        Main.pref.putBoolean("fastdraw.fixedclick", this.fixedClick);
        Main.pref.putBoolean("fastdraw.fixedspacebar", this.fixedSpacebar);
        Main.pref.putBoolean("fastdraw.drawclosed", this.drawClosed);
        Main.pref.putInt("fastdraw.simplifymode", this.simplifyMode);
        Main.pref.put("fastdraw.autotags", this.autoTags);
        Main.pref.putBoolean("fastdraw.alloweditexisting", this.allowEditExistingWays);
        try {
            Main.pref.save();
        }
        catch (IOException e) {
            Logging.error((String)I18n.tr((String)"Can not save preferences", (Object[])new Object[0]));
        }
    }
}

