/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.dialog;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.action.adapter.WindowClose;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteCancel;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteCommentBug;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.AbstractDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.tools.ImageProvider;

public class CommentBugDialog
extends AbstractDialog {
    private static final long serialVersionUID = 7788698281871951326L;
    private JLabel lblNickname;
    private JTextField txtNickname;
    private JLabel lblComment;
    private JScrollPane cmpComment;
    private JTextArea txtComment;
    private JButton btnCancel;
    private JButton btnOk;

    public CommentBugDialog(String title, String iconName, JToggleButton firedButton, MapdustPlugin mapdustPlugin) {
        if (firedButton != null) {
            this.setFiredButton(firedButton);
        }
        this.setTitle(title);
        this.setModal(true);
        Image image = ImageProvider.get((String)iconName).getImage();
        this.setIconImage(image);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setFont(new Font("Times New Roman", 1, 14));
        this.setBackground(this.getContentPane().getBackground());
        this.setResizable(false);
        this.setForeground(Color.black);
        this.setLayout(null);
        this.addComponents(mapdustPlugin);
        MapdustButtonPanel btnPanel = mapdustPlugin.getMapdustGUI().getPanel().getBtnPanel();
        this.addWindowListener(new WindowClose(this, btnPanel));
    }

    @Override
    public void addComponents(MapdustPlugin mapdustPlugin) {
        Rectangle bounds;
        Color backgroundColor = this.getContentPane().getBackground();
        Font font = new Font("Times New Roman", 1, 14);
        if (this.lblNickname == null) {
            bounds = new Rectangle(10, 10, 91, 25);
            this.lblNickname = ComponentUtil.createJLabel("Nickname", font, bounds, null);
        }
        if (this.txtNickname == null) {
            bounds = new Rectangle(100, 10, 250, 25);
            this.txtNickname = ComponentUtil.createJTextField(bounds);
            String nickname = Main.pref.get("mapdust.nickname");
            if (nickname.isEmpty()) {
                nickname = Main.pref.get("mapdust.josmUserName");
            }
            if (nickname != null && !nickname.isEmpty()) {
                this.txtNickname.setText(nickname);
            }
        }
        if (this.lblComment == null) {
            bounds = new Rectangle(10, 50, 79, 25);
            this.lblComment = ComponentUtil.createJLabel("Comment", font, bounds, null);
        }
        if (this.cmpComment == null) {
            bounds = new Rectangle(100, 50, 250, 80);
            this.txtComment = new JTextArea();
            this.txtComment.setFont(new Font("Times New Roman", 0, 12));
            this.txtComment.setLineWrap(true);
            this.cmpComment = ComponentUtil.createJScrollPane(this.txtComment, bounds, backgroundColor, false, true);
        }
        if (this.btnCancel == null) {
            bounds = new Rectangle(260, 140, 90, 25);
            ExecuteCancel cancelAction = new ExecuteCancel(this, mapdustPlugin.getMapdustGUI());
            this.btnCancel = ComponentUtil.createJButton("Cancel", bounds, cancelAction);
        }
        if (this.btnOk == null) {
            bounds = new Rectangle(190, 140, 60, 25);
            ExecuteCommentBug okAction = new ExecuteCommentBug(this, mapdustPlugin.getMapdustGUI());
            okAction.addObserver(mapdustPlugin);
            okAction.addObserver(mapdustPlugin.getMapdustGUI());
            this.btnOk = ComponentUtil.createJButton("OK", bounds, okAction);
        }
        this.add(this.lblNickname);
        this.add(this.txtNickname);
        this.add(this.lblComment);
        this.add(this.cmpComment);
        this.add(this.btnCancel);
        this.add(this.btnOk);
        this.setSize(360, 170);
    }

    public JLabel getLblNickname() {
        return this.lblNickname;
    }

    public JTextField getTxtNickname() {
        return this.txtNickname;
    }

    public JLabel getLblComment() {
        return this.lblComment;
    }

    public JScrollPane getCmpComment() {
        return this.cmpComment;
    }

    public JTextArea getTxtComment() {
        return this.txtComment;
    }

    public JButton getBtnCancel() {
        return this.btnCancel;
    }

    public JButton getBtnOk() {
        return this.btnOk;
    }
}

