/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.directdownload;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.directdownload.UserTrack;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UserTrackReader
extends OsmConnection {
    public List<UserTrack> getTrackList() {
        String urlString = OsmApi.getOsmApi().getBaseUrl() + "user/gpx_files";
        try {
            HttpClient client = HttpClient.create((URL)new URL(urlString));
            this.addAuth(client);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            TrackListHandler handler = new TrackListHandler();
            SAXParser sp = spf.newSAXParser();
            try (InputStream in = client.connect().getContent();){
                sp.parse(in, (DefaultHandler)handler);
            }
            return handler.getResult();
        }
        catch (MalformedURLException e) {
            Logging.error((Throwable)e);
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Invalid URL {0}", (Object[])new Object[]{urlString}));
        }
        catch (IOException | OsmTransferException e) {
            Logging.error((Throwable)e);
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Error fetching URL {0}", (Object[])new Object[]{urlString}));
        }
        catch (ParserConfigurationException | SAXException e) {
            Logging.error((Throwable)e);
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Error parsing data from URL {0}", (Object[])new Object[]{urlString}));
        }
        return new LinkedList<UserTrack>();
    }

    private static class TrackListHandler
    extends DefaultHandler {
        private LinkedList<UserTrack> data = new LinkedList();
        private String cdata = "";

        private TrackListHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("gpx_file")) {
                UserTrack track = new UserTrack();
                track.id = atts.getValue("id");
                track.filename = atts.getValue("name");
                track.datetime = atts.getValue("timestamp").replaceAll("[TZ]", " ");
                this.data.addFirst(track);
            }
            this.cdata = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.cdata = this.cdata + new String(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("description")) {
                this.data.getFirst().description = this.cdata;
            }
        }

        public List<UserTrack> getResult() {
            return this.data;
        }
    }
}

