/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.videomapping.video;

import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.videomapping.VideoPositionLayer;
import org.openstreetmap.josm.plugins.videomapping.video.Video;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;

public class GPSVideo
extends Video {
    private static final String SYNC_KEY = "synced";
    public JComponent SyncComponent;
    private WayPoint syncWayPoint;
    private long syncVideoTime;
    private Date start;
    private Date end;
    public WayPoint firstWayPoint;
    public WayPoint lastWayPoint;
    private VideoPositionLayer videoPositionLayer;

    public GPSVideo(File filename, String id, MediaPlayerFactory mediaPlayerFactory) {
        super(filename, id, mediaPlayerFactory);
    }

    public GPSVideo(Video video) {
        super(video.filename, video.id, video.mediaPlayerFactory);
        this.player = video.player;
    }

    public void doSync(VideoPositionLayer layer) {
        this.videoPositionLayer = layer;
        if (this.isSynced()) {
            this.removeSyncedWayPoints();
        }
        this.syncWayPoint = layer.getCurrentWayPoint();
        this.syncVideoTime = this.getCurrentTime();
        if (this.syncWayPoint != null) {
            this.start = new Date(this.syncWayPoint.getTime().getTime() - this.syncVideoTime);
            this.end = new Date(this.start.getTime() + this.player.getLength());
        } else {
            this.start = null;
            this.end = null;
        }
        this.firstWayPoint = this.getFirstGPS();
        this.lastWayPoint = this.getLastGPS();
        this.markSyncedWayPoints();
        MainApplication.getMap().mapView.repaint();
    }

    private WayPoint getFirstGPS() {
        if (this.start == null || this.start.before(this.videoPositionLayer.getFirstWayPoint().getTime())) {
            return this.videoPositionLayer.getFirstWayPoint();
        }
        return this.videoPositionLayer.getWayPointBefore(this.start);
    }

    private WayPoint getLastGPS() {
        if (this.end == null || this.end.after(this.videoPositionLayer.getLastWayPoint().getTime())) {
            return this.videoPositionLayer.getLastWayPoint();
        }
        return this.videoPositionLayer.getWayPointBefore(this.end);
    }

    private void removeSyncedWayPoints() {
        List<WayPoint> track = this.videoPositionLayer.getTrack();
        int start = track.indexOf(this.firstWayPoint);
        int end = track.indexOf(this.lastWayPoint);
        if (0 <= start && start <= end && end < track.size()) {
            for (WayPoint n : track.subList(start, end)) {
                n.attr.keySet().remove(SYNC_KEY);
            }
        }
    }

    private void markSyncedWayPoints() {
        List<WayPoint> track = this.videoPositionLayer.getTrack();
        int start = track.indexOf(this.firstWayPoint);
        int end = track.indexOf(this.lastWayPoint);
        if (0 <= start && start <= end && end < track.size()) {
            for (WayPoint n : track.subList(start, end)) {
                n.attr.put(SYNC_KEY, this.id);
            }
        }
    }

    public boolean isSynced() {
        return this.syncWayPoint != null;
    }

    public void jumpTo(Date GPSTime) {
        if (GPSTime.after(this.firstWayPoint.getTime()) & GPSTime.before(this.lastWayPoint.getTime())) {
            long diff = GPSTime.getTime() - this.start.getTime();
            this.player.setTime(diff);
            System.out.println(diff);
        }
    }

    public WayPoint getCurrentWayPoint() {
        if (this.isSynced()) {
            long videotime = this.player.getTime();
            Date gpstime = new Date(this.start.getTime() + videotime);
            return this.videoPositionLayer.interpolate(gpstime);
        }
        return null;
    }
}

