/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix.controller;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.Collator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.openstreetmap.josm.plugins.tofix.bean.ListProjectBean;
import org.openstreetmap.josm.plugins.tofix.bean.ProjectBean;
import org.openstreetmap.josm.plugins.tofix.util.Config;
import org.openstreetmap.josm.plugins.tofix.util.Request;

public class ListProjectsController {
    private final ListProjectBean listProjectsBean = new ListProjectBean();

    public String getUrl() {
        return Config.getHOST() + "/" + "v1" + "/projects";
    }

    public ListProjectBean getListProjects() {
        LinkedList<ProjectBean> projects = new LinkedList<ProjectBean>();
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(Request.sendGET(this.getUrl())));){
            JsonArray jsonArray = jsonReader.readArray();
            for (JsonValue value : jsonArray) {
                ProjectBean projectBean = new ProjectBean();
                try (JsonReader jsonReader2 = Json.createReader((Reader)new StringReader(value.toString()));){
                    JsonObject jsonProject = jsonReader2.readObject();
                    projectBean.setId(jsonProject.getString("id"));
                    projectBean.setName(jsonProject.getString("name"));
                    projectBean.setMetadata(jsonProject.getJsonObject("metadata"));
                }
                projects.add(projectBean);
            }
        }
        catch (IOException | NullPointerException | JsonParsingException ex) {
            Logger.getLogger(ListProjectsController.class.getName()).log(Level.SEVERE, null, ex);
        }
        Collections.sort(projects, (o1, o2) -> Collator.getInstance().compare(o1.getName(), o2.getName()));
        this.listProjectsBean.setProjects(projects);
        return this.listProjectsBean;
    }
}

