/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;

public class BicycleFootRouteValidatorTest
extends Test {
    public static final int ERROR_CODE_CONTINUITY = 3701;

    public BicycleFootRouteValidatorTest() {
        super(I18n.tr((String)"Bicycle and foot routes Tests", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        if (r.hasIncompleteMembers()) {
            return;
        }
        if (!(RouteUtils.isBicycleRoute(r) || RouteUtils.isFootRoute(r) || RouteUtils.isHorseRoute(r))) {
            return;
        }
        ArrayList<RelationMember> members = new ArrayList<RelationMember>(r.getMembers());
        members.removeIf(m -> !m.isWay());
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(members);
        for (Integer i : this.getGaps(links)) {
            TestError.Builder builder = TestError.builder((Test)this, (Severity)Severity.WARNING, (int)3701);
            builder.message(I18n.tr((String)("PT: There is a gap in the " + r.get("route") + " route"), (Object[])new Object[0]));
            builder.primitives(new OsmPrimitive[]{((RelationMember)members.get(i)).getWay(), ((RelationMember)members.get(i + 1)).getWay(), r});
            this.errors.add(builder.build());
        }
    }

    private List<Integer> getGaps(List<WayConnectionType> links) {
        ArrayList<Integer> gaps = new ArrayList<Integer>();
        int i = 0;
        while (i < links.size() - 1) {
            if (!links.get((int)i).linkNext) {
                gaps.add(i);
            }
            ++i;
        }
        return gaps;
    }
}

