/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.pt_assistant.PTAssistantPlugin;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayerManager;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantPaintVisitor;
import org.openstreetmap.josm.tools.ImageProvider;

public final class PTAssistantLayer
extends Layer
implements LayerManager.LayerChangeListener {
    private List<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>();
    private PTAssistantPaintVisitor paintVisitor;
    private HashMap<Character, List<PTWay>> fixVariants = new HashMap();
    private HashMap<Way, List<Character>> wayColoring = new HashMap();

    public PTAssistantLayer() {
        super("pt_assistant layer");
        MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        MainApplication.getLayerManager().addLayer((Layer)this);
    }

    public void addPrimitive(OsmPrimitive primitive) {
        this.primitives.add(primitive);
    }

    public void clear() {
        this.primitives.clear();
    }

    public void clearFixVariants() {
        this.fixVariants.clear();
        this.wayColoring.clear();
        MainApplication.getMap().mapView.repaint();
    }

    public void addFixVariants(List<List<PTWay>> fixVariants) {
        HashMap<List<PTWay>, Character> fixVariantLetterMap = new HashMap<List<PTWay>, Character>();
        char alphabet = 'A';
        int i = 0;
        while (i < 5 && i < fixVariants.size()) {
            List<PTWay> fixVariant = fixVariants.get(i);
            this.fixVariants.put(Character.valueOf(alphabet), fixVariant);
            fixVariantLetterMap.put(fixVariant, Character.valueOf(alphabet));
            alphabet = (char)(alphabet + '\u0001');
            ++i;
        }
        for (Map.Entry<Character, List<PTWay>> entry : this.fixVariants.entrySet()) {
            Character currentFixVariantLetter = entry.getKey();
            List<PTWay> fixVariant = entry.getValue();
            for (PTWay ptway : fixVariant) {
                for (Way way : ptway.getWays()) {
                    if (this.wayColoring.containsKey(way)) {
                        if (this.wayColoring.get(way).contains(currentFixVariantLetter)) continue;
                        this.wayColoring.get(way).add(currentFixVariantLetter);
                        continue;
                    }
                    ArrayList<Character> letterList = new ArrayList<Character>();
                    letterList.add(currentFixVariantLetter);
                    this.wayColoring.put(way, letterList);
                }
            }
        }
    }

    public List<PTWay> getFixVariant(char c) {
        return this.fixVariants.get(Character.valueOf(Character.toUpperCase(c)));
    }

    public void setPrimitives(List<OsmPrimitive> newPrimitives) {
        this.primitives = new ArrayList<OsmPrimitive>(newPrimitives);
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        this.paintVisitor = new PTAssistantPaintVisitor(g, mv);
        for (OsmPrimitive primitive : this.primitives) {
            this.paintVisitor.visit(primitive);
        }
        this.paintVisitor.visitFixVariants(this.fixVariants, this.wayColoring);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"osmdata_small");
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        return "pt_assistant layer";
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    public LayerPositionStrategy getDefaultLayerPosition() {
        return LayerPositionStrategy.IN_FRONT;
    }

    public void repaint(Relation relation) {
        this.primitives.clear();
        this.primitives.add((OsmPrimitive)relation);
        if (!MainApplication.getLayerManager().containsLayer((Layer)this)) {
            MainApplication.getLayerManager().addLayer((Layer)this);
        }
        if (this.paintVisitor == null) {
            MapView mv = MainApplication.getMap().mapView;
            this.paintVisitor = new PTAssistantPaintVisitor(mv.getGraphics(), mv);
        }
        for (OsmPrimitive primitive : this.primitives) {
            this.paintVisitor.visit(primitive);
        }
        this.paintVisitor.visitFixVariants(this.fixVariants, this.wayColoring);
        MainApplication.getMap().mapView.repaint();
    }

    public void layerAdded(LayerManager.LayerAddEvent arg0) {
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent arg0) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent event) {
        if (event.getRemovedLayer() instanceof OsmDataLayer) {
            this.primitives.clear();
            this.fixVariants.clear();
            this.wayColoring.clear();
            MainApplication.getMap().mapView.repaint();
        }
        if (event.getRemovedLayer() instanceof OsmDataLayer && event.getSource().getLayersOfType(OsmDataLayer.class).isEmpty()) {
            event.scheduleRemoval(Collections.singleton(this));
        }
        if (event.getRemovedLayer() == this) {
            PTAssistantLayerManager.PTLM.resetLayer();
            PTAssistantPlugin.clearHighlightedRelations();
        }
    }

    public synchronized void destroy() {
        MainApplication.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
        super.destroy();
    }
}

