/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;

public class PTRouteSegment {
    private PTStop firstStop;
    private PTStop lastStop;
    private List<PTWay> ptways;
    private List<List<PTWay>> fixVariants;
    private Relation relation;

    public PTRouteSegment(PTStop firstStop, PTStop lastStop, List<PTWay> ways, Relation relation) {
        this.firstStop = firstStop;
        this.lastStop = lastStop;
        this.ptways = new ArrayList<PTWay>(ways.size());
        this.ptways.addAll(ways);
        this.fixVariants = new ArrayList<List<PTWay>>();
        this.relation = relation;
    }

    public List<PTWay> getPTWays() {
        return this.ptways;
    }

    public void setPTWays(List<PTWay> ptwayList) {
        this.ptways = ptwayList;
        this.fixVariants.clear();
    }

    public PTStop getFirstStop() {
        return this.firstStop;
    }

    public PTStop getLastStop() {
        return this.lastStop;
    }

    public PTWay getFirstPTWay() {
        if (this.ptways.isEmpty()) {
            return null;
        }
        return this.ptways.get(0);
    }

    public PTWay getLastPTWay() {
        if (this.ptways.isEmpty()) {
            return null;
        }
        return this.ptways.get(this.ptways.size() - 1);
    }

    public Way getFirstWay() {
        if (this.ptways.isEmpty()) {
            return null;
        }
        return this.ptways.get(0).getWays().get(0);
    }

    public Way getLastWay() {
        if (this.ptways.isEmpty()) {
            return null;
        }
        List<Way> waysOfLast = this.ptways.get(this.ptways.size() - 1).getWays();
        return waysOfLast.get(waysOfLast.size() - 1);
    }

    public synchronized void addFixVariant(List<PTWay> list) {
        ArrayList<Way> otherWays = new ArrayList<Way>();
        for (PTWay pTWay : list) {
            otherWays.addAll(pTWay.getWays());
        }
        for (List list2 : this.fixVariants) {
            boolean listsEqual;
            ArrayList<Way> thisWays = new ArrayList<Way>();
            for (PTWay ptway : list2) {
                thisWays.addAll(ptway.getWays());
            }
            boolean bl = listsEqual = thisWays.size() == otherWays.size();
            if (listsEqual) {
                int i = 0;
                while (i < thisWays.size()) {
                    if (((Way)thisWays.get(i)).getUniqueId() != ((Way)otherWays.get(i)).getUniqueId()) {
                        listsEqual = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!listsEqual) continue;
            return;
        }
        this.fixVariants.add(list);
    }

    public List<List<PTWay>> getFixVariants() {
        return this.fixVariants;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public boolean equalsRouteSegment(PTRouteSegment other) {
        ArrayList<Way> thisWays = new ArrayList<Way>();
        for (PTWay ptway : this.ptways) {
            thisWays.addAll(ptway.getWays());
        }
        ArrayList<Way> otherWays = new ArrayList<Way>();
        for (PTWay ptway : other.getPTWays()) {
            otherWays.addAll(ptway.getWays());
        }
        if (thisWays.size() != otherWays.size()) {
            return false;
        }
        int i = 0;
        while (i < thisWays.size()) {
            if (((Way)thisWays.get(i)).getUniqueId() != ((Way)otherWays.get(i)).getUniqueId()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

