/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public class PTRouteDataManager {
    Relation relation;
    private List<PTStop> ptStops = new ArrayList<PTStop>();
    private List<PTWay> ptWays = new ArrayList<PTWay>();
    private Set<RelationMember> failedMembers = new HashSet<RelationMember>();

    public PTRouteDataManager(Relation relation) {
        this.relation = relation;
        PTStop prev = null;
        for (RelationMember member : this.relation.getMembers()) {
            if (PTStop.isPTStop(member)) {
                boolean stopExists = false;
                if (prev != null) {
                    if (prev.getName() == null || prev.getName().equals("") || member.getMember().get("name") == null || member.getMember().get("name").equals("")) {
                        if (this.calculateDistanceSq(member, prev) < 1.0E-6) {
                            stopExists = true;
                        }
                    } else if (prev.getName().equalsIgnoreCase(member.getMember().get("name"))) {
                        stopExists = true;
                    }
                }
                if (stopExists) {
                    prev.addStopElement(member);
                    continue;
                }
                try {
                    PTStop ptstop = new PTStop(member);
                    this.ptStops.add(ptstop);
                    prev = ptstop;
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getMessage().equals("The RelationMember type does not match its role " + member.getMember().getName())) {
                        if (this.failedMembers.contains(member)) continue;
                        this.failedMembers.add(member);
                        continue;
                    }
                    throw ex;
                }
            }
            if (RouteUtils.isPTWay(member)) {
                PTWay ptway = new PTWay(member);
                this.ptWays.add(ptway);
                continue;
            }
            if (this.failedMembers.contains(member)) continue;
            this.failedMembers.add(member);
        }
    }

    private double calculateDistanceSq(RelationMember member1, RelationMember member2) {
        LatLon coord1 = member1.getMember().getBBox().getCenter();
        LatLon coord2 = member2.getMember().getBBox().getCenter();
        return coord1.distanceSq(coord2);
    }

    public PTWay getPTWay(Way inputWay) {
        for (PTWay curr : this.ptWays) {
            if (curr.isWay() && curr.getWays().get(0) == inputWay) {
                return curr;
            }
            if (!curr.isRelation()) continue;
            for (RelationMember rm : curr.getRelation().getMembers()) {
                Way wayInNestedRelation = rm.getWay();
                if (wayInNestedRelation != inputWay) continue;
                return curr;
            }
        }
        return null;
    }

    public List<PTStop> getPTStops() {
        return this.ptStops;
    }

    public List<PTWay> getPTWays() {
        return this.ptWays;
    }

    public int getPTStopCount() {
        return this.ptStops.size();
    }

    public int getPTWayCount() {
        return this.ptWays.size();
    }

    public PTStop getFirstStop() {
        if (this.ptStops.isEmpty()) {
            return null;
        }
        return this.ptStops.get(0);
    }

    public PTStop getLastStop() {
        if (this.ptStops.isEmpty()) {
            return null;
        }
        return this.ptStops.get(this.ptStops.size() - 1);
    }

    public Set<RelationMember> getFailedMembers() {
        return this.failedMembers;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public PTStop getPTStop(long id) {
        for (PTStop stop : this.ptStops) {
            if (stop.getStopPosition() != null && stop.getStopPosition().getId() == id) {
                return stop;
            }
            if (stop.getPlatform() == null || stop.getPlatform().getId() != id) continue;
            return stop;
        }
        return null;
    }

    public PTWay getPTWay(long id) {
        for (PTWay ptway : this.ptWays) {
            for (Way way : ptway.getWays()) {
                if (way.getId() != id) continue;
                return ptway;
            }
        }
        return null;
    }

    public List<PTWay> findPTWaysThatContain(Way way) {
        ArrayList<PTWay> ptwaysThatContain = new ArrayList<PTWay>();
        for (PTWay ptway : this.ptWays) {
            if (!ptway.getWays().contains(way)) continue;
            ptwaysThatContain.add(ptway);
        }
        return ptwaysThatContain;
    }

    public List<PTWay> findPTWaysThatContainAsEndNode(Node node) {
        ArrayList<PTWay> ptwaysThatContain = new ArrayList<PTWay>();
        for (PTWay ptway : this.ptWays) {
            List<Way> ways = ptway.getWays();
            if (ways.get(0).firstNode() != node && ways.get(0).lastNode() != node && ways.get(ways.size() - 1).firstNode() != node && ways.get(ways.size() - 1).lastNode() != node) continue;
            ptwaysThatContain.add(ptway);
        }
        return ptwaysThatContain;
    }

    public boolean isDeadendNode(Node node) {
        List<PTWay> referringPtways = this.findPTWaysThatContainAsEndNode(node);
        return referringPtways.size() <= 1;
    }

    public PTWay getNextPTWay(PTWay ptway) {
        int i = 0;
        while (i < this.ptWays.size() - 1) {
            if (this.ptWays.get(i) == ptway) {
                return this.ptWays.get(i + 1);
            }
            ++i;
        }
        return null;
    }

    public PTWay getPreviousPTWay(PTWay ptway) {
        int i = 1;
        while (i < this.ptWays.size()) {
            if (this.ptWays.get(i) == ptway) {
                return this.ptWays.get(i - 1);
            }
            ++i;
        }
        return null;
    }

    public List<PTWay> getPTWaysBetween(Way start, Way end) {
        ArrayList<Integer> potentialStartIndices = new ArrayList<Integer>();
        ArrayList<Integer> potentialEndIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < this.ptWays.size()) {
            if (this.ptWays.get(i).getWays().contains(start)) {
                potentialStartIndices.add(i);
            }
            if (this.ptWays.get(i).getWays().contains(end)) {
                potentialEndIndices.add(i);
            }
            ++i;
        }
        ArrayList<int[]> pairList = new ArrayList<int[]>();
        for (Integer potentialStartIndex : potentialStartIndices) {
            for (Integer potentialEndIndex : potentialEndIndices) {
                if (potentialStartIndex > potentialEndIndex) continue;
                int[] pair = new int[]{potentialStartIndex, potentialEndIndex};
                pairList.add(pair);
            }
        }
        int minDifference = Integer.MAX_VALUE;
        int[] mostSuitablePair = new int[2];
        for (int[] pair : pairList) {
            int diff = pair[1] - pair[0];
            if (diff >= minDifference) continue;
            minDifference = diff;
            mostSuitablePair = pair;
        }
        ArrayList<PTWay> result = new ArrayList<PTWay>();
        int i2 = mostSuitablePair[0];
        while (i2 <= mostSuitablePair[1]) {
            result.add(this.ptWays.get(i2));
            ++i2;
        }
        return result;
    }

    public Node getCommonNode(PTWay way1, PTWay way2) {
        List<Way> wayList1 = way1.getWays();
        List<Way> wayList2 = way2.getWays();
        HashSet nodeSet1 = new HashSet();
        for (Way w : wayList1) {
            nodeSet1.addAll(w.getNodes());
        }
        HashSet nodeSet2 = new HashSet();
        for (Way w : wayList2) {
            nodeSet2.addAll(w.getNodes());
        }
        for (Node n : nodeSet1) {
            if (!nodeSet2.contains(n)) continue;
            return n;
        }
        return null;
    }

    public Way getFirstWay() {
        if (this.ptWays.isEmpty()) {
            return null;
        }
        PTWay lastPTWay = this.ptWays.get(0);
        if (lastPTWay == null || lastPTWay.getWays().isEmpty()) {
            return null;
        }
        return lastPTWay.getWays().get(0);
    }

    public Way getLastWay() {
        if (this.ptWays.isEmpty()) {
            return null;
        }
        PTWay lastPTWay = this.ptWays.get(this.ptWays.size() - 1);
        if (lastPTWay == null || lastPTWay.getWays().isEmpty()) {
            return null;
        }
        return lastPTWay.getWays().get(lastPTWay.getWays().size() - 1);
    }
}

