/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AlignInCircleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class SplitRoundaboutAction
extends JosmAction {
    private static final String ACTION_NAME = "Split Roundabout";
    private static final long serialVersionUID = 8912249304286025356L;

    public SplitRoundaboutAction() {
        super(ACTION_NAME, "icons/splitroundabout", ACTION_NAME, null, true);
    }

    public void actionPerformed(ActionEvent e) {
        Way roundabout = (Way)this.getLayerManager().getEditDataSet().getSelected().iterator().next();
        DownloadOsmTask task = new DownloadOsmTask();
        task.setZoomAfterDownload(true);
        BBox rbbox = roundabout.getBBox();
        double latOffset = (rbbox.getTopLeftLat() - rbbox.getBottomRightLat()) / 10.0;
        double lonOffset = (rbbox.getBottomRightLon() - rbbox.getTopLeftLon()) / 10.0;
        Bounds area = new Bounds(rbbox.getBottomRightLat() - latOffset, rbbox.getTopLeftLon() - lonOffset, rbbox.getTopLeftLat() + latOffset, rbbox.getBottomRightLon() + lonOffset);
        Future future = task.download(false, area, null);
        MainApplication.worker.submit(() -> {
            try {
                future.get();
                this.downloadIncompleteRelations(roundabout);
            }
            catch (InterruptedException | ExecutionException e1) {
                Logging.error((Throwable)e1);
                return;
            }
        });
    }

    private void continueAfterDownload(Way roundabout) {
        if (Main.pref.getBoolean("pt_assistant.roundabout-splitter.alignalways") || JOptionPane.showOptionDialog(Main.parent, I18n.tr((String)"Do you want to make the roundabout round?", (Object[])new Object[0]), I18n.tr((String)"Roundabout round", (Object[])new Object[0]), 0, 3, null, null, null) == 0) {
            new AlignInCircleAction().actionPerformed(null);
        }
        Map<Relation, List<Integer>> savedPositions = this.getSavedPositions(roundabout);
        MainApplication.undoRedo.add(this.getRemoveRoundaboutFromRelationsCommand(roundabout));
        List<Node> splitNodes = this.getSplitNodes(roundabout);
        SplitWayCommand result = SplitWayCommand.split((Way)roundabout, splitNodes, Collections.emptyList());
        MainApplication.undoRedo.add((Command)result);
        List splitWays = result.getNewWays();
        splitWays.add(result.getOriginalWay());
        MainApplication.undoRedo.add(this.getUpdateRelationsCommand(savedPositions, splitNodes, splitWays));
    }

    private void downloadIncompleteRelations(Way roundabout) {
        List<Relation> parents = this.getPTRouteParents(roundabout);
        parents.removeIf(r -> !r.hasIncompleteMembers());
        if (parents.isEmpty()) {
            this.continueAfterDownload(roundabout);
            return;
        }
        Future<?> future = MainApplication.worker.submit((Runnable)new DownloadRelationMemberTask(parents, (Collection)DownloadSelectedIncompleteMembersAction.buildSetOfIncompleteMembers(parents), MainApplication.getLayerManager().getEditLayer()));
        MainApplication.worker.submit(() -> {
            try {
                future.get();
                this.continueAfterDownload(roundabout);
            }
            catch (InterruptedException | ExecutionException e1) {
                Logging.error((Throwable)e1);
                return;
            }
        });
    }

    public Command getUpdateRelationsCommand(Map<Relation, List<Integer>> savedPositions, List<Node> splitNodes, Collection<Way> splitWays) {
        Map<Relation, Relation> changingRelations = this.updateRelations(savedPositions, splitNodes, splitWays);
        ArrayList commands = new ArrayList();
        changingRelations.forEach((oldR, newR) -> {
            boolean bl = commands.add(new ChangeCommand((OsmPrimitive)oldR, (OsmPrimitive)newR));
        });
        return new SequenceCommand("Updating Relations for SplitRoundabout", commands);
    }

    private Map<Relation, Relation> updateRelations(Map<Relation, List<Integer>> savedPositions, List<Node> splitNodes, Collection<Way> splitWays) {
        HashMap<Relation, Relation> changingRelation = new HashMap<Relation, Relation>();
        HashMap memberOffset = new HashMap();
        savedPositions.forEach((r, positions) -> positions.forEach(i -> {
            if (!changingRelation.containsKey(r)) {
                changingRelation.put((Relation)r, new Relation(r));
            }
            Relation c = (Relation)changingRelation.get(r);
            if (!memberOffset.containsKey(r)) {
                memberOffset.put(r, 0);
            }
            int offset = (Integer)memberOffset.get(r);
            Pair<Way, Way> entryExitWays = this.getEntryExitWays(c, i + offset);
            Way entryWay = (Way)entryExitWays.a;
            Way exitWay = (Way)entryExitWays.b;
            if (entryWay == null || exitWay == null) {
                return;
            }
            Node entryNode = this.getNodeInCommon(splitNodes, entryWay);
            Node exitNode = this.getNodeInCommon(splitNodes, exitWay);
            if (entryNode == null || exitNode == null) {
                return;
            }
            if (this.needSwap(entryNode, entryWay, exitNode, exitWay)) {
                Node temp = entryNode;
                entryNode = exitNode;
                exitNode = temp;
            }
            List parents = this.filterParents(entryNode.getParentWays(), entryWay, entryNode);
            Way curr = parents.get(0);
            while (!curr.lastNode().equals((Object)exitNode)) {
                c.addMember(i + offset++, new RelationMember(null, (OsmPrimitive)curr));
                parents = curr.lastNode().getParentWays();
                parents.remove(curr);
                parents.removeIf(w -> !splitWays.contains(w));
                curr = (Way)parents.get(0);
            }
            c.addMember(i + offset++, new RelationMember(null, (OsmPrimitive)curr));
            memberOffset.put(r, offset);
        }));
        return changingRelation;
    }

    private List<Way> filterParents(List<Way> parentWays, Way entryWay, Node entryNode) {
        ArrayList<Way> ret = new ArrayList<Way>();
        for (Way w : parentWays) {
            if (w.equals((Object)entryWay) || !w.firstNode().equals((Object)entryNode)) continue;
            ret.add(w);
        }
        return ret;
    }

    private boolean needSwap(Node entryNode, Way entryWay, Node exitNode, Way exitWay) {
        boolean entryReversed = false;
        boolean exitReversed = false;
        if (entryWay.firstNode().equals((Object)entryNode) && !entryWay.hasTag("oneway", "-1")) {
            entryReversed = true;
        }
        if (exitWay.lastNode().equals((Object)exitNode) && !exitWay.hasTag("oneway", "-1")) {
            exitReversed = true;
        }
        return entryReversed && exitReversed;
    }

    private Node getNodeInCommon(List<Node> nodes, Way way) {
        if (nodes.contains(way.lastNode())) {
            return way.lastNode();
        }
        if (nodes.contains(way.firstNode())) {
            return way.firstNode();
        }
        return null;
    }

    private Pair<Way, Way> getEntryExitWays(Relation r, Integer position) {
        RelationMember after;
        Pair ret = new Pair(null, null);
        RelationMember before = r.getMember(position - 1);
        if (before.isWay()) {
            ret.a = before.getWay();
        }
        if ((after = r.getMember(position.intValue())).isWay()) {
            ret.b = after.getWay();
        }
        return ret;
    }

    public List<Node> getSplitNodes(Way roundabout) {
        HashSet noDuplicateSplitNodes = new HashSet(roundabout.getNodes());
        ArrayList<Node> splitNodes = new ArrayList<Node>(noDuplicateSplitNodes);
        splitNodes.removeIf(n -> {
            List parents = n.getParentWays();
            if (parents.size() == 1) {
                return true;
            }
            parents.remove(roundabout);
            for (Way parent : parents) {
                if (this.getRouteParents(parent).isEmpty()) continue;
                return false;
            }
            return true;
        });
        return splitNodes;
    }

    public Command getRemoveRoundaboutFromRelationsCommand(Way roundabout) {
        ArrayList commands = new ArrayList();
        this.getPTRouteParents(roundabout).forEach(r -> {
            Relation c = new Relation(r);
            c.removeMembersFor((OsmPrimitive)roundabout);
            commands.add(new ChangeCommand((OsmPrimitive)r, (OsmPrimitive)c));
        });
        return new SequenceCommand("Remove roundabout from relations", commands);
    }

    public Map<Relation, List<Integer>> getSavedPositions(Way roundabout) {
        HashMap<Relation, List<Integer>> savedPositions = new HashMap<Relation, List<Integer>>();
        for (Relation curr : this.getPTRouteParents(roundabout)) {
            int j = 0;
            while (j < curr.getMembersCount()) {
                if (curr.getMember(j).getUniqueId() == roundabout.getUniqueId()) {
                    if (!savedPositions.containsKey(curr)) {
                        savedPositions.put(curr, new ArrayList());
                    }
                    List positions = (List)savedPositions.get(curr);
                    positions.add(j - positions.size());
                }
                ++j;
            }
        }
        return savedPositions;
    }

    private List<Relation> getPTRouteParents(Way roundabout) {
        List referrers = OsmPrimitive.getFilteredList((Collection)roundabout.getReferrers(), Relation.class);
        referrers.removeIf(r -> !RouteUtils.isPTRoute(r));
        return referrers;
    }

    private List<Relation> getRouteParents(Way roundabout) {
        List referrers = OsmPrimitive.getFilteredList((Collection)roundabout.getReferrers(), Relation.class);
        referrers.removeIf(r -> !RouteUtils.isRoute(r));
        return referrers;
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(false);
        if (selection == null || selection.size() != 1) {
            return;
        }
        OsmPrimitive selected = selection.iterator().next();
        if (selected.getType() != OsmPrimitiveType.WAY) {
            return;
        }
        if (((Way)selected).isClosed() && (selected.hasTag("junction", "roundabout") || selected.hasTag("oneway", "yes"))) {
            this.setEnabled(true);
            return;
        }
    }
}

