/*
 * Decompiled with CFR 0.152.
 */
package wmsturbochallenge;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapView;

class FakeMapView
extends MapView {
    public ProjectionBounds view_bounds;
    public MapView parent;
    public Graphics2D graphics;
    public BufferedImage ground_image;
    public int ground_width = -1;
    public int ground_height = -1;
    public double scale;
    public double max_east_west;

    FakeMapView(MapView parent, double scale) {
        super(null, null);
        this.parent = parent;
        this.scale = scale;
        ProjectionBounds parent_bounds = parent.getProjectionBounds();
        this.max_east_west = parent_bounds.maxEast - parent_bounds.minEast;
    }

    public void setProjectionBounds(ProjectionBounds bounds) {
        this.view_bounds = bounds;
        if (bounds.maxEast - bounds.minEast > this.max_east_west) {
            this.max_east_west = bounds.maxEast - bounds.minEast;
            EastNorth parent_center = this.parent.getCenter();
            this.parent.zoomTo(new ProjectionBounds(new EastNorth(parent_center.east() - this.max_east_west / 2.0, parent_center.north()), new EastNorth(parent_center.east() + this.max_east_west / 2.0, parent_center.north())));
            ProjectionBounds new_bounds = this.parent.getProjectionBounds();
            this.max_east_west = new_bounds.maxEast - new_bounds.minEast;
        }
        Point vmin = this.getPoint(bounds.getMin());
        Point vmax = this.getPoint(bounds.getMax());
        int w = vmax.x + 1;
        int h = vmin.y + 1;
        if (w <= this.ground_width && h <= this.ground_height) {
            this.graphics.setClip(0, 0, w, h);
            return;
        }
        if (w > this.ground_width) {
            this.ground_width = w;
        }
        if (h > this.ground_height) {
            this.ground_height = h;
        }
        this.ground_image = new BufferedImage(this.ground_width, this.ground_height, 1);
        this.graphics = this.ground_image.createGraphics();
        this.graphics.setClip(0, 0, w, h);
    }

    public ProjectionBounds getProjectionBounds() {
        return this.view_bounds;
    }

    public Point getPoint(EastNorth p) {
        double x = p.east() - this.view_bounds.minEast;
        double y = this.view_bounds.maxNorth - p.north();
        return new Point((int)(x /= this.scale), (int)(y /= this.scale));
    }

    public EastNorth getEastNorth(int x, int y) {
        return new EastNorth(this.view_bounds.minEast + (double)x * this.scale, this.view_bounds.minNorth - (double)y * this.scale);
    }

    public boolean isVisible(int x, int y) {
        return true;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void repaint() {
    }
}

