/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;

public class RouteRepresentationTest
extends AbstractTest {
    @Test
    public void correctRouteTest() {
        ArrayList<RelationMember> members = new ArrayList<RelationMember>();
        Node n1 = new Node();
        n1.put("name", "Stop1");
        n1.put("public_transport", "stop_position");
        RelationMember rm1 = new RelationMember("stop", (OsmPrimitive)n1);
        members.add(rm1);
        Way w1 = new Way();
        w1.put("name", "Stop2");
        w1.put("highway", "platform");
        RelationMember rm2 = new RelationMember("platform", (OsmPrimitive)w1);
        members.add(rm2);
        Node n2 = new Node();
        n2.put("name", "Stop3");
        n2.put("public_transport", "platform");
        RelationMember rm3 = new RelationMember("platform", (OsmPrimitive)n2);
        members.add(rm3);
        Node n3 = new Node();
        n3.put("name", "Stop4");
        n3.put("public_transport", "stop_position");
        RelationMember rm4 = new RelationMember("stop", (OsmPrimitive)n3);
        members.add(rm4);
        Node n4 = new Node();
        n4.put("name", "Stop4");
        n4.put("public_transport", "platform");
        RelationMember rm5 = new RelationMember("platform", (OsmPrimitive)n4);
        members.add(rm5);
        Node n5 = new Node();
        n5.put("name", "Stop5");
        n5.put("highway", "platform");
        RelationMember rm6 = new RelationMember("platform_exit_only", (OsmPrimitive)n5);
        members.add(rm6);
        Way w2 = new Way();
        RelationMember rm7 = new RelationMember("", (OsmPrimitive)w2);
        members.add(rm7);
        Way w3 = new Way();
        RelationMember rm8 = new RelationMember("", (OsmPrimitive)w3);
        members.add(rm8);
        Relation r3 = new Relation();
        Way w4 = new Way();
        Way w5 = new Way();
        Way w6 = new Way();
        r3.addMember(new RelationMember("", (OsmPrimitive)w4));
        r3.addMember(new RelationMember("", (OsmPrimitive)w5));
        r3.addMember(new RelationMember("", (OsmPrimitive)w6));
        RelationMember rm9 = new RelationMember("", (OsmPrimitive)r3);
        members.add(rm9);
        Way w7 = new Way();
        RelationMember rm10 = new RelationMember("", (OsmPrimitive)w7);
        members.add(rm10);
        Relation route = new Relation();
        route.setMembers(members);
        PTRouteDataManager manager = new PTRouteDataManager(route);
        Assert.assertEquals((long)manager.getPTStopCount(), (long)5L);
        Assert.assertEquals((long)manager.getPTWayCount(), (long)4L);
    }

    @Test
    public void nestedRelationTest() {
        ArrayList<RelationMember> members = new ArrayList<RelationMember>();
        Node n1 = new Node();
        n1.put("name", "Stop1");
        n1.put("public_transport", "stop_position");
        RelationMember rm1 = new RelationMember("stop", (OsmPrimitive)n1);
        members.add(rm1);
        Way w1 = new Way();
        w1.put("name", "Stop2");
        w1.put("highway", "platform");
        RelationMember rm2 = new RelationMember("platform", (OsmPrimitive)w1);
        members.add(rm2);
        Node n2 = new Node();
        n2.put("name", "Stop3");
        n2.put("public_transport", "platform");
        RelationMember rm3 = new RelationMember("platform", (OsmPrimitive)n2);
        members.add(rm3);
        Node n3 = new Node();
        n3.put("name", "Stop4");
        n3.put("public_transport", "stop_position");
        RelationMember rm4 = new RelationMember("stop", (OsmPrimitive)n3);
        members.add(rm4);
        Node n4 = new Node();
        n4.put("name", "Stop4");
        n4.put("public_transport", "platform");
        RelationMember rm5 = new RelationMember("platform", (OsmPrimitive)n4);
        members.add(rm5);
        Node n5 = new Node();
        n5.put("name", "Stop5");
        n5.put("highway", "platform");
        RelationMember rm6 = new RelationMember("platform_exit_only", (OsmPrimitive)n5);
        members.add(rm6);
        Way w2 = new Way();
        RelationMember rm7 = new RelationMember("", (OsmPrimitive)w2);
        members.add(rm7);
        Way w3 = new Way();
        RelationMember rm8 = new RelationMember("", (OsmPrimitive)w3);
        members.add(rm8);
        Relation r3 = new Relation();
        Way w4 = new Way();
        Node wrongNode = new Node();
        Way w6 = new Way();
        r3.addMember(new RelationMember("", (OsmPrimitive)w4));
        r3.addMember(new RelationMember("", (OsmPrimitive)wrongNode));
        r3.addMember(new RelationMember("", (OsmPrimitive)w6));
        RelationMember rm9 = new RelationMember("", (OsmPrimitive)r3);
        members.add(rm9);
        Way w7 = new Way();
        RelationMember rm10 = new RelationMember("", (OsmPrimitive)w7);
        members.add(rm10);
        Relation route = new Relation();
        route.setMembers(members);
        PTRouteDataManager manager = new PTRouteDataManager(route);
        Assert.assertEquals((long)manager.getFailedMembers().size(), (long)1L);
        Assert.assertEquals((long)manager.getPTStopCount(), (long)5L);
        Assert.assertEquals((long)manager.getPTWayCount(), (long)3L);
    }
}

