/*
 * Decompiled with CFR 0.152.
 */
package MichiganLeft;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MichiganLeft
extends Plugin {
    JMenuItem MichiganLeft;

    public MichiganLeft(PluginInformation info) {
        super(info);
        this.MichiganLeft = MainMenu.add((JMenu)MainApplication.getMenu().dataMenu, (JosmAction)new MichiganLeftAction());
    }

    private static class MichiganLeftAction
    extends JosmAction {
        private LinkedList<Command> cmds = new LinkedList();

        MichiganLeftAction() {
            super(I18n.tr((String)"Michigan Left", (Object[])new Object[0]), "michigan_left", I18n.tr((String)"Adds no left turn for sets of 4 or 5 ways.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:michigan_left", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Michigan Left", (Object[])new Object[0])}), (int)78, (int)5007), true);
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(ActionEvent e) {
            Hashtable<Node, Integer> extremNodes;
            DataSet ds = MainApplication.getLayerManager().getEditDataSet();
            Collection mainSelection = ds.getSelected();
            ArrayList<Object> selection = new ArrayList<Object>();
            for (Object prim : mainSelection) {
                selection.add(prim);
            }
            int ways = 0;
            for (Object prim : selection) {
                if (!(prim instanceof Way)) continue;
                ++ways;
            }
            if (ways != 4 && ways != 5) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select 4 or 5 ways to assign no left turns.", (Object[])new Object[0]));
                return;
            }
            if (ways == 4) {
                extremNodes = new Hashtable<Node, Integer>();
                for (OsmPrimitive osmPrimitive : selection) {
                    if (!(osmPrimitive instanceof Way)) continue;
                    Way way = (Way)osmPrimitive;
                    this.incrementHashtable(extremNodes, way.firstNode());
                    this.incrementHashtable(extremNodes, way.lastNode());
                }
                if (extremNodes.size() != 4) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select 4 ways that form a closed relation.", (Object[])new Object[0]));
                    return;
                }
                ArrayList orderedWays = new ArrayList();
                Way way = (Way)selection.iterator().next();
                orderedWays.add(way);
                selection.remove(way);
                while (selection.size() > 0) {
                    void var8_11;
                    boolean found = false;
                    Node nextNode = var8_11.lastNode();
                    for (OsmPrimitive osmPrimitive : selection) {
                        Way tmpWay = (Way)osmPrimitive;
                        if (tmpWay.firstNode() != nextNode) continue;
                        orderedWays.add(tmpWay);
                        selection.remove(osmPrimitive);
                        Way way2 = tmpWay;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unable to order the ways. Please verify their directions", (Object[])new Object[0]));
                    return;
                }
                for (int index = 0; index < 4; ++index) {
                    Way firstWay = (Way)orderedWays.get(index);
                    Way lastWay = (Way)orderedWays.get((index + 1) % 4);
                    Node node = firstWay.lastNode();
                    this.cmds.add((Command)new AddCommand(ds, (OsmPrimitive)this.buildRelation(firstWay, lastWay, node)));
                }
                SequenceCommand c = new SequenceCommand(I18n.tr((String)"Create Michigan left turn restriction", (Object[])new Object[0]), this.cmds);
                Main.main.undoRedo.add((Command)c);
                this.cmds.clear();
            }
            if (ways == 5) {
                Node last;
                Node first;
                Way way;
                extremNodes = new Hashtable();
                for (OsmPrimitive osmPrimitive : selection) {
                    if (!(osmPrimitive instanceof Way)) continue;
                    Way way2 = (Way)osmPrimitive;
                    this.incrementHashtable(extremNodes, way2.firstNode());
                    this.incrementHashtable(extremNodes, way2.lastNode());
                }
                ArrayList<Node> viaNodes = new ArrayList<Node>();
                Enumeration enumeration = extremNodes.keys();
                while (enumeration.hasMoreElements()) {
                    Node extrem = (Node)enumeration.nextElement();
                    Integer nb = extremNodes.get(extrem);
                    if (nb != 3) continue;
                    viaNodes.add(extrem);
                }
                if (viaNodes.size() != 2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unable to find via nodes. Please check your selection", (Object[])new Object[0]));
                    return;
                }
                Node node = (Node)viaNodes.get(0);
                Node viaLast = (Node)viaNodes.get(1);
                Way middle = null;
                for (OsmPrimitive osmPrimitive : selection) {
                    if (!(osmPrimitive instanceof Way)) continue;
                    way = (Way)osmPrimitive;
                    first = way.firstNode();
                    last = way.lastNode();
                    if ((!first.equals((Object)node) || !last.equals((Object)viaLast)) && (!first.equals((Object)viaLast) || !last.equals((Object)node))) continue;
                    middle = way;
                }
                for (OsmPrimitive osmPrimitive : selection) {
                    if (!(osmPrimitive instanceof Way) || (way = (Way)osmPrimitive) == middle) continue;
                    first = way.firstNode();
                    last = way.lastNode();
                    if (first == node) {
                        this.buildRelation(middle, way, (Node)viaNodes.get(0));
                        continue;
                    }
                    if (first == viaLast) {
                        this.buildRelation(middle, way, (Node)viaNodes.get(1));
                        continue;
                    }
                    if (last == node) {
                        this.buildRelation(way, middle, (Node)viaNodes.get(0));
                        continue;
                    }
                    if (last != viaLast) continue;
                    this.buildRelation(way, middle, (Node)viaNodes.get(1));
                }
                SequenceCommand c = new SequenceCommand(I18n.tr((String)"Create Michigan left turn restriction", (Object[])new Object[0]), this.cmds);
                Main.main.undoRedo.add((Command)c);
                this.cmds.clear();
            }
        }

        public void incrementHashtable(Hashtable<Node, Integer> hash, Node node) {
            if (hash.containsKey(node)) {
                Integer nb = hash.get(node);
                hash.put(node, nb + 1);
            } else {
                hash.put(node, 1);
            }
        }

        public Relation buildRelation(Way fromWay, Way toWay, Node viaNode) {
            Relation relation = new Relation();
            RelationMember from = new RelationMember("from", (OsmPrimitive)fromWay);
            relation.addMember(from);
            RelationMember to = new RelationMember("to", (OsmPrimitive)toWay);
            relation.addMember(to);
            RelationMember via = new RelationMember("via", (OsmPrimitive)viaNode);
            relation.addMember(via);
            relation.put("type", "restriction");
            relation.put("restriction", "no_left_turn");
            return relation;
        }

        protected void updateEnabledState() {
            this.setEnabled(this.getLayerManager().getEditLayer() != null);
        }

        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        }
    }
}

