/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.lookup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lookup {
    private static final String prefix = "META-INF/services/";
    private static final Logger LOGGER = Logger.getLogger("org.jaitools.lookup");
    private static HashMap<String, WeakReference<List<Class>>> cache = new HashMap();

    public static List<Class> getProviders(String spiName) {
        List<Class> providers = null;
        WeakReference<List<Class>> ref = cache.get(spiName);
        if (ref != null) {
            providers = (List<Class>)ref.get();
        }
        if (providers == null) {
            providers = Lookup.getProvidersFromSpiFile(spiName);
            cache.put(spiName, new WeakReference<List<Class>>(providers));
        }
        return providers;
    }

    public static void clearCache() {
        cache.clear();
    }

    public static Map<String, List<Class>> getCachedProviders() {
        HashMap<String, List<Class>> copy = new HashMap<String, List<Class>>();
        for (String key : cache.keySet()) {
            List list;
            WeakReference<List<Class>> ref = cache.get(key);
            if (ref == null || (list = (List)ref.get()) == null) continue;
            copy.put(key, list);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class> getProvidersFromSpiFile(String spiName) {
        ArrayList<Class> providers;
        block24: {
            providers = new ArrayList<Class>();
            ClassLoader cl = Lookup.class.getClassLoader();
            if (cl != null) {
                InputStream str = cl.getResourceAsStream(prefix + spiName);
                if (str != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(str));
                    String line = null;
                    block19: while (true) {
                        try {
                            while ((line = reader.readLine()) != null) {
                                String text = line.trim();
                                if (text.length() <= 0 || text.startsWith("#")) continue;
                                try {
                                    providers.add(Class.forName(text));
                                    continue block19;
                                }
                                catch (ClassNotFoundException ex) {
                                    LOGGER.log(Level.WARNING, "Class not found: {0}", text);
                                }
                            }
                            break block24;
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.SEVERE, "Problem reading services file: {0}", spiName);
                            break block24;
                        }
                    }
                    finally {
                        try {
                            str.close();
                        }
                        catch (Throwable e) {}
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (Throwable e) {}
                    }
                }
                LOGGER.log(Level.SEVERE, "Could not find META-INF/services/{0}", spiName);
            }
        }
        return providers;
    }
}

