/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.BitMapCachedObject;
import org.hsqldb.persist.BlockObjectStore;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DataSpaceManagerSimple;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.IntArrayCachedObject;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;

public class DataSpaceManagerBlocks
implements DataSpaceManager {
    DataFileCache cache;
    TableSpaceManagerBlocks defaultSpaceManager;
    TableSpaceManagerBlocks directorySpaceManager;
    IntKeyHashMap spaceManagerList;
    BlockObjectStore rootStore;
    BlockObjectStore directoryStore;
    BlockObjectStore bitMapStore;
    IntArrayCachedObject rootBlock;
    DirectoryBlockCachedObject firstDirectory;
    int spaceIdSequence = 8;
    int blockSize = 2048;
    int bitmapIntSize = 2048;
    int fileBlockItemCount = this.bitmapIntSize * 32;
    int fileBlockSize;
    int dataFileScale;
    int freeItemCacheSize = 2048;
    BlockAccessor ba;

    DataSpaceManagerBlocks() {
    }

    public DataSpaceManagerBlocks(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        this.dataFileScale = this.cache.getDataFileScale();
        this.fileBlockSize = this.fileBlockItemCount * this.dataFileScale;
        this.ba = new BlockAccessor();
        this.spaceManagerList = new IntKeyHashMap();
        this.directorySpaceManager = new TableSpaceManagerBlocks(this, 1, this.fileBlockSize, 16, this.dataFileScale);
        this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, this.fileBlockSize, this.freeItemCacheSize, this.dataFileScale);
        this.spaceManagerList.put(1, this.directorySpaceManager);
        this.spaceManagerList.put(7, this.defaultSpaceManager);
        this.rootStore = new BlockObjectStore(this.cache, this.directorySpaceManager, IntArrayCachedObject.class, 4 * this.blockSize, this.blockSize);
        this.directoryStore = new BlockObjectStore(this.cache, this.directorySpaceManager, DirectoryBlockCachedObject.class, 12 * this.blockSize, this.blockSize);
        this.bitMapStore = new BlockObjectStore(this.cache, this.directorySpaceManager, BitMapCachedObject.class, 4 * this.bitmapIntSize, this.bitmapIntSize);
        if (this.cache.spaceManagerPosition == 0L) {
            this.initNewSpaceDirectory();
            this.cache.spaceManagerPosition = this.rootBlock.getPos() * (long)this.dataFileScale;
            this.cache.setFileModified();
        } else {
            long l = this.cache.spaceManagerPosition / (long)this.dataFileScale;
            this.rootBlock = (IntArrayCachedObject)this.rootStore.get(l, true);
            if (this.getBlockIndexLimit() < 2) {
                throw Error.error(452);
            }
            this.spaceIdSequence = this.getMaxSpaceId() + 1;
            this.initialiseTableSpace(this.directorySpaceManager);
            this.initialiseTableSpace(this.defaultSpaceManager);
        }
        this.firstDirectory = this.getDirectory(0, true);
    }

    private void initNewSpaceDirectory() {
        long l = this.cache.getFileFreePos();
        long l2 = l / (long)this.fileBlockSize + 1L;
        long l3 = this.cache.enlargeFileSpace(l2 * (long)this.fileBlockSize - l);
        this.defaultSpaceManager.initialiseFileBlock(null, l3, this.cache.getFileFreePos());
        long l4 = l2;
        long l5 = this.calculateDirectorySpaceBlocks(l2);
        l3 = this.cache.enlargeFileSpace(l5 * (long)this.fileBlockSize);
        this.directorySpaceManager.initialiseFileBlock(null, l3, this.cache.getFileFreePos());
        IntArrayCachedObject intArrayCachedObject = new IntArrayCachedObject(this.blockSize);
        this.rootStore.add(null, intArrayCachedObject, false);
        this.rootBlock = (IntArrayCachedObject)this.rootStore.get(intArrayCachedObject.getPos(), true);
        this.createFileBlocksInDirectory((int)l4, (int)l5, 1);
        this.createFileBlocksInDirectory(0, (int)l4, 7);
        long l6 = this.getBlockIndexLimit();
        if (l6 * (long)this.fileBlockSize != this.cache.getFileFreePos()) {
            throw Error.error(452);
        }
    }

    private long calculateDirectorySpaceBlocks(long l) {
        long l2 = 4 * this.blockSize;
        l2 += 12L * (l + (long)this.blockSize);
        return (l2 += 4L * (long)this.bitmapIntSize * (l + (long)this.blockSize)) / (long)this.fileBlockSize + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileBlocks(int n, int n2) {
        this.cache.writeLock.lock();
        try {
            long l = this.getExistingBlockIndex(n, n2);
            if (l > 0L) {
                long l2 = l * (long)this.fileBlockSize;
                return l2;
            }
            long l3 = this.getNewFileBlocks(n, n2);
            return l3;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    private long getNewFileBlocks(int n, int n2) {
        long l = 4L * (long)this.bitmapIntSize * (long)n2;
        if (!this.directorySpaceManager.hasFileRoom(l)) {
            long l2 = this.getNewFileBlocksNoCheck(1, 1);
            this.directorySpaceManager.addFileBlock(l2, l2 + (long)this.fileBlockSize);
            long l3 = this.getBlockIndexLimit();
            if (l3 * (long)this.fileBlockSize != this.cache.getFileFreePos()) {
                throw Error.error(452);
            }
        }
        return this.getNewFileBlocksNoCheck(n, n2);
    }

    private long getNewFileBlocksNoCheck(int n, int n2) {
        long l = this.getBlockIndexLimit();
        if (l * (long)this.fileBlockSize != this.cache.getFileFreePos()) {
            throw Error.error(452);
        }
        long l2 = this.cache.enlargeFileSpace((long)n2 * (long)this.fileBlockSize);
        this.createFileBlocksInDirectory((int)l, n2, n);
        return l2;
    }

    private void createFileBlocksInDirectory(int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            this.createFileBlockInDirectory(n + i, n3);
        }
    }

    private void createFileBlockInDirectory(int n, int n2) {
        DirectoryBlockCachedObject directoryBlockCachedObject = this.getOrCreateDirectory(n);
        int n3 = n % this.blockSize;
        BitMapCachedObject bitMapCachedObject = (BitMapCachedObject)this.bitMapStore.getNewInstance(this.bitmapIntSize);
        this.bitMapStore.add(null, bitMapCachedObject, false);
        int n4 = (int)(bitMapCachedObject.getPos() * (long)this.dataFileScale / 4096L);
        this.updateDirectory(directoryBlockCachedObject, n3, n2, n4);
    }

    private DirectoryBlockCachedObject getDirectory(int n, boolean bl) {
        int n2 = n / this.blockSize;
        long l = this.rootBlock.getIntArray()[n2];
        if (l == 0L) {
            return null;
        }
        DirectoryBlockCachedObject directoryBlockCachedObject = (DirectoryBlockCachedObject)this.directoryStore.get(l *= (long)(4096 / this.dataFileScale), bl);
        return directoryBlockCachedObject;
    }

    private DirectoryBlockCachedObject getOrCreateDirectory(int n) {
        int n2 = n / this.blockSize;
        long l = this.rootBlock.getIntArray()[n2];
        DirectoryBlockCachedObject directoryBlockCachedObject = l == 0L ? this.createDirectory(n) : (DirectoryBlockCachedObject)this.directoryStore.get(l *= (long)(4096 / this.dataFileScale), false);
        return directoryBlockCachedObject;
    }

    private DirectoryBlockCachedObject createDirectory(int n) {
        int n2;
        DirectoryBlockCachedObject directoryBlockCachedObject = new DirectoryBlockCachedObject(this.blockSize);
        this.directoryStore.add(null, directoryBlockCachedObject, false);
        int n3 = n / this.blockSize;
        this.rootBlock.getIntArray()[n3] = n2 = (int)(directoryBlockCachedObject.getPos() * (long)this.dataFileScale / 4096L);
        this.rootBlock.hasChanged = true;
        return directoryBlockCachedObject;
    }

    private void updateDirectory(DirectoryBlockCachedObject directoryBlockCachedObject, int n, int n2, int n3) {
        directoryBlockCachedObject = (DirectoryBlockCachedObject)this.directoryStore.get(directoryBlockCachedObject.getPos(), true);
        directoryBlockCachedObject.getTableIdArray()[n] = n2;
        directoryBlockCachedObject.getBitmapAddressArray()[n] = n3;
        directoryBlockCachedObject.hasChanged = true;
        directoryBlockCachedObject.keepInMemory(false);
    }

    private int getBlockIndexLimit() {
        int n;
        int n2;
        int[] nArray = this.rootBlock.getIntArray();
        for (n2 = 0; n2 < nArray.length && nArray[n2] != 0; ++n2) {
        }
        if (n2 == 0) {
            return 0;
        }
        long l = nArray[--n2];
        DirectoryBlockCachedObject directoryBlockCachedObject = (DirectoryBlockCachedObject)this.directoryStore.get(l *= (long)(4096 / this.dataFileScale), false);
        int[] nArray2 = directoryBlockCachedObject.getBitmapAddressArray();
        for (n = 0; n < nArray2.length && nArray2[n] != 0; ++n) {
        }
        return n2 * this.blockSize + n;
    }

    private int getMaxSpaceId() {
        boolean bl;
        int n = 7;
        this.ba.initialise(false);
        while (bl = this.ba.nextBlock()) {
            int n2 = this.ba.getTableId();
            if (n2 <= n) continue;
            n = n2;
        }
        this.ba.reset();
        return n;
    }

    private int getExistingBlockIndex(int n, int n2) {
        this.ba.initialise(false);
        int n3 = -1;
        int n4 = -1;
        while (true) {
            boolean bl;
            if (!(bl = this.ba.nextBlockForTable(0))) {
                n3 = -1;
                break;
            }
            if (n2 == 1) {
                n3 = this.ba.currentBlockIndex;
                break;
            }
            if (n3 == -1) {
                n4 = n3 = this.ba.currentBlockIndex;
                continue;
            }
            if (this.ba.currentBlockIndex - n3 + 1 == n2) break;
            if (this.ba.currentBlockIndex == n4 + 1) {
                n4 = this.ba.currentBlockIndex;
                continue;
            }
            n4 = -1;
            n3 = -1;
        }
        this.ba.reset();
        if (n3 > 0) {
            this.setDirectoryBlocksAsTable(n, n3, n2);
        }
        return n3;
    }

    private void setDirectoryBlocksAsTable(int n, int n2, int n3) {
        int n4 = -1;
        CachedObjectBase cachedObjectBase = null;
        for (int i = n2; i < n2 + n3; ++i) {
            if (n4 != i / this.blockSize) {
                if (cachedObjectBase != null) {
                    cachedObjectBase.setInMemory(false);
                }
                cachedObjectBase = this.getDirectory(i, true);
                n4 = i / this.blockSize;
            }
            int n5 = i % this.blockSize;
            ((DirectoryBlockCachedObject)cachedObjectBase).getTableIdArray()[n5] = n;
        }
        cachedObjectBase.setInMemory(false);
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    @Override
    public TableSpaceManager getTableSpace(int n) {
        TableSpaceManagerBlocks tableSpaceManagerBlocks;
        if (n == 7) {
            return this.defaultSpaceManager;
        }
        if (n >= this.spaceIdSequence) {
            this.spaceIdSequence = n + 1;
        }
        if ((tableSpaceManagerBlocks = (TableSpaceManagerBlocks)this.spaceManagerList.get(n)) == null) {
            tableSpaceManagerBlocks = new TableSpaceManagerBlocks(this, n, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale);
            this.initialiseTableSpace(tableSpaceManagerBlocks);
            this.spaceManagerList.put(n, tableSpaceManagerBlocks);
        }
        return tableSpaceManagerBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNewTableSpaceID() {
        this.cache.writeLock.lock();
        try {
            int n = this.spaceIdSequence++;
            return n;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n) {
        if (n == 7 || n == 1) {
            return;
        }
        TableSpaceManager tableSpaceManager = (TableSpaceManager)this.spaceManagerList.get(n);
        if (tableSpaceManager != null) {
            tableSpaceManager.reset();
            this.spaceManagerList.remove(n);
        }
        this.cache.writeLock.lock();
        try {
            boolean bl;
            this.ba.initialise(true);
            while (bl = this.ba.nextBlockForTable(n)) {
                this.cache.releaseRange(this.ba.currentBlockIndex * this.fileBlockItemCount, (this.ba.currentBlockIndex + 1) * this.fileBlockItemCount);
                this.ba.setTableId(0);
                this.ba.setFreeSpaceValue(0);
                this.ba.setFreeBlockValue(0);
                this.ba.currentDir.hasChanged = true;
                this.ba.currentBitMap.bitMap.reset();
                this.ba.currentBitMap.hasChanged = true;
            }
            this.ba.reset();
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(DoubleIntIndex doubleIntIndex, long l, long l2, boolean bl) {
        int n;
        DataSpaceManagerSimple.compactLookup(doubleIntIndex, this.dataFileScale);
        if (!bl && (n = doubleIntIndex.size() - doubleIntIndex.capacity() / 2) < 0) {
            doubleIntIndex.setValuesSearchTarget();
            doubleIntIndex.sort();
            return;
        }
        this.cache.writeLock.lock();
        try {
            int n2;
            int n3;
            this.ba.initialise(true);
            int[] nArray = doubleIntIndex.getKeys();
            int[] nArray2 = doubleIntIndex.getValues();
            for (int i = 0; i < doubleIntIndex.size(); ++i) {
                int n4 = nArray[i];
                n3 = nArray2[i];
                n2 = n3 / this.dataFileScale;
                this.freeTableSpacePart(n4, n2);
            }
            long l3 = l / (long)this.dataFileScale;
            n3 = (int)((l2 - l) / (long)this.dataFileScale);
            this.freeTableSpacePart(l3, n3);
            n2 = (int)((l3 + (long)n3) / (long)this.fileBlockItemCount);
            this.ba.endBlockUpdate(n2 + 1);
            this.ba.reset();
        }
        finally {
            this.cache.writeLock.unlock();
        }
        doubleIntIndex.clear();
        doubleIntIndex.setValuesSearchTarget();
    }

    private void freeTableSpacePart(long l, int n) {
        while (n > 0) {
            int n2 = (int)(l / (long)this.fileBlockItemCount);
            int n3 = (int)(l % (long)this.fileBlockItemCount);
            int n4 = this.fileBlockItemCount - n3;
            if (n4 > n) {
                n4 = n;
            }
            this.ba.endBlockUpdate(n2);
            this.ba.moveToBlock(n2);
            this.ba.currentBitMap.bitMap.setRange(n3, n4);
            this.ba.currentBitMap.hasChanged = true;
            n -= n4;
            l += (long)n4;
        }
    }

    int findTableSpace(long l) {
        int n = (int)(l / (long)this.fileBlockItemCount);
        this.ba.initialise(false);
        boolean bl = this.ba.moveToBlock(n);
        if (!bl) {
            this.ba.reset();
            return 7;
        }
        int n2 = this.ba.getTableId();
        this.ba.reset();
        return n2;
    }

    @Override
    public long getLostBlocksSize() {
        boolean bl;
        long l = 0L;
        this.ba.initialise(false);
        while (bl = this.ba.nextBlock()) {
            l += (long)(this.ba.getFreeSpaceValue() * this.dataFileScale);
            if (this.ba.getTableId() != 0) continue;
            l += (long)this.fileBlockSize;
        }
        this.ba.reset();
        return l;
    }

    @Override
    public int getFileBlockSize() {
        return this.fileBlockSize;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void initialiseSpaces() {
        Iterator iterator = this.spaceManagerList.values().iterator();
        while (iterator.hasNext()) {
            TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)iterator.next();
            this.initialiseTableSpace(tableSpaceManagerBlocks);
        }
    }

    @Override
    public void reset() {
        Iterator iterator = this.spaceManagerList.values().iterator();
        while (iterator.hasNext()) {
            TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)iterator.next();
            tableSpaceManagerBlocks.reset();
        }
    }

    @Override
    public boolean isMultiSpace() {
        return true;
    }

    private void initialiseTableSpace(TableSpaceManagerBlocks tableSpaceManagerBlocks) {
        char c;
        int n = tableSpaceManagerBlocks.getSpaceID();
        char c2 = '\u0000';
        int n2 = -1;
        this.ba.initialise(false);
        while (this.ba.nextBlockForTable(n)) {
            c = this.ba.getFreeBlockValue();
            if (c <= c2) continue;
            n2 = this.ba.currentBlockIndex;
            c2 = c;
        }
        this.ba.reset();
        if (n2 < 0) {
            return;
        }
        this.ba.initialise(true);
        this.ba.moveToBlock(n2);
        c = this.ba.getFreeBlockValue();
        long l = (long)n2 * (long)this.fileBlockSize;
        tableSpaceManagerBlocks.initialiseFileBlock(null, l + (long)(this.fileBlockSize - c * this.dataFileScale), l + (long)this.fileBlockSize);
        int n3 = this.ba.getFreeSpaceValue();
        this.ba.setFreeSpaceValue((char)(n3 -= c));
        this.ba.setFreeBlockValue(0);
        this.ba.currentDir.hasChanged = true;
        this.ba.currentBitMap.bitMap.unsetRange(this.fileBlockItemCount - c, c);
        this.ba.currentBitMap.hasChanged = true;
        this.ba.reset();
    }

    private class BlockAccessor {
        boolean currentKeep;
        int currentBlockIndex = -1;
        int currentDirIndex = -1;
        int currentBlockOffset = -1;
        DirectoryBlockCachedObject currentDir = null;
        BitMapCachedObject currentBitMap = null;

        private BlockAccessor() {
        }

        void initialise(boolean bl) {
            this.currentKeep = bl;
        }

        boolean nextBlock() {
            boolean bl = this.moveToBlock(this.currentBlockIndex + 1);
            return bl;
        }

        boolean nextBlockForTable(int n) {
            do {
                boolean bl;
                if (bl = this.moveToBlock(this.currentBlockIndex + 1)) continue;
                return false;
            } while (this.getTableId() != n);
            return true;
        }

        boolean moveToBlock(int n) {
            if (this.currentBlockIndex != n) {
                if (this.currentDirIndex != n / DataSpaceManagerBlocks.this.blockSize) {
                    this.reset();
                    this.currentDirIndex = n / DataSpaceManagerBlocks.this.blockSize;
                    this.currentDir = DataSpaceManagerBlocks.this.getDirectory(n, this.currentKeep);
                }
                this.currentBlockIndex = n;
                this.currentBlockOffset = n % DataSpaceManagerBlocks.this.blockSize;
                if (this.currentBitMap != null) {
                    this.currentBitMap.keepInMemory(false);
                    this.currentBitMap = null;
                }
                if (this.currentDir == null) {
                    return false;
                }
                long l = this.currentDir.getBitmapAddressArray()[this.currentBlockOffset];
                if (l == 0L) {
                    return false;
                }
                if (this.currentKeep) {
                    this.currentBitMap = (BitMapCachedObject)DataSpaceManagerBlocks.this.bitMapStore.get(l *= (long)(4096 / DataSpaceManagerBlocks.this.dataFileScale), this.currentKeep);
                }
            }
            return true;
        }

        void reset() {
            if (this.currentDir != null && this.currentKeep) {
                this.currentDir.keepInMemory(false);
            }
            if (this.currentBitMap != null && this.currentKeep) {
                this.currentBitMap.keepInMemory(false);
            }
            this.currentBlockIndex = -1;
            this.currentDirIndex = -1;
            this.currentBlockOffset = -1;
            this.currentDir = null;
            this.currentBitMap = null;
        }

        boolean endBlockUpdate(int n) {
            if (this.currentBlockIndex != -1 && this.currentBlockIndex != n) {
                int n2 = this.currentBitMap.bitMap.countSetBits();
                int n3 = this.currentBitMap.bitMap.countSetBitsEnd();
                this.setFreeSpaceValue(n2);
                this.setFreeBlockValue(n3);
                this.currentDir.hasChanged = true;
                if (n2 == DataSpaceManagerBlocks.this.fileBlockItemCount) {
                    this.setTableId(0);
                    this.setFreeSpaceValue(0);
                    this.setFreeBlockValue(0);
                    this.currentBitMap.bitMap.reset();
                }
                return true;
            }
            return false;
        }

        int getTableId() {
            return DataSpaceManagerBlocks.this.ba.currentDir.getTableIdArray()[DataSpaceManagerBlocks.this.ba.currentBlockOffset];
        }

        void setTableId(int n) {
            DataSpaceManagerBlocks.this.ba.currentDir.getTableIdArray()[DataSpaceManagerBlocks.this.ba.currentBlockOffset] = n;
        }

        void setFreeSpaceValue(int n) {
            DataSpaceManagerBlocks.this.ba.currentDir.getFreeSpaceArray()[DataSpaceManagerBlocks.this.ba.currentBlockOffset] = (char)n;
        }

        char getFreeSpaceValue() {
            return DataSpaceManagerBlocks.this.ba.currentDir.getFreeSpaceArray()[DataSpaceManagerBlocks.this.ba.currentBlockOffset];
        }

        void setFreeBlockValue(int n) {
            DataSpaceManagerBlocks.this.ba.currentDir.getFreeBlockArray()[DataSpaceManagerBlocks.this.ba.currentBlockOffset] = (char)n;
        }

        char getFreeBlockValue() {
            return DataSpaceManagerBlocks.this.ba.currentDir.getFreeBlockArray()[DataSpaceManagerBlocks.this.ba.currentBlockOffset];
        }
    }
}

