/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

import it.geosolutions.jaiext.stats.Statistics;

public class VarianceStd
extends Statistics {
    private boolean variance;
    private double sumValues;
    private double sumSqrtValues;

    VarianceStd(boolean variance) {
        this.variance = variance;
        this.sumValues = 0.0;
        this.sumSqrtValues = 0.0;
        this.samples = 0L;
        this.type = variance ? Statistics.StatsType.VARIANCE : Statistics.StatsType.DEV_STD;
    }

    private double getSumValues() {
        return this.sumValues;
    }

    private double getSumSqrtValues() {
        return this.sumSqrtValues;
    }

    public void addSample(double sample) {
        this.sumValues += sample;
        this.sumSqrtValues += sample * sample;
        ++this.samples;
    }

    protected synchronized void accumulateStats(Statistics stats) {
        this.checkSameStats(stats);
        VarianceStd vstd = (VarianceStd)stats;
        this.samples += vstd.getNumSamples().longValue();
        this.sumValues += vstd.getSumValues();
        this.sumSqrtValues += vstd.getSumSqrtValues();
    }

    public Object getResult() {
        double varianceCalculated = (this.sumSqrtValues - this.sumValues * this.sumValues / (double)this.samples) / (double)(this.samples - 1L);
        if (this.variance) {
            return varianceCalculated;
        }
        return Math.sqrt(varianceCalculated);
    }

    protected void clearStats() {
        this.sumValues = 0.0;
        this.sumSqrtValues = 0.0;
        this.samples = 0L;
    }

    public Long getNumSamples() {
        return this.samples;
    }
}

