/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.format.CellFormatPart;
import org.apache.poi.ss.format.CellFormatType;
import org.apache.poi.ss.format.CellFormatter;

public class CellElapsedFormatter
extends CellFormatter {
    private final List<TimeSpec> specs = new ArrayList<TimeSpec>();
    private TimeSpec topmost;
    private final String printfFmt;
    private static final Pattern PERCENTS = Pattern.compile("%");
    private static final double HOUR__FACTOR = 0.041666666666666664;
    private static final double MIN__FACTOR = 6.944444444444444E-4;
    private static final double SEC__FACTOR = 1.1574074074074073E-5;

    public CellElapsedFormatter(String string) {
        super(string);
        StringBuffer stringBuffer = CellFormatPart.parseFormat(string, CellFormatType.ELAPSED, new ElapsedPartHandler());
        ListIterator<TimeSpec> listIterator = this.specs.listIterator(this.specs.size());
        while (listIterator.hasPrevious()) {
            TimeSpec timeSpec = listIterator.previous();
            stringBuffer.replace(timeSpec.pos, timeSpec.pos + timeSpec.len, "%0" + timeSpec.len + "d");
            if (timeSpec.type == this.topmost.type) continue;
            timeSpec.modBy = CellElapsedFormatter.modFor(timeSpec.type, timeSpec.len);
        }
        this.printfFmt = stringBuffer.toString();
    }

    private TimeSpec assignSpec(char c, int n, int n2) {
        TimeSpec timeSpec = new TimeSpec(c, n, n2, CellElapsedFormatter.factorFor(c, n2));
        this.specs.add(timeSpec);
        return timeSpec;
    }

    private static double factorFor(char c, int n) {
        switch (c) {
            case 'h': {
                return 0.041666666666666664;
            }
            case 'm': {
                return 6.944444444444444E-4;
            }
            case 's': {
                return 1.1574074074074073E-5;
            }
            case '0': {
                return 1.1574074074074073E-5 / Math.pow(10.0, n);
            }
        }
        throw new IllegalArgumentException("Uknown elapsed time spec: " + c);
    }

    private static double modFor(char c, int n) {
        switch (c) {
            case 'h': {
                return 24.0;
            }
            case 'm': {
                return 60.0;
            }
            case 's': {
                return 60.0;
            }
            case '0': {
                return Math.pow(10.0, n);
            }
        }
        throw new IllegalArgumentException("Uknown elapsed time spec: " + c);
    }

    @Override
    public void formatValue(StringBuffer stringBuffer, Object object) {
        double d = ((Number)object).doubleValue();
        if (d < 0.0) {
            stringBuffer.append('-');
            d = -d;
        }
        Object[] objectArray = new Long[this.specs.size()];
        for (int i = 0; i < this.specs.size(); ++i) {
            objectArray[i] = this.specs.get(i).valueFor(d);
        }
        Formatter formatter = new Formatter(stringBuffer);
        formatter.format(this.printfFmt, objectArray);
    }

    @Override
    public void simpleValue(StringBuffer stringBuffer, Object object) {
        this.formatValue(stringBuffer, object);
    }

    private class ElapsedPartHandler
    implements CellFormatPart.PartHandler {
        private ElapsedPartHandler() {
        }

        @Override
        public String handlePart(Matcher matcher, String string, CellFormatType cellFormatType, StringBuffer stringBuffer) {
            int n = stringBuffer.length();
            char c = string.charAt(0);
            switch (c) {
                case '[': {
                    if (string.length() < 3) break;
                    if (CellElapsedFormatter.this.topmost != null) {
                        throw new IllegalArgumentException("Duplicate '[' times in format");
                    }
                    string = string.toLowerCase();
                    int n2 = string.length() - 2;
                    CellElapsedFormatter.this.topmost = CellElapsedFormatter.this.assignSpec(string.charAt(1), n, n2);
                    return string.substring(1, 1 + n2);
                }
                case '0': 
                case 'h': 
                case 'm': 
                case 's': {
                    string = string.toLowerCase();
                    CellElapsedFormatter.this.assignSpec(string.charAt(0), n, string.length());
                    return string;
                }
                case '\n': {
                    return "%n";
                }
                case '\"': {
                    string = string.substring(1, string.length() - 1);
                    break;
                }
                case '\\': {
                    string = string.substring(1);
                    break;
                }
                case '*': {
                    if (string.length() <= 1) break;
                    string = CellFormatPart.expandChar(string);
                    break;
                }
                case '_': {
                    return null;
                }
            }
            return PERCENTS.matcher(string).replaceAll("%%");
        }
    }

    private static class TimeSpec {
        final char type;
        final int pos;
        final int len;
        final double factor;
        double modBy;

        public TimeSpec(char c, int n, int n2, double d) {
            this.type = c;
            this.pos = n;
            this.len = n2;
            this.factor = d;
            this.modBy = 0.0;
        }

        public long valueFor(double d) {
            double d2 = this.modBy == 0.0 ? d / this.factor : d / this.factor % this.modBy;
            if (this.type == '0') {
                return Math.round(d2);
            }
            return (long)d2;
        }
    }
}

