/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.routes.RouteLayer;
import org.openstreetmap.josm.plugins.routes.xml.Routes;
import org.openstreetmap.josm.plugins.routes.xml.RoutesXMLLayer;
import org.openstreetmap.josm.tools.Logging;

public class RoutesPlugin
extends Plugin
implements LayerManager.LayerChangeListener {
    private final List<RouteLayer> routeLayers = new ArrayList<RouteLayer>();

    public RoutesPlugin(PluginInformation info) {
        super(info);
        MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        File routesFile = new File(this.getPluginDirs().getUserDataDirectory(false), "routes.xml");
        if (!routesFile.exists()) {
            Logging.info((String)"File with route definitions doesn't exist, using default");
            try {
                routesFile.getParentFile().mkdir();
                try (FileOutputStream outputStream = new FileOutputStream(routesFile);){
                    InputStream inputStream = Routes.class.getResourceAsStream("routes.xml");
                    Object object = null;
                    try {
                        int read;
                        byte[] b = new byte[512];
                        while ((read = inputStream.read(b)) != -1) {
                            ((OutputStream)outputStream).write(b, 0, read);
                        }
                    }
                    catch (Throwable b) {
                        object = b;
                        throw b;
                    }
                    finally {
                        if (inputStream != null) {
                            RoutesPlugin.$closeResource((Throwable)object, inputStream);
                        }
                    }
                }
            }
            catch (IOException e) {
                Logging.error((Throwable)e);
            }
        }
        try {
            JAXBContext context = JAXBContext.newInstance((String)Routes.class.getPackage().getName(), (ClassLoader)Routes.class.getClassLoader());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Routes routes = (Routes)unmarshaller.unmarshal((InputStream)new FileInputStream(this.getPluginDirs().getUserDataDirectory(false) + File.separator + "routes.xml"));
            for (RoutesXMLLayer layer : routes.getLayer()) {
                if (!layer.isEnabled()) continue;
                this.routeLayers.add(new RouteLayer(layer));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        Layer layer = e.getAddedLayer();
        if (layer instanceof OsmDataLayer) {
            LayerManager lm = e.getSource();
            for (RouteLayer routeLayer : this.routeLayers) {
                if (lm.containsLayer((Layer)routeLayer)) continue;
                SwingUtilities.invokeLater(() -> {
                    if (!lm.containsLayer((Layer)routeLayer)) {
                        lm.addLayer((Layer)routeLayer);
                    }
                });
            }
        }
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        for (Layer layer : e.getSource().getLayers()) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return;
        }
        if (!e.isLastLayer()) {
            SwingUtilities.invokeLater(() -> {
                for (RouteLayer routeLayer : this.routeLayers) {
                    if (!e.getSource().containsLayer((Layer)routeLayer)) continue;
                    e.getSource().removeLayer((Layer)routeLayer);
                }
            });
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }
}

