/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo.ruian;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.plugins.pointinfo.PointInfoUtils;
import org.openstreetmap.josm.plugins.pointinfo.ruian.AddrPlaces;
import org.openstreetmap.josm.plugins.pointinfo.ruian.ObjectWithoutGeometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

class RuianRecord {
    private double m_coor_lat;
    private double m_coor_lon;
    private String m_source;
    private long m_objekt_ruian_id;
    private int m_objekt_podlazi;
    private int m_objekt_byty;
    private String m_objekt_zpusob_vyuziti;
    private String m_objekt_zpusob_vyuziti_kod;
    private String m_objekt_zpusob_vyuziti_key;
    private String m_objekt_zpusob_vyuziti_val;
    private String m_objekt_dokonceni;
    private String m_objekt_plati_od;
    private String m_err_user;
    private String m_err_date;
    private String m_err_type;
    private String m_err_note;
    private ArrayList<ObjectWithoutGeometry> m_so_bez_geometrie;
    private ArrayList<AddrPlaces> m_adresni_mista;
    private long m_parcela_ruian_id;
    private String m_parcela_druh_pozemku;
    private String m_parcela_zpusob_vyuziti;
    private String m_parcela_plati_od;
    private long m_ulice_ruian_id;
    private String m_ulice_jmeno;
    private long m_katastr_ruian_id;
    private String m_katastr_nazev;
    private long m_katastr_obec_kod;
    private String m_katastr_obec;
    private long m_katastr_okres_kod;
    private String m_katastr_okres;
    private long m_katastr_kraj_kod;
    private String m_katastr_kraj;

    RuianRecord() {
        this.init();
    }

    private void init() {
        this.m_coor_lat = 0.0;
        this.m_coor_lon = 0.0;
        this.m_source = "";
        this.m_objekt_ruian_id = 0L;
        this.m_objekt_podlazi = 0;
        this.m_objekt_byty = 0;
        this.m_objekt_zpusob_vyuziti = "";
        this.m_objekt_zpusob_vyuziti_kod = "";
        this.m_objekt_zpusob_vyuziti_key = "";
        this.m_objekt_zpusob_vyuziti_val = "";
        this.m_objekt_dokonceni = "";
        this.m_objekt_plati_od = "";
        this.m_err_user = "";
        this.m_err_date = "";
        this.m_err_type = "";
        this.m_err_note = "";
        this.m_so_bez_geometrie = new ArrayList();
        this.m_adresni_mista = new ArrayList();
        this.m_parcela_ruian_id = 0L;
        this.m_parcela_druh_pozemku = "";
        this.m_parcela_zpusob_vyuziti = "";
        this.m_parcela_plati_od = "";
        this.m_ulice_ruian_id = 0L;
        this.m_ulice_jmeno = "";
        this.m_katastr_ruian_id = 0L;
        this.m_katastr_nazev = "";
        this.m_katastr_obec_kod = 0L;
        this.m_katastr_obec = "";
        this.m_katastr_okres_kod = 0L;
        this.m_katastr_okres = "";
        this.m_katastr_kraj_kod = 0L;
        this.m_katastr_kraj = "";
    }

    public void parseJSON(String jsonStr) {
        this.init();
        JsonReader jsonReader = Json.createReader((InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
        JsonObject obj = jsonReader.readObject();
        jsonReader.close();
        this.parseCoordinates(obj);
        this.parseStavebniObjekt(obj);
        this.parseNahlasenyProblem(obj);
        this.parseSoBezGeometrie(obj);
        this.parseAdresniMista(obj);
        this.parseParcela(obj);
        this.parseUlice(obj);
        this.parseKatastr(obj);
    }

    private JsonObject getSafeJsonObject(JsonObject obj, String key) {
        JsonArray array;
        JsonValue val = (JsonValue)obj.get((Object)key);
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        if (val instanceof JsonArray && !(array = (JsonArray)val).isEmpty()) {
            return array.getJsonObject(0);
        }
        throw new IllegalArgumentException("No value for " + key);
    }

    private void parseCoordinates(JsonObject obj) {
        try {
            JsonObject coorObjekt = obj.getJsonObject("coordinates");
            try {
                this.m_coor_lat = Double.parseDouble(coorObjekt.getString("lat"));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"coordinates.lat:", (Throwable)e);
            }
            try {
                this.m_coor_lon = Double.parseDouble(coorObjekt.getString("lon"));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"coordinates.lon:", (Throwable)e);
            }
            try {
                this.m_source = obj.getString("source");
            }
            catch (RuntimeException e) {
                Logging.log((Level)Level.WARNING, (String)"source:", (Throwable)e);
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"coordinates:", (Throwable)e);
        }
    }

    private void parseStavebniObjekt(JsonObject obj) {
        try {
            JsonObject stavebniObjekt = this.getSafeJsonObject(obj, "stavebni_objekt");
            try {
                this.m_objekt_ruian_id = Long.parseLong(stavebniObjekt.getString("ruian_id"));
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.ruian_id:", (Throwable)e);
            }
            try {
                this.m_objekt_podlazi = Integer.parseInt(stavebniObjekt.getString("pocet_podlazi"));
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.pocet_podlazi:", (Throwable)e);
            }
            try {
                this.m_objekt_byty = Integer.parseInt(stavebniObjekt.getString("pocet_bytu"));
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.pocet_bytu:", (Throwable)e);
            }
            try {
                this.m_objekt_zpusob_vyuziti = stavebniObjekt.getString("zpusob_vyuziti");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.zpusob_vyuziti:", (Throwable)e);
            }
            try {
                this.m_objekt_zpusob_vyuziti_kod = stavebniObjekt.getString("zpusob_vyuziti_kod");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.m_objekt_zpusob_vyuziti_kod:", (Throwable)e);
            }
            try {
                this.m_objekt_zpusob_vyuziti_key = stavebniObjekt.getString("zpusob_vyuziti_key");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.zpusob_vyuziti_key:", (Throwable)e);
            }
            try {
                this.m_objekt_zpusob_vyuziti_val = stavebniObjekt.getString("zpusob_vyuziti_val");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.m_objekt_zpusob_vyuziti_val:", (Throwable)e);
            }
            try {
                this.m_objekt_plati_od = stavebniObjekt.getString("plati_od");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.plati_od:", (Throwable)e);
            }
            try {
                this.m_objekt_dokonceni = stavebniObjekt.getString("dokonceni");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.dokonceni:", (Throwable)e);
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"stavebni_objekt:", (Throwable)e);
        }
    }

    private void parseNahlasenyProblem(JsonObject obj) {
        try {
            JsonObject errObjekt = this.getSafeJsonObject(obj, "nahlaseny_problem");
            try {
                this.m_err_user = errObjekt.getString("uzivatel");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"nahlaseny_problem.uzivatel:", (Throwable)e);
            }
            try {
                this.m_err_date = errObjekt.getString("datum");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"nahlaseny_problem.datum:", (Throwable)e);
            }
            try {
                this.m_err_type = errObjekt.getString("duvod");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"nahlaseny_problem.duvod:", (Throwable)e);
            }
            try {
                this.m_err_note = errObjekt.getString("poznamka");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"nahlaseny_problem.poznamka:", (Throwable)e);
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"nahlaseny_problem:", (Throwable)e);
        }
    }

    private void parseSoBezGeometrie(JsonObject obj) {
        try {
            JsonArray arr = obj.getJsonArray("so_bez_geometrie");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject soBezGeom = arr.getJsonObject(i);
                ObjectWithoutGeometry so = new ObjectWithoutGeometry();
                try {
                    so.setRuianID(Long.parseLong(soBezGeom.getString("ruian_id")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.ruian_id:", (Throwable)e);
                }
                try {
                    so.setPodlazi(Integer.parseInt(soBezGeom.getString("pocet_podlazi")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.pocet_podlazi:", (Throwable)e);
                }
                try {
                    so.setByty(Integer.parseInt(soBezGeom.getString("pocet_bytu")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.pocet_bytu:", (Throwable)e);
                }
                try {
                    so.setZpusobVyuziti(soBezGeom.getString("zpusob_vyuziti"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.zpusob_vyuziti:", (Throwable)e);
                }
                try {
                    so.setZpusobVyuzitiKod(soBezGeom.getString("zpusob_vyuziti_kod"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.zpusob_vyuziti_kod:", (Throwable)e);
                }
                try {
                    so.setZpusobVyuzitiKey(soBezGeom.getString("zpusob_vyuziti_key"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.zpusob_vyuziti_key:", (Throwable)e);
                }
                try {
                    so.setZpusobVyuzitiVal(soBezGeom.getString("zpusob_vyuziti_val"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.zpusob_vyuziti_val:", (Throwable)e);
                }
                try {
                    so.setDokonceni(soBezGeom.getString("dokonceni"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.dokonceni:", (Throwable)e);
                }
                try {
                    so.setPlatiOd(soBezGeom.getString("plati_od"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.plati_od:", (Throwable)e);
                }
                try {
                    so.setVzdalenost(Float.parseFloat(soBezGeom.getString("vzdalenost")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.vzdalenost:", (Throwable)e);
                }
                this.m_so_bez_geometrie.add(so);
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie:", (Throwable)e);
        }
    }

    private void parseAdresniMista(JsonObject obj) {
        try {
            JsonArray arr = obj.getJsonArray("adresni_mista");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject adresniMisto = arr.getJsonObject(i);
                AddrPlaces am = new AddrPlaces();
                try {
                    am.setRuianID(Long.parseLong(adresniMisto.getString("ruian_id")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.ruian_id:", (Throwable)e);
                }
                try {
                    JsonArray node = adresniMisto.getJsonArray("pozice");
                    am.setPosition(new LatLon(LatLon.roundToOsmPrecision((double)node.getJsonNumber(1).doubleValue()), LatLon.roundToOsmPrecision((double)node.getJsonNumber(0).doubleValue())));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.pozice:", (Throwable)e);
                }
                try {
                    am.setBudovaID(Long.parseLong(adresniMisto.getString("budova_kod")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.budova_kod:", (Throwable)e);
                }
                try {
                    am.setCisloTyp(adresniMisto.getString("cislo_typ"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.cislo_typ:", (Throwable)e);
                }
                try {
                    am.setCisloDomovni(adresniMisto.getString("cislo_domovni"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.cislo_domovni:", (Throwable)e);
                }
                try {
                    am.setCisloOrientacni(adresniMisto.getString("cislo_orientacni"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.cislo_orientacni:", (Throwable)e);
                }
                try {
                    am.setUliceID(Long.parseLong(adresniMisto.getString("ulice_kod")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.ulice_kod:", (Throwable)e);
                }
                try {
                    am.setUlice(adresniMisto.getString("ulice"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.ulice:", (Throwable)e);
                }
                try {
                    am.setCastObceID(Long.parseLong(adresniMisto.getString("cast_obce_kod")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.cast_obce_kod:", (Throwable)e);
                }
                try {
                    am.setCastObce(adresniMisto.getString("cast_obce"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.m_cast_obce:", (Throwable)e);
                }
                try {
                    am.setMestskaCastID(Long.parseLong(adresniMisto.getString("mestska_cast_kod")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.mestska_cast_kod:", (Throwable)e);
                }
                try {
                    am.setMestskaCast(adresniMisto.getString("mestska_cast"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.mestska_cast:", (Throwable)e);
                }
                try {
                    am.setObecID(Long.parseLong(adresniMisto.getString("obec_kod")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.obec_kod:", (Throwable)e);
                }
                try {
                    am.setObec(adresniMisto.getString("obec"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.obec:", (Throwable)e);
                }
                try {
                    am.setOkresID(Long.parseLong(adresniMisto.getString("okres_kod")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.okres_kod:", (Throwable)e);
                }
                try {
                    am.setOkres(adresniMisto.getString("okres"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.okres:", (Throwable)e);
                }
                try {
                    am.setKrajID(Long.parseLong(adresniMisto.getString("kraj_kod")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.kraj_kod:", (Throwable)e);
                }
                try {
                    am.setKraj(adresniMisto.getString("kraj"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.kraj:", (Throwable)e);
                }
                try {
                    am.setPsc(adresniMisto.getString("psc"));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.psc:", (Throwable)e);
                }
                try {
                    am.setVzdalenost(Float.parseFloat(adresniMisto.getString("vzdalenost")));
                }
                catch (Exception e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.vzdalenost:", (Throwable)e);
                }
                this.m_adresni_mista.add(am);
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"adresni_mista:", (Throwable)e);
        }
    }

    private void parseParcela(JsonObject obj) {
        try {
            JsonObject parcela = this.getSafeJsonObject(obj, "parcela");
            try {
                this.m_parcela_ruian_id = Long.parseLong(parcela.getString("ruian_id"));
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"parcela.ruian_id:", (Throwable)e);
            }
            try {
                this.m_parcela_druh_pozemku = parcela.getString("druh_pozemku");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"parcela.druh_pozemku:", (Throwable)e);
            }
            try {
                this.m_parcela_zpusob_vyuziti = parcela.getString("zpusob_vyuziti");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"parcela.zpusob_vyuziti:", (Throwable)e);
            }
            try {
                this.m_parcela_plati_od = parcela.getString("plati_od");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"parcela.plati_od:", (Throwable)e);
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"parcela:", (Throwable)e);
        }
    }

    private void parseUlice(JsonObject obj) {
        try {
            JsonObject ulice = this.getSafeJsonObject(obj, "ulice");
            try {
                this.m_ulice_ruian_id = Long.parseLong(ulice.getString("ruian_id"));
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"ulice.ruian_id:", (Throwable)e);
            }
            try {
                this.m_ulice_jmeno = ulice.getString("jmeno");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"ulice.jmeno:", (Throwable)e);
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"ulice:", (Throwable)e);
        }
    }

    private void parseKatastr(JsonObject obj) {
        try {
            JsonObject katastr = this.getSafeJsonObject(obj, "katastr");
            try {
                this.m_katastr_ruian_id = Long.parseLong(katastr.getString("ruian_id"));
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.ruian_id:", (Throwable)e);
            }
            try {
                this.m_katastr_nazev = katastr.getString("nazev");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.nazev:", (Throwable)e);
            }
            try {
                this.m_katastr_obec_kod = Long.parseLong(katastr.getString("obec_kod"));
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.obec_kod:", (Throwable)e);
            }
            try {
                this.m_katastr_obec = katastr.getString("obec");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.okres:", (Throwable)e);
            }
            try {
                this.m_katastr_okres_kod = Long.parseLong(katastr.getString("okres_kod"));
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.okres_kod:", (Throwable)e);
            }
            try {
                this.m_katastr_okres = katastr.getString("okres");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.okres:", (Throwable)e);
            }
            try {
                this.m_katastr_kraj_kod = Long.parseLong(katastr.getString("kraj_kod"));
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.kraj_kod:", (Throwable)e);
            }
            try {
                this.m_katastr_kraj = katastr.getString("kraj");
            }
            catch (Exception e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.kraj:", (Throwable)e);
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"katastr:", (Throwable)e);
        }
    }

    public String getHtml() {
        String icon_ext_link = "<img src=" + this.getClass().getResource("/images/dialogs/open-external-link.png") + " border=0 alt=\"Zobrazit na extern\u00edch str\u00e1nk\u00e1ch\"/>";
        String icon_ext_link_ruian = "<img src=" + this.getClass().getResource("/images/dialogs/open-external-link.png") + " border=0 alt=\"Zobrazit na str\u00e1nk\u00e1ch RUIAN\"/>";
        String icon_ext_link_kn = "<img src=" + this.getClass().getResource("/images/dialogs/open-external-link-kn.png") + " border=0 alt=\"Zobrazit na str\u00e1nk\u00e1ch katastru nemovitost\u00ed\"/>";
        String icon_copy_tags = "<img src=" + this.getClass().getResource("/images/dialogs/copy-tags.png") + " border=0 alt=\"Kop\u00edrovat tagy\"/>";
        String icon_create_addr = "<img src=" + this.getClass().getResource("/images/dialogs/create-addr.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod\"/>";
        String icon_create_addr_ruian = "<img src=" + this.getClass().getResource("/images/dialogs/create-addr-ruian.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod dle RUIANu\"/>";
        String icon_ruian_error = "<img src=" + this.getClass().getResource("/images/dialogs/create-bug-report.png") + " border=0 alt=\"Nahl\u00e1sit probl\u00e9m v datech\"/>";
        String url_cpost = "http://www.postaonline.cz/vyhledani-psc?p_p_id=psc_WAR_pcpvpp&p_p_lifecycle=1&p_p_state=normal&p_p_mode=view&p_p_col_id=column-1&p_p_col_count=1&_psc_WAR_pcpvpp_struts.portlet.action=%2Fview%2FdetailPost&_psc_WAR_pcpvpp_struts.portlet.mode=view&_psc_WAR_pcpvpp_zipCode=";
        String url_stavebni_objekt = "http://vdp.cuzk.cz/vdp/ruian/stavebniobjekty/";
        String url_adresni_misto = "http://vdp.cuzk.cz/vdp/ruian/adresnimista/";
        String url_parcela = "http://vdp.cuzk.cz/vdp/ruian/parcely/";
        String url_katastralni_uzemi = "http://vdp.cuzk.cz/vdp/ruian/katastralniuzemi/";
        String url_ulice = "http://vdp.cuzk.cz/vdp/ruian/ulice/";
        String url_mistni_cast = "http://vdp.cuzk.cz/vdp/ruian/castiobce/";
        String url_mestska_cast = "http://vdp.cuzk.cz/vdp/ruian/mestskecasti/";
        String url_obec = "http://vdp.cuzk.cz/vdp/ruian/obce/";
        String url_okres = "http://vdp.cuzk.cz/vdp/ruian/okresy/";
        String url_kraj = "http://vdp.cuzk.cz/vdp/ruian/vusc/";
        String url_vlastnici = "http://vdp.cuzk.cz/vdp/ruian/vlastnici?typ=";
        String url_ruian_error = "http://ruian.poloha.net/building.php?kod=";
        StringBuilder r = new StringBuilder();
        if (this.m_objekt_ruian_id == 0L && this.m_parcela_ruian_id == 0L && this.m_adresni_mista.size() == 0 && this.m_ulice_ruian_id == 0L && this.m_katastr_ruian_id == 0L) {
            return "";
        }
        r.append("<html><body bgcolor=\"white\" color=\"black\" ><table><tr><td>");
        r.append("<br/>");
        if (this.m_objekt_ruian_id > 0L) {
            int i;
            r.append("<i><u>Informace o budov\u011b</u></i><br/>").append("<b>RUIAN id: </b>" + this.m_objekt_ruian_id + "&nbsp;&nbsp;<a href=" + url_stavebni_objekt + this.m_objekt_ruian_id + ">" + icon_ext_link_ruian + "</a>").append("&nbsp;&nbsp;<a href=" + url_vlastnici + "so&id=" + this.m_objekt_ruian_id + ">" + icon_ext_link_kn + "</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/building>" + icon_copy_tags + "</a>").append("&nbsp;&nbsp;<a href=" + url_ruian_error + this.m_objekt_ruian_id + ">" + icon_ruian_error + "</a><br/>");
            if (this.m_adresni_mista.size() == 0) {
                r.append("<b>Budova: </b> bez \u010d.p./\u010d.e<br/>");
            } else if (this.m_adresni_mista.get(0).getCisloTyp().equals("\u010c\u00edslo popisn\u00e9")) {
                r.append("<b>Budova: </b>s \u010d\u00edslem popisn\u00fdm<br/>");
            } else {
                r.append("<b>Budova: </b>s \u010d\u00edslem eviden\u010dn\u00edm<br/>");
            }
            if (this.m_objekt_podlazi > 0) {
                r.append("<b>Po\u010det podla\u017e\u00ed: </b>" + this.m_objekt_podlazi + "<br/>");
            }
            if (this.m_objekt_byty > 0) {
                r.append("<b>Po\u010det byt\u016f: </b>" + this.m_objekt_byty + "<br/>");
            }
            r.append("<b>Zp\u016fsob vyu\u017eit\u00ed: </b>" + this.m_objekt_zpusob_vyuziti + "<br/>").append("<b>Datum dokon\u010den\u00ed: </b>" + this.m_objekt_dokonceni + "<br/>").append("<b>Plat\u00ed od: </b>" + this.m_objekt_plati_od + "<br/>");
            if (this.m_adresni_mista.size() > 1) {
                r.append("<i><u>Informace o adrese</u></i><br/>");
                i = 0;
                r.append("<br/>").append("<b>" + this.m_adresni_mista.get(i).getCisloTyp() + "</b> (v\u00edce adres)<b>: </b>" + this.m_adresni_mista.get(i).getCisloDomovni() + "<br/>").append("<b>\u010c\u00e1st obce: </b>" + this.m_adresni_mista.get(i).getCastObce()).append("&nbsp;&nbsp;<a href=" + url_mistni_cast + this.m_adresni_mista.get(i).getCastObceID() + ">" + icon_ext_link_ruian + "</a><br/>");
                if (this.m_adresni_mista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>" + this.m_adresni_mista.get(i).getMestskaCast()).append("&nbsp;&nbsp;<a href=" + url_mestska_cast + this.m_adresni_mista.get(i).getMestskaCastID() + ">" + icon_ext_link_ruian + "</a><br/>");
                }
                r.append("<b>Obec: </b>" + this.m_adresni_mista.get(i).getObec()).append("&nbsp;&nbsp;<a href=" + url_obec + this.m_adresni_mista.get(i).getObecID() + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>Okres: </b>" + this.m_adresni_mista.get(i).getOkres()).append("&nbsp;&nbsp;<a href=" + url_okres + this.m_adresni_mista.get(i).getOkresID() + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>Kraj: </b>" + this.m_adresni_mista.get(i).getKraj()).append("&nbsp;&nbsp;<a href=" + url_kraj + this.m_adresni_mista.get(i).getKrajID() + ">" + icon_ext_link_ruian + "</a><br/>");
            } else if (this.m_adresni_mista.size() == 1 && (this.m_adresni_mista.get(0).getCisloDomovni() == null || this.m_adresni_mista.get(0).getCisloDomovni().isEmpty())) {
                i = 0;
                r.append("<br/>").append("<i><u>Informace o adrese</u></i><br/>").append("<b>Budova: </b>" + this.m_adresni_mista.get(i).getCisloTyp() + "<br/>");
                if (this.m_adresni_mista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>" + this.m_adresni_mista.get(i).getMestskaCast()).append("&nbsp;&nbsp;<a href=" + url_mestska_cast + this.m_adresni_mista.get(i).getMestskaCastID() + ">" + icon_ext_link_ruian + "</a><br/>");
                }
                r.append("<b>Obec: </b>" + this.m_adresni_mista.get(i).getObec()).append("&nbsp;&nbsp;<a href=" + url_obec + this.m_adresni_mista.get(i).getObecID() + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>Okres: </b>" + this.m_adresni_mista.get(i).getOkres()).append("&nbsp;&nbsp;<a href=" + url_okres + this.m_adresni_mista.get(i).getOkresID() + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>Kraj: </b>" + this.m_adresni_mista.get(i).getKraj()).append("&nbsp;&nbsp;<a href=" + url_kraj + this.m_adresni_mista.get(i).getKrajID() + ">" + icon_ext_link_ruian + "</a><br/>");
            } else if (this.m_adresni_mista.size() == 1) {
                i = 0;
                String x = "";
                String x_name = "";
                if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                    x = "/" + this.m_adresni_mista.get(i).getCisloOrientacni();
                    x_name = "/orienta\u010dn\u00ed";
                }
                r.append("<br/>").append("<i><u>Informace o adrese</u></i><br/>").append("<b>RUIAN id: </b>" + this.m_adresni_mista.get(i).getRuianID() + "&nbsp;&nbsp;<a href=" + url_adresni_misto + this.m_adresni_mista.get(i).getRuianID() + ">" + icon_ext_link_ruian + "</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + ">" + icon_copy_tags + "</a>").append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + ">" + icon_create_addr + "</a>").append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + ">" + icon_create_addr_ruian + "</a><br/>").append("<b>" + this.m_adresni_mista.get(i).getCisloTyp() + x_name + ": </b>" + this.m_adresni_mista.get(i).getCisloDomovni() + x).append("<br/>");
                if (!this.m_adresni_mista.get(i).getUlice().isEmpty()) {
                    r.append("<b>Ulice: </b>" + this.m_adresni_mista.get(i).getUlice()).append("&nbsp;&nbsp;<a href=" + url_ulice + this.m_adresni_mista.get(i).getUliceID() + ">" + icon_ext_link_ruian + "</a><br/>");
                }
                r.append("<b>\u010c\u00e1st obce: </b>" + this.m_adresni_mista.get(i).getCastObce()).append("&nbsp;&nbsp;<a href=" + url_mistni_cast + this.m_adresni_mista.get(i).getCastObceID() + ">" + icon_ext_link_ruian + "</a><br/>");
                if (this.m_adresni_mista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>" + this.m_adresni_mista.get(i).getMestskaCast()).append("&nbsp;&nbsp;<a href=" + url_mestska_cast + this.m_adresni_mista.get(i).getMestskaCastID() + ">" + icon_ext_link_ruian + "</a><br/>");
                }
                r.append("<b>Obec: </b>" + this.m_adresni_mista.get(i).getObec()).append("&nbsp;&nbsp;<a href=" + url_obec + this.m_adresni_mista.get(i).getObecID() + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>Okres: </b>" + this.m_adresni_mista.get(i).getOkres()).append("&nbsp;&nbsp;<a href=" + url_okres + this.m_adresni_mista.get(i).getOkresID() + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>Kraj: </b>" + this.m_adresni_mista.get(i).getKraj()).append("&nbsp;&nbsp;<a href=" + url_kraj + this.m_adresni_mista.get(i).getKrajID() + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>PS\u010c: </b>" + this.m_adresni_mista.get(i).getPsc()).append("&nbsp;&nbsp;<a href=" + url_cpost + this.m_adresni_mista.get(i).getPsc() + ">" + icon_ext_link_ruian + "</a><br/>");
            }
            r.append("<br/>");
        }
        if (this.m_objekt_ruian_id > 0L && !this.m_err_user.isEmpty()) {
            r.append("<i><u>Nahl\u00e1\u0161en\u00fd probl\u00e9m</u></i>").append("&nbsp;&nbsp;<a href=" + url_ruian_error + this.m_objekt_ruian_id + ">" + icon_ext_link + "</a><br/>").append("<b>Nahl\u00e1sil: </b>" + this.m_err_user).append("<br/>").append("<b>Dne: </b>" + this.m_err_date).append("<br/>").append("<b>Typ probl\u00e9mu: </b>" + this.m_err_type).append("<br/>");
            if (!this.m_err_note.isEmpty()) {
                r.append("<b>Pozn\u00e1mka: </b>" + this.m_err_note).append("<br/>");
            }
            r.append("<br/>");
        }
        if (this.m_adresni_mista.size() > 1 && this.m_objekt_ruian_id > 0L) {
            String x = "";
            if (this.m_adresni_mista.get(0).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                x = "ev.";
            }
            r.append("<i><u>Adresn\u00ed m\u00edsta</u></i><br/>");
            for (int i = 0; i < this.m_adresni_mista.size(); ++i) {
                r.append(this.m_adresni_mista.get(i).getUlice() + " " + x + this.m_adresni_mista.get(i).getCisloDomovni());
                if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                    r.append("/" + this.m_adresni_mista.get(i).getCisloOrientacni());
                }
                r.append("&nbsp;&nbsp;<a href=" + url_adresni_misto + this.m_adresni_mista.get(i).getRuianID() + ">" + icon_ext_link_ruian + "</a> ").append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + ">" + icon_copy_tags + "</a>").append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + ">" + icon_create_addr + "</a>").append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + ">" + icon_create_addr_ruian + "</a>").append("<br/>");
            }
            r.append("<br/>");
        }
        if (this.m_parcela_ruian_id > 0L) {
            r.append("<i><u>Informace o pozemku</u></i>").append("<br/>").append("<b>RUIAN id: </b>" + this.m_parcela_ruian_id + "&nbsp;&nbsp;<a href=" + url_parcela + this.m_parcela_ruian_id + ">" + icon_ext_link_ruian + "</a>").append("&nbsp;&nbsp;<a href=" + url_vlastnici + "pa&id=" + this.m_parcela_ruian_id + ">" + icon_ext_link_kn + "</a><br/>").append("<b>Druh pozemku: </b>" + this.m_parcela_druh_pozemku + "<br/>");
            if (this.m_parcela_zpusob_vyuziti != "") {
                r.append("<b>Zp\u016fsob vyu\u017eit\u00ed: </b>" + this.m_parcela_zpusob_vyuziti + "<br/>");
            }
            r.append("<b>Plat\u00ed od: </b>" + this.m_parcela_plati_od + "<br/>").append("<br/>");
        }
        if (this.m_ulice_ruian_id > 0L) {
            r.append("<i><u>Informace o ulici</u></i><br/>").append("<b>RUIAN id: </b>" + this.m_ulice_ruian_id + "&nbsp;&nbsp;<a href=" + url_ulice + this.m_ulice_ruian_id + ">" + icon_ext_link_ruian + "</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/street>" + icon_copy_tags + "</a><br/>").append("<b>Jm\u00e9no: </b>" + this.m_ulice_jmeno + "<br/>").append("<br/>");
        }
        if (this.m_katastr_ruian_id > 0L) {
            r.append("<b>Katastr\u00e1ln\u00ed \u00fazem\u00ed: </b>" + this.m_katastr_nazev).append("&nbsp;&nbsp;<a href=" + url_katastralni_uzemi + this.m_katastr_ruian_id + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>Obec: </b>" + this.m_katastr_obec).append("&nbsp;&nbsp;<a href=" + url_obec + this.m_katastr_obec_kod + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>Okres: </b>" + this.m_katastr_okres).append("&nbsp;&nbsp;<a href=" + url_okres + this.m_katastr_okres_kod + ">" + icon_ext_link_ruian + "</a><br/>").append("<b>Kraj: </b>" + this.m_katastr_kraj).append("&nbsp;&nbsp;<a href=" + url_kraj + this.m_katastr_kraj_kod + ">" + icon_ext_link_ruian + "</a><br/>").append("<br/>");
        }
        if (!this.m_adresni_mista.isEmpty() && this.m_objekt_ruian_id == 0L) {
            r.append("<i><u>Adresn\u00ed m\u00edsta v okol\u00ed</u></i><br/>").append("<table>");
            for (int i = 0; i < this.m_adresni_mista.size(); ++i) {
                String x = "";
                String x_name = "";
                if (this.m_adresni_mista.get(i).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                    x = "ev.";
                }
                x = x + this.m_adresni_mista.get(i).getCisloDomovni();
                if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                    x = x + "/" + this.m_adresni_mista.get(i).getCisloOrientacni();
                    x_name = x_name + "/orienta\u010dn\u00ed";
                }
                r.append("<tr><td bgcolor=#e5e5ff>");
                if (!this.m_adresni_mista.get(i).getUlice().isEmpty()) {
                    r.append(this.m_adresni_mista.get(i).getVzdalenost()).append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append(this.m_adresni_mista.get(i).getUlice() + " " + x).append("<br/><u>" + this.m_adresni_mista.get(i).getObec() + "</u>").append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append("<a href=" + url_adresni_misto + this.m_adresni_mista.get(i).getRuianID() + ">" + icon_ext_link_ruian + "</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + ">" + icon_copy_tags + "</a>").append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + ">" + icon_create_addr + "</a>").append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + ">" + icon_create_addr_ruian + "</a>");
                } else {
                    r.append(this.m_adresni_mista.get(i).getVzdalenost()).append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append(this.m_adresni_mista.get(i).getCastObce() + " " + x + "&nbsp;");
                    if (!this.m_adresni_mista.get(i).getCastObce().equals(this.m_adresni_mista.get(i).getObec())) {
                        r.append("<br/><u>" + this.m_adresni_mista.get(i).getObec() + "</u>");
                    }
                    r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append("<a href=" + url_adresni_misto + this.m_adresni_mista.get(i).getRuianID() + ">" + icon_ext_link_ruian + "</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + ">" + icon_copy_tags + "</a>").append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + ">" + icon_create_addr + "</a>").append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + ">" + icon_create_addr_ruian + "</a>");
                }
                r.append("</td></tr>");
            }
            r.append("</table><br/>");
        }
        if (!this.m_so_bez_geometrie.isEmpty()) {
            r.append("<i><u>Budovy bez geometrie v okol\u00ed</u></i><br/>").append("<table>");
            for (int i = 0; i < this.m_so_bez_geometrie.size(); ++i) {
                r.append("<tr><td bgcolor=#e5e5ff>").append(this.m_so_bez_geometrie.get(i).getVzdalenost()).append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append(this.m_so_bez_geometrie.get(i).getRuianID());
                if (this.m_so_bez_geometrie.get(i).getZpusobVyuziti().length() > 0) {
                    r.append(" - " + this.m_so_bez_geometrie.get(i).getZpusobVyuziti());
                }
                r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append("&nbsp;&nbsp;<a href=" + url_stavebni_objekt + this.m_so_bez_geometrie.get(i).getRuianID() + ">" + icon_ext_link_ruian + "</a> ").append("&nbsp;&nbsp;<a href=file://tags.copy/ghost:" + i + ">" + icon_copy_tags + "</a></br>").append("</td></tr>");
            }
            r.append("</table><br/>").append("<br/>");
        }
        r.append("<hr/>").append("<center><i><small>Zdroj: <a href=\"http://www.ruian.cz/\">" + this.m_source + "</a></small></i></center>").append("</td></tr></table></body></html>");
        return r.toString();
    }

    String convertDate(String ruianDate) {
        String r = new String();
        String[] parts = ruianDate.split("\\.");
        try {
            int day = Integer.parseInt(parts[0]);
            int month = Integer.parseInt(parts[1]);
            int year = Integer.parseInt(parts[2]);
            r = Integer.toString(year) + "-" + String.format("%02d", month) + "-" + String.format("%02d", day);
        }
        catch (Exception e) {
            Logging.warn((Throwable)e);
        }
        return r;
    }

    String tagToString(String k, String v) {
        return "\"" + k + "\"=\"" + v + "\"\n";
    }

    String getKeys(String keyType) {
        StringBuilder c = new StringBuilder();
        if (keyType.equals("building") && this.m_objekt_ruian_id > 0L) {
            c.append(this.tagToString("ref:ruian:building", Long.toString(this.m_objekt_ruian_id)));
            if (!this.m_objekt_zpusob_vyuziti_key.isEmpty() && !this.m_objekt_zpusob_vyuziti_val.isEmpty()) {
                c.append(this.tagToString(this.m_objekt_zpusob_vyuziti_key, this.m_objekt_zpusob_vyuziti_val));
            }
            if (this.m_objekt_podlazi > 0) {
                c.append(this.tagToString("building:levels", Integer.toString(this.m_objekt_podlazi)));
            }
            if (this.m_objekt_byty > 0) {
                c.append(this.tagToString("building:flats", Integer.toString(this.m_objekt_byty)));
            }
            if (this.m_objekt_dokonceni.length() > 0 && this.convertDate(this.m_objekt_dokonceni).length() > 0) {
                c.append(this.tagToString("start_date", this.convertDate(this.m_objekt_dokonceni)));
            }
            if (this.m_objekt_zpusob_vyuziti_kod.length() > 0) {
                c.append(this.tagToString("building:ruian:type", this.m_objekt_zpusob_vyuziti_kod));
            }
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        if (keyType.startsWith("ghost") && !this.m_so_bez_geometrie.isEmpty()) {
            String[] key = keyType.split(":");
            int i = Integer.parseInt(key[1]);
            System.out.println("Ghost ID: " + i);
            c.append(this.tagToString("ref:ruian:building", Long.toString(this.m_so_bez_geometrie.get(i).getRuianID())));
            if (this.m_so_bez_geometrie.get(i).getZpusobVyuzitiKey().length() > 0 && this.m_so_bez_geometrie.get(i).getZpusobVyuzitiVal().length() > 0) {
                c.append(this.tagToString(this.m_so_bez_geometrie.get(i).getZpusobVyuzitiKey(), this.m_so_bez_geometrie.get(i).getZpusobVyuzitiVal()));
            }
            if (this.m_so_bez_geometrie.get(i).getPodlazi() > 0) {
                c.append(this.tagToString("building:levels", Integer.toString(this.m_so_bez_geometrie.get(i).getPodlazi())));
            }
            if (this.m_so_bez_geometrie.get(i).getByty() > 0) {
                c.append(this.tagToString("building:flats", Integer.toString(this.m_so_bez_geometrie.get(i).getByty())));
            }
            if (this.m_so_bez_geometrie.get(i).getDokonceni().length() > 0 && this.convertDate(this.m_so_bez_geometrie.get(i).getDokonceni()).length() > 0) {
                c.append(this.tagToString("start_date", this.convertDate(this.m_so_bez_geometrie.get(i).getDokonceni())));
            }
            if (this.m_so_bez_geometrie.get(i).getZpusobVyuzitiKod().length() > 0) {
                c.append(this.tagToString("building:ruian:type", this.m_so_bez_geometrie.get(i).getZpusobVyuzitiKod()));
            }
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        if (keyType.startsWith("address") && !this.m_adresni_mista.isEmpty()) {
            int i;
            if (this.m_adresni_mista.isEmpty()) {
                i = 0;
            } else {
                String[] key = keyType.split(":");
                i = Integer.valueOf(key[1]);
                Logging.info((String)("Address ID: " + i));
            }
            if (!this.m_adresni_mista.get(i).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                c.append(this.tagToString("addr:conscriptionnumber", this.m_adresni_mista.get(i).getCisloDomovni()));
            } else {
                c.append(this.tagToString("addr:provisionalnumber", this.m_adresni_mista.get(i).getCisloDomovni()));
            }
            if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                c.append(this.tagToString("addr:streetnumber", this.m_adresni_mista.get(i).getCisloOrientacni()));
            }
            StringBuilder addr = new StringBuilder();
            if (!this.m_adresni_mista.get(i).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                addr.append(this.m_adresni_mista.get(i).getCisloDomovni());
            } else {
                addr.append("ev." + this.m_adresni_mista.get(i).getCisloDomovni());
            }
            if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                addr.append("/" + this.m_adresni_mista.get(i).getCisloOrientacni());
            }
            c.append(this.tagToString("addr:housenumber", addr.toString()));
            if (!this.m_adresni_mista.get(i).getUlice().isEmpty()) {
                c.append(this.tagToString("addr:street", this.m_adresni_mista.get(i).getUlice()));
            }
            if (this.m_adresni_mista.get(i).getRuianID() > 0L) {
                c.append(this.tagToString("ref:ruian:addr", Long.toString(this.m_adresni_mista.get(i).getRuianID())));
            }
            if (!this.m_adresni_mista.get(i).getCastObce().isEmpty()) {
                c.append(this.tagToString("addr:place", this.m_adresni_mista.get(i).getCastObce()));
            }
            if (!this.m_adresni_mista.get(i).getMestskaCast().isEmpty()) {
                c.append(this.tagToString("addr:suburb", this.m_adresni_mista.get(i).getMestskaCast()));
            }
            if (!this.m_adresni_mista.get(i).getObec().isEmpty()) {
                c.append(this.tagToString("addr:city", this.m_adresni_mista.get(i).getObec()));
            }
            if (!this.m_adresni_mista.get(i).getPsc().isEmpty()) {
                c.append(this.tagToString("addr:postcode", this.m_adresni_mista.get(i).getPsc()));
            }
            c.append(this.tagToString("addr:country", "CZ"));
            c.append(this.tagToString("source:addr", "cuzk:ruian"));
        }
        if (keyType.equals("street") && this.m_ulice_ruian_id > 0L) {
            c.append(this.tagToString("ref:ruian:street", Long.toString(this.m_ulice_ruian_id)));
            c.append(this.tagToString("name", this.m_ulice_jmeno));
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        return c.toString();
    }

    void createAddrPoint(String cmd, String t) {
        Node node;
        LinkedList<AddCommand> commands = new LinkedList<AddCommand>();
        if (cmd.startsWith("tags.create-on-place")) {
            String[] key = cmd.split(":");
            int i = Integer.parseInt(key[1]);
            node = new Node(this.m_adresni_mista.get(i).getPosition());
        } else {
            node = new Node(new LatLon(this.m_coor_lat, this.m_coor_lon));
        }
        commands.add(new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)node));
        LinkedList<Node> coll = new LinkedList<Node>();
        coll.add(node);
        TagCollection tc = new TagCollection();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(t.split("\n")));
        for (String line : list) {
            String[] tag = line.split("\"=\"");
            Logging.info((String)("<" + tag[0] + ">. <" + tag[1] + ">"));
            tc.add(new Tag(tag[0].substring(1), tag[1].substring(0, tag[1].length() - 1)));
        }
        tc.applyTo(coll);
        MainApplication.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Add new address point", (Object[])new Object[0]), commands));
    }

    public void performAction(String act) {
        Logging.info((String)("act: " + act.substring(7)));
        String[] params = act.substring(7).split("/");
        if (!params[0].equals("tags.copy") && !params[0].startsWith("tags.create")) {
            return;
        }
        String task = this.getKeys(params[1]);
        if (params[0].equals("tags.copy") && !task.isEmpty()) {
            ClipboardUtils.copyString((String)task);
            PointInfoUtils.showNotification(I18n.tr((String)"Tags copied to clipboard.", (Object[])new Object[0]), "info");
        }
        if (params[0].startsWith("tags.create") && !task.isEmpty()) {
            this.createAddrPoint(act.substring(7), task);
            PointInfoUtils.showNotification(I18n.tr((String)"New address point added.", (Object[])new Object[0]), "info");
        }
    }
}

