/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.property;

import org.openstreetmap.josm.plugins.graphview.core.access.AccessParameters;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSource;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadPropertyType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyTypes;
import org.openstreetmap.josm.plugins.graphview.core.util.ValueStringParser;

public class RoadIncline
implements RoadPropertyType<Float> {
    @Override
    public <N, W, R, M> Float evaluateN(N node, AccessParameters accessParameters, DataSource<N, W, R, M> dataSource) {
        return null;
    }

    @Override
    public <N, W, R, M> Float evaluateW(W way, boolean forward, AccessParameters accessParameters, DataSource<N, W, R, M> dataSource) {
        Float incline;
        assert (way != null && accessParameters != null && dataSource != null);
        TagGroup tags = dataSource.getTagsW(way);
        String inclineString = tags.getValue("incline");
        if (inclineString != null && (incline = ValueStringParser.parseIncline(inclineString)) != null) {
            if (!forward) {
                incline = Float.valueOf(-incline.floatValue());
            }
            return incline;
        }
        return null;
    }

    @Override
    public boolean isUsable(Object propertyValue, AccessParameters accessParameters) {
        assert (propertyValue instanceof Float);
        float incline = ((Float)propertyValue).floatValue();
        Float maxInclineUp = accessParameters.getVehiclePropertyValue(VehiclePropertyTypes.MAX_INCLINE_UP);
        Float maxInclineDown = accessParameters.getVehiclePropertyValue(VehiclePropertyTypes.MAX_INCLINE_DOWN);
        if (maxInclineUp != null && incline > maxInclineUp.floatValue()) {
            return false;
        }
        return maxInclineDown == null || !(-incline > maxInclineDown.floatValue());
    }
}

