/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.IntList;
import org.apache.poi.util.LittleEndianOutput;

public class IndexRecord
extends StandardRecord {
    public static final short sid = 523;
    private int field_2_first_row;
    private int field_3_last_row_add1;
    private int field_4_zero;
    private IntList field_5_dbcells;

    public IndexRecord() {
    }

    public IndexRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.readInt();
        if (n != 0) {
            throw new RecordFormatException("Expected zero for field 1 but got " + n);
        }
        this.field_2_first_row = recordInputStream.readInt();
        this.field_3_last_row_add1 = recordInputStream.readInt();
        this.field_4_zero = recordInputStream.readInt();
        int n2 = recordInputStream.remaining() / 4;
        this.field_5_dbcells = new IntList(n2);
        for (int i = 0; i < n2; ++i) {
            this.field_5_dbcells.add(recordInputStream.readInt());
        }
    }

    public int getFirstRow() {
        return this.field_2_first_row;
    }

    public int getLastRowAdd1() {
        return this.field_3_last_row_add1;
    }

    public int getNumDbcells() {
        if (this.field_5_dbcells == null) {
            return 0;
        }
        return this.field_5_dbcells.size();
    }

    public int getDbcellAt(int n) {
        return this.field_5_dbcells.get(n);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[INDEX]\n");
        stringBuffer.append("    .firstrow       = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        stringBuffer.append("    .lastrowadd1    = ").append(Integer.toHexString(this.getLastRowAdd1())).append("\n");
        for (int i = 0; i < this.getNumDbcells(); ++i) {
            stringBuffer.append("    .dbcell_").append(i).append(" = ").append(Integer.toHexString(this.getDbcellAt(i))).append("\n");
        }
        stringBuffer.append("[/INDEX]\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(0);
        littleEndianOutput.writeInt(this.getFirstRow());
        littleEndianOutput.writeInt(this.getLastRowAdd1());
        littleEndianOutput.writeInt(this.field_4_zero);
        for (int i = 0; i < this.getNumDbcells(); ++i) {
            littleEndianOutput.writeInt(this.getDbcellAt(i));
        }
    }

    @Override
    protected int getDataSize() {
        return 16 + this.getNumDbcells() * 4;
    }

    @Override
    public short getSid() {
        return 523;
    }

    @Override
    public Object clone() {
        IndexRecord indexRecord = new IndexRecord();
        indexRecord.field_2_first_row = this.field_2_first_row;
        indexRecord.field_3_last_row_add1 = this.field_3_last_row_add1;
        indexRecord.field_4_zero = this.field_4_zero;
        indexRecord.field_5_dbcells = new IntList();
        indexRecord.field_5_dbcells.addAll(this.field_5_dbcells);
        return indexRecord;
    }
}

