/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMember;

public class PTStop
extends RelationMember {
    private Node stopPosition = null;
    private OsmPrimitive platform = null;
    private RelationMember stopPositionRM = null;
    private RelationMember platformRM = null;
    private String name = "";
    private boolean exitOnly;
    private boolean entryOnly;

    public PTStop(RelationMember other) {
        super(other);
        String role = "";
        if (other.getRole().contains("_exit_only")) {
            this.exitOnly = true;
            role = "_exit_only";
        } else if (other.getRole().contains("_entry_only")) {
            this.entryOnly = true;
            role = "_entry_only";
        }
        if (PTStop.isPTStopPosition(other)) {
            this.stopPosition = other.getNode();
            this.name = this.stopPosition.get("name");
            this.stopPositionRM = new RelationMember("stop" + role, other.getMember());
        } else if (PTStop.isPTPlatform(other)) {
            this.platform = other.getMember();
            this.name = this.platform.get("name");
            this.platformRM = new RelationMember("platform" + role, other.getMember());
        } else {
            throw new IllegalArgumentException("The RelationMember type does not match its role " + other.getMember().getName());
        }
    }

    public boolean addStopElement(RelationMember member) {
        String role = "";
        if (member.getRole().contains("_exit_only")) {
            this.exitOnly = true;
            role = "_exit_only";
        } else if (member.getRole().contains("_entry_only")) {
            this.entryOnly = true;
            role = "_entry_only";
        }
        if (this.stopPosition == null && PTStop.isPTStopPosition(member)) {
            this.stopPosition = member.getNode();
            this.stopPositionRM = new RelationMember("stop" + role, member.getMember());
            return true;
        }
        if (this.platform == null && PTStop.isPTPlatform(member)) {
            this.platform = member.getMember();
            this.platformRM = new RelationMember("platform" + role, member.getMember());
            return true;
        }
        return false;
    }

    public Node getStopPosition() {
        return this.stopPosition;
    }

    public OsmPrimitive getPlatform() {
        return this.platform;
    }

    protected String getName() {
        return this.name;
    }

    public void setStopPosition(Node newStopPosition) {
        this.stopPosition = newStopPosition;
    }

    public List<Node> findPotentialStopPositions() {
        ArrayList<Node> potentialStopPositions = new ArrayList<Node>();
        if (this.platform == null) {
            return potentialStopPositions;
        }
        LatLon platformCenter = this.platform.getBBox().getCenter();
        Double ax = platformCenter.getX() - 0.001;
        Double bx = platformCenter.getX() + 0.001;
        Double ay = platformCenter.getY() - 0.001;
        Double by = platformCenter.getY() + 0.001;
        BBox platformBBox = new BBox(ax.doubleValue(), ay.doubleValue(), bx.doubleValue(), by.doubleValue());
        Collection allNodes = this.platform.getDataSet().getNodes();
        String platName = this.platform.get("name");
        for (Node currentNode : allNodes) {
            String nodeName = currentNode.get("name");
            if (!platformBBox.bounds(currentNode.getBBox()) || !currentNode.hasTag("public_transport", "stop_position") || platName != null && nodeName != null && !platName.equals(nodeName)) continue;
            potentialStopPositions.add(currentNode);
        }
        return potentialStopPositions;
    }

    public boolean equalsStop(PTStop other) {
        if (other == null) {
            return false;
        }
        if (this.stopPosition != null && (this.stopPosition == other.getStopPosition() || this.stopPosition == other.getPlatform())) {
            return true;
        }
        return this.platform != null && (this.platform == other.getPlatform() || this.platform == other.getStopPosition());
    }

    public static boolean isPTStop(RelationMember rm) {
        return PTStop.isPTStopPosition(rm) || PTStop.isPTPlatform(rm);
    }

    public static boolean isPTStopPosition(RelationMember rm) {
        return rm.getMember().hasTag("public_transport", "stop_position") && rm.getType().equals((Object)OsmPrimitiveType.NODE);
    }

    public static boolean isPTPlatform(RelationMember rm) {
        return rm.getMember().hasTag("highway", "bus_stop") || rm.getMember().hasTag("public_transport", "platform") || rm.getMember().hasTag("highway", "platform") || rm.getMember().hasTag("railway", "platform");
    }

    public RelationMember getPlatformRM() {
        return this.platformRM;
    }

    public void setPlatformRM(RelationMember platformRM) {
        this.platformRM = platformRM;
    }

    public RelationMember getStopPositionRM() {
        return this.stopPositionRM;
    }

    public void setStopPositionRM(RelationMember stopPositionRM) {
        this.stopPositionRM = stopPositionRM;
    }

    public boolean getExitOnly() {
        return this.exitOnly;
    }

    public void setExitOnly(boolean exitOnly) {
        this.exitOnly = exitOnly;
    }

    public boolean getEntryOnly() {
        return this.entryOnly;
    }

    public void setEntryOnly(boolean entryOnly) {
        this.entryOnly = entryOnly;
    }
}

