/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.graphview.core.graph.GraphEdge;
import org.openstreetmap.josm.plugins.graphview.core.graph.GraphNode;
import org.openstreetmap.josm.plugins.graphview.core.graph.WayGraph;
import org.openstreetmap.josm.plugins.graphview.core.graph.WayGraphObserver;
import org.openstreetmap.josm.plugins.graphview.core.property.GraphEdgeSegments;
import org.openstreetmap.josm.plugins.graphview.core.transition.Segment;
import org.openstreetmap.josm.plugins.graphview.core.transition.SegmentNode;
import org.openstreetmap.josm.plugins.graphview.core.util.GraphUtil;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.ColorScheme;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.LatLonCoords;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.NodePositioner;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.NonMovingNodePositioner;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.GraphViewPreferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class GraphViewLayer
extends Layer
implements WayGraphObserver {
    private static final int NODE_RADIUS = 5;
    private static final double DIRECTIONAL_OFFSET = 20.0;
    private static final double OFFSET_ANGLE = 1.5707963267948966;
    private static final double MIN_QUAD_DISTANCE_FOR_OFFSET = 4.0;
    private static final boolean CONNECT_ALL_NODE_PAIRS = false;
    private static final Shape ARROW_HEAD;
    private static final Shape ARROW_HEAD_CORE;
    private WayGraph wayGraph = null;
    private ColorScheme colorScheme = null;
    private Double arrowheadPlacement = null;
    private NodePositioner nodePositioner = new NonMovingNodePositioner();

    public GraphViewLayer() {
        super("Graph view");
    }

    public void setWayGraph(WayGraph wayGraph) {
        if (this.wayGraph != null) {
            this.wayGraph.deleteObserver(this);
        }
        this.wayGraph = wayGraph;
        if (wayGraph != null) {
            wayGraph.addObserver(this);
        }
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
        this.invalidate();
    }

    public void setArrowheadPlacement(double arrowheadPlacement) {
        assert (arrowheadPlacement >= 0.0 && arrowheadPlacement <= 1.0);
        this.arrowheadPlacement = arrowheadPlacement;
        this.invalidate();
    }

    public void setNodePositioner(NodePositioner nodePositioner) {
        this.nodePositioner = nodePositioner;
        if (nodePositioner == null) {
            this.nodePositioner = new NonMovingNodePositioner();
        }
        this.invalidate();
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"graphview");
    }

    private void paintGraphNode(GraphNode node, Graphics g, MapView mv) {
        Color color = this.colorScheme != null ? this.colorScheme.getNodeColor(node) : Color.LIGHT_GRAY;
        Point p = this.getNodePoint(node, mv);
        GraphViewLayer.paintNode(g, p, color);
    }

    public static void paintNode(Graphics g, Point p, Color color) {
        g.setColor(color);
        g.fillOval(p.x - 5, p.y - 5, 10, 10);
    }

    private void paintGraphEdge(GraphEdge e, Graphics2D g2D, MapView mv, boolean drawLine, boolean drawDirectionIndicator) {
        if (GraphViewPreferences.getInstance().getSeparateDirections() && e.getStartNode().getSegmentNode() == e.getTargetNode().getSegmentNode() && e.getStartNode().getSegment().getNode2() == e.getTargetNode().getSegment().getNode1() && e.getStartNode().getSegment().getNode1() == e.getTargetNode().getSegment().getNode2()) {
            return;
        }
        g2D.setStroke(new BasicStroke(3.0f, 1, 1));
        List<Segment> edgeSegments = e.getPropertyValue(GraphEdgeSegments.PROPERTY);
        if (edgeSegments.size() > 0) {
            Segment firstSegment = edgeSegments.get(0);
            Segment lastSegment = edgeSegments.get(edgeSegments.size() - 1);
            for (Segment segment : edgeSegments) {
                Color color = Color.WHITE;
                if (this.colorScheme != null) {
                    color = this.colorScheme.getSegmentColor(segment);
                }
                g2D.setColor(color);
                Point p1 = GraphViewLayer.getNodePoint(segment.getNode1(), mv);
                Point p2 = GraphViewLayer.getNodePoint(segment.getNode2(), mv);
                if (segment == firstSegment) {
                    p1 = this.getNodePoint(e.getStartNode(), mv);
                }
                if (segment == lastSegment) {
                    p2 = this.getNodePoint(e.getTargetNode(), mv);
                }
                if (!drawLine) continue;
                g2D.draw(new Line2D.Float(p1.x, p1.y, p2.x, p2.y));
            }
        } else {
            Color color = GraphViewPreferences.getInstance().getSegmentColor();
            g2D.setColor(color);
            Point p1 = this.getNodePoint(e.getStartNode(), mv);
            Point p2 = this.getNodePoint(e.getTargetNode(), mv);
            if (drawLine) {
                g2D.draw(new Line2D.Float(p1.x, p1.y, p2.x, p2.y));
            }
        }
        Point p1 = this.getNodePoint(e.getStartNode(), mv);
        Point p2 = this.getNodePoint(e.getTargetNode(), mv);
        if (edgeSegments.size() > 1) {
            Segment lastSegment = edgeSegments.get(edgeSegments.size() - 1);
            p1 = GraphViewLayer.getNodePoint(lastSegment.getNode1(), mv);
        }
        if (drawDirectionIndicator) {
            GraphViewLayer.paintArrowhead(g2D, p1, p2, this.arrowheadPlacement, null, GraphViewPreferences.getInstance().getArrowheadFillColor());
        }
    }

    public static void paintArrowhead(Graphics2D g2D, Point p1, Point p2, Double arrowheadPlacement2, Color casingColor, Color fillColor) {
        Point pTip = new Point((int)((double)p1.x + arrowheadPlacement2 * (double)(p2.x - p1.x)), (int)((double)p1.y + arrowheadPlacement2 * (double)(p2.y - p1.y)));
        double angle = GraphViewLayer.angleFromXAxis(p1, p2);
        if (casingColor != null) {
            g2D.setColor(casingColor);
        }
        Shape head = ARROW_HEAD;
        head = AffineTransform.getRotateInstance(angle).createTransformedShape(head);
        head = AffineTransform.getTranslateInstance(pTip.x, pTip.y).createTransformedShape(head);
        g2D.fill(head);
        if (fillColor != null) {
            g2D.setColor(fillColor);
        }
        Shape headCore = ARROW_HEAD_CORE;
        headCore = AffineTransform.getRotateInstance(angle).createTransformedShape(headCore);
        headCore = AffineTransform.getTranslateInstance(pTip.x, pTip.y).createTransformedShape(headCore);
        g2D.fill(headCore);
    }

    private Point getNodePoint(GraphNode node, MapView mv) {
        Point nodePoint = GraphViewLayer.getNodePoint(this.nodePositioner.getPosition(node), mv);
        if (GraphViewPreferences.getInstance().getSeparateDirections() && !GraphUtil.isEndNode(node)) {
            double segmentY;
            SegmentNode node1 = node.getSegment().getNode1();
            SegmentNode node2 = node.getSegment().getNode2();
            Point node1Point = GraphViewLayer.getNodePoint(node1, mv);
            Point node2Point = GraphViewLayer.getNodePoint(node2, mv);
            double segmentX = node2Point.getX() - node1Point.getX();
            if (segmentX * segmentX + (segmentY = node2Point.getY() - node1Point.getY()) * segmentY >= 4.0) {
                double rotatedX = Math.cos(1.5707963267948966) * segmentX - Math.sin(1.5707963267948966) * segmentY;
                double rotatedY = Math.sin(1.5707963267948966) * segmentX + Math.cos(1.5707963267948966) * segmentY;
                double segmentLength = Math.sqrt(rotatedX * rotatedX + rotatedY * rotatedY);
                double normalizedX = rotatedX / segmentLength;
                double normalizedY = rotatedY / segmentLength;
                nodePoint.x = (int)((double)nodePoint.x + 20.0 * normalizedX);
                nodePoint.y = (int)((double)nodePoint.y + 20.0 * normalizedY);
            }
        }
        return nodePoint;
    }

    private static Point getNodePoint(SegmentNode node, MapView mv) {
        LatLonCoords coords = new LatLonCoords(node.getLat(), node.getLon());
        return GraphViewLayer.getNodePoint(coords, mv);
    }

    private static Point getNodePoint(LatLonCoords coords, MapView mv) {
        LatLon latLon = new LatLon(coords.getLat(), coords.getLon());
        EastNorth eastNorth = Main.getProjection().latlon2eastNorth(latLon);
        return mv.getPoint(eastNorth);
    }

    private static double angleFromXAxis(Point p1, Point p2) {
        assert (p1 != null && p2 != null);
        float vecX = p2.x - p1.x;
        float vecY = p2.y - p1.y;
        float vecLength = (float)Math.sqrt(vecX * vecX + vecY * vecY);
        float dotProductVecAxis = vecX;
        float angle = (float)Math.acos(dotProductVecAxis / vecLength);
        if (p2.y < p1.y) {
            angle = -angle;
        }
        assert (-1.5707963267948966 < (double)angle && (double)angle <= 1.5707963267948966);
        return angle;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        if (this.wayGraph != null) {
            for (GraphNode n : this.wayGraph.getNodes()) {
                this.paintGraphNode(n, g, mv);
            }
            for (GraphEdge e : this.wayGraph.getEdges()) {
                this.paintGraphEdge(e, g, mv, true, false);
            }
            for (GraphEdge e : this.wayGraph.getEdges()) {
                this.paintGraphEdge(e, g, mv, false, true);
            }
        }
    }

    public String getToolTipText() {
        return I18n.tr((String)"Routing graph calculated by the GraphView plugin", (Object[])new Object[0]);
    }

    public void mergeFrom(Layer from) {
        throw new AssertionError((Object)I18n.tr((String)"GraphView layer is not mergable", (Object[])new Object[0]));
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    @Override
    public void update(WayGraph wayGraph) {
        assert (wayGraph == this.wayGraph);
        this.invalidate();
    }

    static {
        Polygon head = new Polygon();
        head.addPoint(0, 0);
        head.addPoint(-22, 6);
        head.addPoint(-22, -6);
        ARROW_HEAD = head;
        Polygon headCore = new Polygon();
        headCore.addPoint(-12, 0);
        headCore.addPoint(-19, 2);
        headCore.addPoint(-19, -2);
        ARROW_HEAD_CORE = headCore;
    }
}

