/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.plugins.turnlanes.model.Issue;
import org.openstreetmap.josm.plugins.turnlanes.model.Validator;
import org.openstreetmap.josm.tools.I18n;

class ValidationPanel
extends JPanel {
    private static final long serialVersionUID = -1585778734201458665L;
    private static final String[] COLUMN_NAMES = new String[]{I18n.tr((String)"Description", (Object[])new Object[0]), I18n.tr((String)"Type", (Object[])new Object[0]), I18n.tr((String)"Quick-Fix", (Object[])new Object[0])};
    private final Action refreshAction = new JosmAction(I18n.tr((String)"Refresh", (Object[])new Object[0]), "dialogs/refresh", I18n.tr((String)"Revalidate all turnlanes-relations.", (Object[])new Object[0]), null, false){
        private static final long serialVersionUID = -8110599654128234810L;

        public void actionPerformed(ActionEvent e) {
            ValidationPanel.this.setIssues(new Validator().validate(MainApplication.getLayerManager().getEditDataSet()));
        }
    };
    private final Action fixAction = new JosmAction(I18n.tr((String)"Fix", (Object[])new Object[0]), "dialogs/fix", I18n.tr((String)"Automatically fixes the issue.", (Object[])new Object[0]), null, false){
        private static final long serialVersionUID = -8110599654128234810L;

        public void actionPerformed(ActionEvent e) {
            if (ValidationPanel.this.selected.getQuickFix().perform()) {
                int i = ValidationPanel.this.issues.indexOf(ValidationPanel.this.selected);
                ValidationPanel.this.issueModel.removeRow(i);
                ValidationPanel.this.issues.remove(i);
            }
        }
    };
    private final Action selectAction = new JosmAction(I18n.tr((String)"Select", (Object[])new Object[0]), "dialogs/select", I18n.tr((String)"Selects the offending relation.", (Object[])new Object[0]), null, false){
        private static final long serialVersionUID = -8110599654128234810L;

        public void actionPerformed(ActionEvent e) {
            if (ValidationPanel.this.selected.getRelation() == null) {
                MainApplication.getLayerManager().getEditDataSet().setSelected(ValidationPanel.this.selected.getPrimitives());
            } else {
                MainApplication.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{ValidationPanel.this.selected.getRelation()});
            }
        }
    };
    private final SideButton refreshButton = new SideButton(this.refreshAction);
    private final SideButton fixButton = new SideButton(this.fixAction);
    private final SideButton selectButton = new SideButton(this.selectAction);
    private final DefaultTableModel issueModel = new DefaultTableModel(COLUMN_NAMES, 0);
    private final List<Issue> issues = new ArrayList<Issue>();
    private final JTable issueTable = new JTable(this.issueModel){
        private static final long serialVersionUID = 6323348290180585298L;

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    private Issue selected;

    ValidationPanel() {
        super(new BorderLayout(4, 4));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 4, 4));
        buttonPanel.add((Component)this.refreshButton);
        buttonPanel.add((Component)this.fixButton);
        buttonPanel.add((Component)this.selectButton);
        this.add((Component)buttonPanel, "North");
        this.add((Component)new JScrollPane(this.issueTable), "Center");
        this.issueTable.setSelectionMode(0);
        this.issueTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = ValidationPanel.this.issueTable.getSelectedRow();
                Issue issue = i >= 0 ? (Issue)ValidationPanel.this.issues.get(i) : null;
                ValidationPanel.this.setSelected(issue);
            }
        });
        this.setSelected(null);
    }

    private void setIssues(List<Issue> issues) {
        this.issueModel.setRowCount(0);
        this.issues.clear();
        for (Issue i : issues) {
            Object[] row = new String[]{i.getDescription(), i.getRelation() == null ? I18n.tr((String)"(none)", (Object[])new Object[0]) : i.getRelation().get("type"), i.getQuickFix().getDescription()};
            this.issueModel.addRow(row);
            this.issues.add(i);
        }
    }

    private void setSelected(Issue selected) {
        this.selected = selected;
        if (selected == null) {
            this.fixButton.setEnabled(false);
            this.selectButton.setEnabled(false);
        } else {
            this.fixButton.setEnabled(selected.getQuickFix() != Issue.QuickFix.NONE);
            this.selectButton.setEnabled(true);
        }
    }
}

