/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.fixAddresses.IAddressEditContainerListener;
import org.openstreetmap.josm.plugins.fixAddresses.IAllKnowingTrashHeap;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.IProblem;
import org.openstreetmap.josm.plugins.fixAddresses.IProblemVisitor;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OSMEntityBase;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreetSegment;
import org.openstreetmap.josm.plugins.fixAddresses.OsmFactory;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class AddressEditContainer
implements OsmPrimitiveVisitor,
DataSetListener,
IAddressEditContainerListener,
IProblemVisitor,
IAllKnowingTrashHeap {
    private Collection<? extends OsmPrimitive> workingSet;
    private HashMap<String, OSMStreet> streetDict = new HashMap(100);
    private List<OSMAddress> unresolvedAddresses = new ArrayList<OSMAddress>(100);
    private List<OSMAddress> incompleteAddresses = new ArrayList<OSMAddress>(100);
    private HashMap<String, OSMStreet> shadowStreetDict = new HashMap(100);
    private List<OSMAddress> shadowUnresolvedAddresses = new ArrayList<OSMAddress>(100);
    private List<OSMAddress> shadowIncompleteAddresses = new ArrayList<OSMAddress>(100);
    private HashSet<Node> visitedNodes = new HashSet();
    private HashSet<Way> visitedWays = new HashSet();
    private HashSet<String> tags = new HashSet();
    private HashMap<String, String> values = new HashMap();
    private List<IProblem> problems = new ArrayList<IProblem>();
    private List<IAddressEditContainerListener> listeners = new ArrayList<IAddressEditContainerListener>();

    public AddressEditContainer() {
        OSMEntityBase.addChangedListener(this);
    }

    protected Collection<? extends OsmPrimitive> getWorkingSet() {
        return this.workingSet;
    }

    public void addChangedListener(IAddressEditContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangedListener(IAddressEditContainerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireContainerChanged() {
        ArrayList<IAddressEditContainerListener> shadowListeners = new ArrayList<IAddressEditContainerListener>(this.listeners);
        for (IAddressEditContainerListener listener : shadowListeners) {
            listener.containerChanged(this);
        }
    }

    protected void fireEntityChanged(IOSMEntity entity) {
        if (entity == null) {
            throw new RuntimeException("Entity must not be null");
        }
        ArrayList<IAddressEditContainerListener> shadowListeners = new ArrayList<IAddressEditContainerListener>(this.listeners);
        for (IAddressEditContainerListener listener : shadowListeners) {
            listener.entityChanged(entity);
        }
    }

    private void markNodeAsVisited(Node n) {
        this.visitedNodes.add(n);
    }

    private boolean hasBeenVisited(Node n) {
        return this.visitedNodes.contains(n);
    }

    private void markWayAsVisited(Way w) {
        this.visitedWays.add(w);
    }

    private boolean hasBeenVisited(Way w) {
        return this.visitedWays.contains(w);
    }

    public void visit(Node n) {
        if (this.hasBeenVisited(n)) {
            return;
        }
        OSMAddress aNode = null;
        aNode = OsmFactory.createNode(n);
        if (aNode != null) {
            this.addAndClassifyAddress(aNode);
            aNode.visit(this, this);
        }
        this.markNodeAsVisited(n);
    }

    public void visit(Way w) {
        if (this.hasBeenVisited(w)) {
            return;
        }
        this.createNodeFromWay(w);
        this.markWayAsVisited(w);
    }

    private void addAndClassifyAddress(OSMAddress aNode) {
        if (!this.assignAddressToStreet(aNode)) {
            this.shadowUnresolvedAddresses.add(aNode);
        }
        if (!aNode.isComplete()) {
            this.shadowIncompleteAddresses.add(aNode);
        }
    }

    private void createNodeFromWay(Way w) {
        IOSMEntity ne = OsmFactory.createNodeFromWay(w);
        if (!this.processNode(ne, w)) {
            for (Node n : w.getNodes()) {
                this.visit(n);
            }
            for (String key : w.keySet()) {
                String v;
                if (!this.tags.contains(key)) {
                    this.tags.add(key);
                }
                if (this.values.containsKey(v = w.get(key))) continue;
                this.values.put(v, key);
            }
        }
    }

    private boolean processNode(IOSMEntity ne, Way w) {
        if (ne != null) {
            OSMStreetSegment newSegment;
            if (ne instanceof OSMStreetSegment && (newSegment = (OSMStreetSegment)ne) != null) {
                String name = newSegment.getName();
                if (StringUtils.isNullOrEmpty(name)) {
                    return false;
                }
                OSMStreet sNode = null;
                if (this.shadowStreetDict.containsKey(name)) {
                    sNode = this.shadowStreetDict.get(name);
                } else {
                    sNode = new OSMStreet((OsmPrimitive)w);
                    this.shadowStreetDict.put(name, sNode);
                }
                if (sNode != null) {
                    sNode.addStreetSegment(newSegment);
                    return true;
                }
                throw new RuntimeException("Street node is null!");
            }
            if (ne instanceof OSMAddress) {
                OSMAddress aNode = (OSMAddress)ne;
                this.addAndClassifyAddress(aNode);
                return true;
            }
        }
        return false;
    }

    public void visit(Relation e) {
    }

    public HashMap<String, OSMStreet> getStreetDict() {
        return this.streetDict;
    }

    public List<OSMAddress> getUnresolvedAddresses() {
        return this.unresolvedAddresses;
    }

    public List<OSMAddress> getIncompleteAddresses() {
        return this.incompleteAddresses;
    }

    public List<OSMStreet> getStreetList() {
        ArrayList<OSMStreet> sortedList = new ArrayList<OSMStreet>(this.streetDict.values());
        Collections.sort(sortedList);
        return sortedList;
    }

    public List<OSMAddress> getUnresolvedItems() {
        return this.unresolvedAddresses;
    }

    public HashSet<String> getTags() {
        return this.tags;
    }

    protected HashMap<String, String> getValues() {
        return this.values;
    }

    public int getNumberOfStreets() {
        return this.streetDict != null ? this.streetDict.size() : 0;
    }

    public int getNumberOfIncompleteAddresses() {
        return this.incompleteAddresses != null ? this.incompleteAddresses.size() : 0;
    }

    public int getNumberOfUnresolvedAddresses() {
        return this.unresolvedAddresses != null ? this.unresolvedAddresses.size() : 0;
    }

    public int getNumberOfInvalidAddresses() {
        return this.getNumberOfIncompleteAddresses() + this.getNumberOfUnresolvedAddresses();
    }

    public int getNumberOfGuesses() {
        int sum = 0;
        for (OSMAddress aNode : this.getAllAddressesToFix()) {
            if (!aNode.hasGuesses()) continue;
            ++sum;
        }
        return sum;
    }

    public List<OSMAddress> getAllAddressesToFix() {
        ArrayList<OSMAddress> all = new ArrayList<OSMAddress>(this.incompleteAddresses);
        for (OSMAddress aNode : this.unresolvedAddresses) {
            if (all.contains(aNode)) continue;
            all.add(aNode);
        }
        return all;
    }

    protected List<IProblem> getProblems() {
        return this.problems;
    }

    protected void clearProblems() {
        this.problems.clear();
    }

    private boolean assignAddressToStreet(OSMAddress aNode) {
        String streetName = aNode.getStreetName();
        if (aNode.isPartOfRelation()) {
            return true;
        }
        if (streetName != null && this.shadowStreetDict.containsKey(streetName)) {
            OSMStreet sNode = this.shadowStreetDict.get(streetName);
            sNode.addAddress(aNode);
            return true;
        }
        return false;
    }

    public void resolveAddresses() {
        ArrayList<OSMAddress> resolvedAddresses = new ArrayList<OSMAddress>();
        for (OSMAddress node : this.shadowUnresolvedAddresses) {
            if (!this.assignAddressToStreet(node)) continue;
            resolvedAddresses.add(node);
        }
        for (OSMAddress resolved : resolvedAddresses) {
            this.shadowUnresolvedAddresses.remove(resolved);
        }
    }

    public void invalidate() {
        if (this.workingSet != null) {
            this.invalidate(this.workingSet);
        } else {
            DataSet ds = MainApplication.getLayerManager().getEditDataSet();
            if (ds != null) {
                this.invalidate(ds.allPrimitives());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Collection<? extends OsmPrimitive> osmData) {
        if (osmData == null || osmData.isEmpty()) {
            return;
        }
        AddressEditContainer addressEditContainer = this;
        synchronized (addressEditContainer) {
            this.clearData();
            this.clearProblems();
            for (OsmPrimitive osmPrimitive : osmData) {
                if (!osmPrimitive.isUsable()) continue;
                osmPrimitive.accept((OsmPrimitiveVisitor)this);
            }
            this.resolveAddresses();
            Collections.sort(this.shadowIncompleteAddresses);
            Collections.sort(this.shadowUnresolvedAddresses);
            this.incompleteAddresses = new ArrayList<OSMAddress>(this.shadowIncompleteAddresses);
            this.unresolvedAddresses = new ArrayList<OSMAddress>(this.shadowUnresolvedAddresses);
            this.streetDict = new HashMap<String, OSMStreet>(this.shadowStreetDict);
            this.shadowStreetDict.clear();
            this.shadowUnresolvedAddresses.clear();
            this.shadowIncompleteAddresses.clear();
            this.fireContainerChanged();
        }
    }

    private void clearData() {
        this.shadowStreetDict.clear();
        this.shadowUnresolvedAddresses.clear();
        this.shadowIncompleteAddresses.clear();
        this.visitedNodes.clear();
        this.visitedWays.clear();
    }

    public void attachToDataSet(Collection<? extends OsmPrimitive> osmDataToWorkOn) {
        if (osmDataToWorkOn != null && !osmDataToWorkOn.isEmpty()) {
            this.workingSet = new ArrayList<OsmPrimitive>(osmDataToWorkOn);
        } else {
            this.detachFromDataSet();
        }
        this.invalidate();
    }

    public void detachFromDataSet() {
        if (this.workingSet != null) {
            this.workingSet.clear();
            this.workingSet = null;
        }
    }

    public void dataChanged(DataChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
        this.invalidate();
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.invalidate();
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
        this.invalidate();
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void containerChanged(AddressEditContainer container) {
        this.invalidate();
    }

    @Override
    public void entityChanged(IOSMEntity entity) {
        this.fireEntityChanged(entity);
    }

    @Override
    public void addProblem(IProblem problem) {
        this.problems.add(problem);
    }

    @Override
    public void removeProblemsOfSource(IOSMEntity entity) {
        CheckParameterUtil.ensureParameterNotNull((Object)entity, (String)"entity");
        ArrayList<IProblem> problemsToRemove = new ArrayList<IProblem>();
        for (IProblem problem : this.problems) {
            if (problem.getSource() != entity) continue;
            problemsToRemove.add(problem);
        }
        for (IProblem iProblem : problemsToRemove) {
            this.problems.remove(iProblem);
        }
    }

    @Override
    public String getClosestStreetName(String name) {
        List<String> matches = this.getClosestStreetNames(name, 1);
        if (matches != null && matches.size() > 0) {
            return matches.get(0);
        }
        return null;
    }

    @Override
    public List<String> getClosestStreetNames(String name, int maxEntries) {
        CheckParameterUtil.ensureParameterNotNull((Object)name, (String)"name");
        if (maxEntries < 1) {
            maxEntries = 1;
        }
        ArrayList<StreetScore> scores = new ArrayList<StreetScore>();
        ArrayList<String> matches = new ArrayList<String>();
        for (String streetName : this.streetDict.keySet()) {
            int score = StringUtils.lcsLength(name, streetName);
            if (score <= 3) continue;
            StreetScore sc = new StreetScore(streetName, score);
            scores.add(sc);
        }
        Collections.sort(scores);
        int n = Math.min(maxEntries, scores.size());
        for (int i = 0; i < n; ++i) {
            matches.add(((StreetScore)scores.get(i)).getName());
        }
        return matches;
    }

    @Override
    public boolean isValidStreetName(String name) {
        if (this.streetDict == null) {
            return false;
        }
        return this.streetDict.containsKey(name);
    }

    private static class StreetScore
    implements Comparable<StreetScore> {
        private String name;
        private int score;

        StreetScore(String name, int score) {
            this.name = name;
            this.score = score;
        }

        protected String getName() {
            return this.name;
        }

        protected int getScore() {
            return this.score;
        }

        @Override
        public int compareTo(StreetScore arg0) {
            if (arg0 == null) {
                return 1;
            }
            return Integer.valueOf(this.score).compareTo(arg0.score);
        }
    }
}

