/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.directdownload;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class GpxServerReader
extends OsmConnection {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GpxData loadGpx(long id) {
        String urlString = OsmApi.getOsmApi().getBaseUrl() + "gpx/" + id + "/data";
        try {
            HttpClient client = HttpClient.create((URL)new URL(urlString));
            this.addAuth(client);
            try (InputStream in = client.connect().uncompressAccordingToContentDisposition(true).getContent();){
                GpxReader r = new GpxReader(in);
                boolean parsedProperly = r.parse(true);
                if (!parsedProperly) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error occurred while parsing gpx file {0}. Only a part of the file will be available.", (Object[])new Object[]{urlString}));
                }
                GpxData gpxData = r.getGpxData();
                return gpxData;
            }
        }
        catch (IOException | OsmTransferException e) {
            Logging.warn((Throwable)e);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error fetching URL {0}", (Object[])new Object[]{urlString}));
            return null;
        }
        catch (SAXException e) {
            Logging.warn((Throwable)e);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error parsing data from URL {0}", (Object[])new Object[]{urlString}));
            return null;
        }
    }
}

